/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.methodhashing;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.TestCase;
import org.jboss.aop.util.MethodHashing;

public class MethodHashingTestCase
extends TestCase {
    public MethodHashingTestCase(String arg0) {
        super(arg0);
    }

    public void testMethodHashingFunctionality() throws Exception {
        Method test1 = TestSubClass.class.getDeclaredMethod("test1", String.class);
        Method test2 = TestSubClass.class.getDeclaredMethod("test2", String.class, Integer.TYPE);
        long test1Hash = MethodHashing.calculateHash((Method)test1);
        long test2Hash = MethodHashing.calculateHash((Method)test2);
        MethodHashingTestCase.assertEquals((long)-129615495583814694L, (long)test1Hash);
        MethodHashingTestCase.assertEquals((long)-1228234556488761696L, (long)test2Hash);
        MethodHashingTestCase.assertEquals((long)test1Hash, (long)MethodHashing.methodHash((Method)test1));
        MethodHashingTestCase.assertEquals((long)test2Hash, (long)MethodHashing.methodHash((Method)test2));
        MethodHashingTestCase.assertEquals((Object)test1, (Object)MethodHashing.findMethodByHash(TestSubClass.class, (long)test1Hash));
        MethodHashingTestCase.assertEquals((Object)test2, (Object)MethodHashing.findMethodByHash(TestSubClass.class, (long)test2Hash));
        Map hashes = MethodHashing.getInterfaceHashes(TestSubClass.class);
        MethodHashingTestCase.assertEquals((int)2, (int)hashes.size());
        long h1 = (Long)hashes.get(test1.toString());
        MethodHashingTestCase.assertEquals((long)test1Hash, (long)h1);
        long h2 = (Long)hashes.get(test2.toString());
        MethodHashingTestCase.assertEquals((long)test2Hash, (long)h2);
        Constructor ctor1 = TestSubClass.class.getDeclaredConstructor(new Class[0]);
        Constructor ctor2 = TestSubClass.class.getDeclaredConstructor(Integer.TYPE);
        long con1Hash = MethodHashing.constructorHash(ctor1);
        long con2Hash = MethodHashing.constructorHash(ctor2);
        MethodHashingTestCase.assertEquals((long)-6451128523270287660L, (long)con1Hash);
        MethodHashingTestCase.assertEquals((long)-4215863789501864959L, (long)con2Hash);
        MethodHashingTestCase.assertEquals(ctor1, (Object)MethodHashing.findConstructorByHash(TestSubClass.class, (long)con1Hash));
        MethodHashingTestCase.assertEquals(ctor2, (Object)MethodHashing.findConstructorByHash(TestSubClass.class, (long)con2Hash));
    }

    static class TestSubClass
    extends TestBaseClass {
        TestSubClass() {
        }

        TestSubClass(int i) {
            super(i);
        }

        void test1(String s) {
        }

        int test2(String s, int i) {
            return i;
        }
    }

    static class TestBaseClass {
        TestBaseClass() {
        }

        TestBaseClass(int i) {
        }

        void test3() {
        }
    }
}

