/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.typedAdvices;

import junit.framework.Assert;
import org.jboss.aop.advice.annotation.Return;
import org.jboss.aop.advice.annotation.Thrown;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.test.aop.typedAdvices.POJO;

public class SimpleAspect {
    public static boolean before;
    public static boolean around;
    public static boolean after;
    public static boolean throwing;
    public static boolean finallyAdvice;
    public static Throwable exception;

    public static void clear() {
        before = false;
        around = false;
        after = false;
        throwing = false;
        finallyAdvice = false;
        POJO.joinPointRun = false;
    }

    public void before() {
        System.out.println("SimpleAspect.before");
        before = true;
        Assert.assertFalse((boolean)POJO.joinPointRun);
    }

    public Object around(Invocation invocation) throws Throwable {
        System.out.println("SimpleAspect.around");
        around = true;
        Assert.assertFalse((boolean)POJO.joinPointRun);
        Object result = invocation.invokeNext();
        Assert.assertTrue((boolean)POJO.joinPointRun);
        return result;
    }

    public int after(@Return int i) {
        System.out.println("SimpleAspect.after");
        after = true;
        Assert.assertTrue((boolean)POJO.joinPointRun);
        return i;
    }

    public void throwing(@Thrown Throwable t) {
        System.out.println("SimpleAspect.throwing");
        exception = t;
        throwing = true;
    }

    public void finallyAdvice() {
        System.out.println("SimpleAspect.finallyAdvice");
        finallyAdvice = true;
        Assert.assertTrue((boolean)POJO.joinPointRun);
    }
}

