/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.log4j;

import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.MDCProvider;
import org.jboss.logging.MDCSupport;
import org.jboss.logging.NDCProvider;
import org.jboss.logging.NDCSupport;
import org.jboss.logging.log4j.Log4jMDCProvider;
import org.jboss.logging.log4j.Log4jNDCProvider;

public class Log4jLoggerPlugin
implements LoggerPlugin,
NDCSupport,
MDCSupport {
    private static final String FQCN = Log4jLoggerPlugin.class.getName();
    private transient Logger log;

    public void init(String name) {
        this.log = LogManager.getLogger(name);
    }

    public Category getCategory() {
        return this.log;
    }

    public Logger getLogger() {
        return this.log;
    }

    public boolean isTraceEnabled() {
        Level l = Level.TRACE;
        if (!this.log.isEnabledFor(l)) {
            return false;
        }
        return l.isGreaterOrEqual(this.log.getEffectiveLevel());
    }

    public void trace(Object message) {
        this.log.log(FQCN, Level.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log.log(FQCN, Level.TRACE, message, t);
    }

    public void trace(String loggerFcqn, Object message, Throwable t) {
        this.log.log(loggerFcqn, Level.TRACE, message, t);
    }

    @Deprecated
    public boolean isDebugEnabled() {
        Level l = Level.DEBUG;
        if (!this.log.isEnabledFor(l)) {
            return false;
        }
        return l.isGreaterOrEqual(this.log.getEffectiveLevel());
    }

    public void debug(Object message) {
        this.log.log(FQCN, Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log.log(FQCN, Level.DEBUG, message, t);
    }

    public void debug(String loggerFcqn, Object message, Throwable t) {
        this.log.log(loggerFcqn, Level.DEBUG, message, t);
    }

    @Deprecated
    public boolean isInfoEnabled() {
        Level l = Level.INFO;
        if (!this.log.isEnabledFor(l)) {
            return false;
        }
        return l.isGreaterOrEqual(this.log.getEffectiveLevel());
    }

    public void info(Object message) {
        this.log.log(FQCN, Level.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log.log(FQCN, Level.INFO, message, t);
    }

    public void info(String loggerFcqn, Object message, Throwable t) {
        this.log.log(loggerFcqn, Level.INFO, message, t);
    }

    public void warn(Object message) {
        this.log.log(FQCN, Level.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log.log(FQCN, Level.WARN, message, t);
    }

    public void warn(String loggerFcqn, Object message, Throwable t) {
        this.log.log(loggerFcqn, Level.WARN, message, t);
    }

    public void error(Object message) {
        this.log.log(FQCN, Level.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log.log(FQCN, Level.ERROR, message, t);
    }

    public void error(String loggerFcqn, Object message, Throwable t) {
        this.log.log(loggerFcqn, Level.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log.log(FQCN, Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log.log(FQCN, Level.FATAL, message, t);
    }

    public void fatal(String loggerFcqn, Object message, Throwable t) {
        this.log.log(loggerFcqn, Level.FATAL, message, t);
    }

    public void log(Priority p, Object message) {
        this.log.log(FQCN, p, message, null);
    }

    public void log(Priority p, Object message, Throwable t) {
        this.log.log(FQCN, p, message, t);
    }

    public void log(Level l, Object message) {
        this.log.log(FQCN, l, message, null);
    }

    public void log(Level l, Object message, Throwable t) {
        this.log.log(FQCN, l, message, t);
    }

    public NDCProvider getNDCProvider() {
        return new Log4jNDCProvider();
    }

    public MDCProvider getMDCProvider() {
        return new Log4jMDCProvider();
    }
}

