/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.annotation.Arg;
import org.jboss.aop.advice.annotation.Args;
import org.jboss.aop.advice.annotation.Caller;
import org.jboss.aop.advice.annotation.JoinPoint;
import org.jboss.aop.advice.annotation.Return;
import org.jboss.aop.advice.annotation.Target;
import org.jboss.aop.advice.annotation.Thrown;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.JoinPointBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ParameterAnnotationRule {
    JOIN_POINT(JoinPoint.class, (Class)JoinPointBean.class, null, -1, 700, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getJoinPointBeanType();
        }
    }
    ,
    INVOCATION(JoinPoint.class, (Class)Invocation.class, null, -2, 700, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getInvocationType();
        }
    }
    ,
    TARGET(Target.class, null, null, -3, 300, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getTargetType();
        }

        public boolean lowerRankGrade(AdviceMethodProperties properties) {
            return !properties.isTargetAvailable();
        }
    }
    ,
    CALLER(Caller.class, null, null, -7, 150, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getCallerType();
        }

        public boolean lowerRankGrade(AdviceMethodProperties properties) {
            return !properties.isCallerAvailable();
        }
    }
    ,
    RETURN(Return.class, null, null, -4, 50, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getJoinpointReturnType();
        }
    }
    ,
    OPTIONAL_THROWN(Thrown.class, Throwable.class, null, -5, 50, false, true),
    MANDATORY_THROWN(Thrown.class, (Class)Throwable.class, (Class)RuntimeException.class, -5, 50, true, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            Type[] joinpointExceptions = properties.getJoinpointExceptions();
            if (joinpointExceptions == null || joinpointExceptions.length == 0) {
                return super.getAssignableFrom(properties);
            }
            return joinpointExceptions;
        }
    }
    ,
    ARG(Arg.class, null, null, -8, 2, false, false){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getJoinpointParameters();
        }
    }
    ,
    ARGS(Args.class, (Class)Object[].class, null, -6, 1, false, true){

        public boolean lowerRankGrade(AdviceMethodProperties properties) {
            return properties.getInvocationType() == FieldReadInvocation.class;
        }
    };

    private Class<? extends Annotation> annotation;
    private Class<?> assignableFrom;
    private Class<?> superType;
    private int rankGrade;
    private boolean mandatory;
    private boolean singleEnforced;
    private int property;

    private ParameterAnnotationRule(Class<? extends Annotation> annotation, Class<?> assignableFrom, Class<?> superType, int property, int rankGrade, boolean mandatory, boolean singleEnforced) {
        this.annotation = annotation;
        this.assignableFrom = assignableFrom;
        this.superType = superType;
        this.property = property;
        this.rankGrade = rankGrade;
        this.mandatory = mandatory;
        this.singleEnforced = singleEnforced;
    }

    public final Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }

    public Object getAssignableFrom(AdviceMethodProperties properties) {
        return this.assignableFrom;
    }

    public Class<?> getSuperType() {
        return this.superType;
    }

    public final int getProperty() {
        return this.property;
    }

    public final int getRankGrade() {
        return this.rankGrade;
    }

    public boolean lowerRankGrade(AdviceMethodProperties properties) {
        return false;
    }

    public final boolean isMandatory() {
        return this.mandatory;
    }

    public final boolean isSingleEnforced() {
        return this.singleEnforced;
    }

    public String toString() {
        return "@" + this.annotation.getSimpleName();
    }
}

