/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.array;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.array.AspectForPrecedence;
import org.jboss.test.aop.array.ClassWithArrayFields;
import org.jboss.test.aop.array.ClassWithSeveralReferencesToSameArray;
import org.jboss.test.aop.array.ClassWithUnadvisedArrayFields;
import org.jboss.test.aop.array.TestArrayElementInterceptor;
import org.jboss.test.aop.array.TestArrayElementReadInterceptor;
import org.jboss.test.aop.array.TestArrayElementWriteInterceptor;

public class AOPArrayTestCase
extends AOPTestWithSetup {
    public AOPArrayTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AOPArrayTestCase");
        suite.addTestSuite(AOPArrayTestCase.class);
        return suite;
    }

    public void testStringArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.strings[2] = "X";
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)"X", (Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        String s = obj.strings[0];
        AOPArrayTestCase.assertEquals((String)"1", (String)s);
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testObjectArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.objects[2] = "X";
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)"X", (Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        Object o = obj.objects[0];
        AOPArrayTestCase.assertEquals((Object)"1", (Object)o);
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testIntArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.ints[1] = 100;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertEquals((int)100, (int)((Integer)TestArrayElementInterceptor.value));
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        obj.ints[2] = 123;
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        int val = obj.ints[2];
        AOPArrayTestCase.assertEquals((int)123, (int)val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testByteArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.bytes[1] = 100;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertEquals((int)100, (int)((Byte)TestArrayElementInterceptor.value).byteValue());
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        obj.bytes[2] = 123;
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        byte val = obj.bytes[2];
        AOPArrayTestCase.assertEquals((int)123, (int)val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testBooleanArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.booleans[1] = true;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertEquals((boolean)true, (boolean)((Boolean)TestArrayElementInterceptor.value));
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        boolean val = obj.booleans[1];
        AOPArrayTestCase.assertEquals((boolean)true, (boolean)val);
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testCharArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.chars[1] = 122;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertEquals((char)'z', (char)((Character)TestArrayElementInterceptor.value).charValue());
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        obj.chars[2] = 120;
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        char val = obj.chars[2];
        AOPArrayTestCase.assertEquals((char)'x', (char)val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testDoubleArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.doubles[1] = 2.1;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        this.assertEquals(2.1, (Double)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        obj.doubles[2] = 9.9;
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        double val = obj.doubles[2];
        this.assertEquals(9.9, val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testFloatArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.floats[1] = 2.1f;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        this.assertEquals(2.1f, ((Float)TestArrayElementInterceptor.value).floatValue());
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        obj.floats[2] = 9.9f;
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        double val = obj.floats[2];
        this.assertEquals(9.9f, val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testLongArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.longs[1] = 100L;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertEquals((long)100L, (long)((Long)TestArrayElementInterceptor.value));
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        obj.longs[2] = 200L;
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        double val = obj.longs[2];
        this.assertEquals(200.0, val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testShortArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        obj.shorts[1] = 50;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertEquals((int)50, (int)((Short)TestArrayElementInterceptor.value).shortValue());
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkWrite();
        obj.shorts[2] = 100;
        this.clearInterceptors();
        AspectForPrecedence.invoked = false;
        double val = obj.shorts[2];
        this.assertEquals(100.0, val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertTrue((boolean)AspectForPrecedence.invoked);
        this.checkRead();
    }

    public void testMultiDimensionalTopLevelArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        int[][] replacement0 = new int[][]{{11, 22}, {33, 44}};
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        int[][] original_0 = obj.ints3d[0];
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        this.checkRead();
        this.clearInterceptors();
        obj.ints3d[0] = replacement0;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertEquals((Object)replacement0, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        int i = obj.ints3d[0][0][1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)22, (int)i);
        this.checkRead();
        this.clearInterceptors();
        obj.ints3d[0][0][1] = 99;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)99, (int)((Integer)TestArrayElementInterceptor.value));
        this.checkReadAndWrite();
        this.clearInterceptors();
        i = original_0[0][1];
        AOPArrayTestCase.assertEquals((int)2, (int)i);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        original_0[0][1] = 100;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
    }

    public void testMultiDimensionalNestedArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        int[] replacement_0_1 = new int[]{111, 222, 333};
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        int[] original_0_1 = obj.ints3d[0][1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        this.checkRead();
        this.clearInterceptors();
        obj.ints3d[0][1] = replacement_0_1;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNotNull((Object)TestArrayElementInterceptor.value);
        AOPArrayTestCase.assertEquals((Object)replacement_0_1, (Object)TestArrayElementInterceptor.value);
        this.checkReadAndWrite();
        this.clearInterceptors();
        int i = obj.ints3d[0][1][2];
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)333, (int)i);
        this.checkRead();
        this.clearInterceptors();
        obj.ints3d[0][0][1] = 99;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)99, (int)((Integer)TestArrayElementInterceptor.value));
        this.checkReadAndWrite();
        this.clearInterceptors();
        original_0_1[1] = 100;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        i = original_0_1[0];
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
    }

    public void testMultipleFieldReferences() {
        ClassWithSeveralReferencesToSameArray obj = new ClassWithSeveralReferencesToSameArray();
        AOPArrayTestCase.assertEquals((Object)obj.one, (Object)obj.two);
        int[] original = obj.one;
        this.clearInterceptors();
        obj.one[1] = 100;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)100, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        int i = obj.one[1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        this.clearInterceptors();
        i = obj.two[1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        AOPArrayTestCase.assertEquals((Object)obj.one, (Object)obj.two);
        this.clearInterceptors();
        int[] replacement1 = new int[]{11, 22};
        obj.one = replacement1;
        this.clearInterceptors();
        obj.one[1] = 99;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)99, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        i = original[1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        obj.two = replacement1;
        this.clearInterceptors();
        obj.one[1] = 101;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)101, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        i = original[1];
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
    }

    public void testMultipleNestedReferences() {
        ClassWithSeveralReferencesToSameArray obj = new ClassWithSeveralReferencesToSameArray();
        AOPArrayTestCase.assertEquals((Object)obj.multi[0], (Object)obj.multi[1]);
        int[] original = obj.multi[0];
        this.clearInterceptors();
        obj.multi[0][1] = 100;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)100, (Object)TestArrayElementInterceptor.value);
        this.checkReadAndWrite();
        this.clearInterceptors();
        int i = obj.multi[0][1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        this.clearInterceptors();
        i = obj.multi[1][1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        AOPArrayTestCase.assertEquals((Object)obj.multi[0], (Object)obj.multi[1]);
        this.clearInterceptors();
        int[] replacement1 = new int[]{11, 22};
        obj.multi[0] = replacement1;
        this.clearInterceptors();
        obj.multi[0][1] = 99;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)99, (Object)TestArrayElementInterceptor.value);
        this.checkReadAndWrite();
        this.clearInterceptors();
        i = original[1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        obj.multi[1] = replacement1;
        this.clearInterceptors();
        obj.multi[0][1] = 101;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)101, (Object)TestArrayElementInterceptor.value);
        this.checkReadAndWrite();
        this.clearInterceptors();
        i = original[1];
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
    }

    public void testMultipleMixedReferences() {
        ClassWithSeveralReferencesToSameArray obj = new ClassWithSeveralReferencesToSameArray();
        obj.one = new int[]{8, 6, 4};
        obj.multi[0] = obj.one;
        int[] original = obj.multi[0];
        this.clearInterceptors();
        obj.multi[0][1] = 100;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)100, (Object)TestArrayElementInterceptor.value);
        this.checkReadAndWrite();
        this.clearInterceptors();
        int i = obj.multi[0][1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        this.clearInterceptors();
        i = obj.one[1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        AOPArrayTestCase.assertEquals((Object)obj.multi[0], (Object)obj.one);
        this.clearInterceptors();
        int[] replacement1 = new int[]{11, 22};
        obj.multi[0] = replacement1;
        this.clearInterceptors();
        obj.multi[0][1] = 99;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)99, (Object)TestArrayElementInterceptor.value);
        this.checkReadAndWrite();
        this.clearInterceptors();
        i = original[1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)100, (int)i);
        this.checkRead();
        obj.one = replacement1;
        this.clearInterceptors();
        obj.multi[0][1] = 101;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)101, (Object)TestArrayElementInterceptor.value);
        this.checkReadAndWrite();
        this.clearInterceptors();
        i = original[1];
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
    }

    public void testObjectArrayWithArrayAsObjectEntry() {
        int[] replacement = new int[]{1, 2, 3};
        ClassWithArrayFields obj = new ClassWithArrayFields();
        this.clearInterceptors();
        obj.objects[0] = replacement;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)replacement, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        replacement[1] = 5;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((int)5, (int)((Integer)TestArrayElementInterceptor.value));
        this.checkWrite();
        this.clearInterceptors();
        obj.objects[0] = "X";
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)"X", (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        replacement[1] = 10;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals(null, (Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
    }

    public void testObjectArrayWithArrayAsObjectEntry2() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        Object[] original = obj.objects;
        obj.objects = new Object[]{new int[]{1, 2, 3}};
        this.clearInterceptors();
        original[0] = "X";
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        Object val = original[0];
        AOPArrayTestCase.assertEquals((Object)"X", (Object)val);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        int[] i = (int[])obj.objects[0];
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkRead();
        this.clearInterceptors();
        i[1] = 10;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)10, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        int ival = i[1];
        AOPArrayTestCase.assertEquals((int)10, (int)ival);
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkRead();
    }

    public void testObjectFieldWithArray() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        obj.objectField = new int[]{1, 2, 3};
        this.clearInterceptors();
        ((int[])obj.objectField)[1] = 10;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)10, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        int val = ((int[])obj.objectField)[2];
        AOPArrayTestCase.assertEquals((int)3, (int)val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkRead();
        int[] array = (int[])obj.objectField;
        this.clearInterceptors();
        val = array[2];
        AOPArrayTestCase.assertEquals((int)3, (int)val);
        AOPArrayTestCase.assertEquals((int)2, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkRead();
        obj.objectField = null;
        this.clearInterceptors();
        val = array[2];
        AOPArrayTestCase.assertEquals((int)3, (int)val);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
    }

    public void testObjectFieldWithNestedArrays() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        obj.objectField = new Object[]{new int[]{1, 2}, new Object[]{"X", "Y"}};
        Object[] objArray = (Object[])obj.objectField;
        this.clearInterceptors();
        int[] intArray = (int[])((Object[])obj.objectField)[0];
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        this.checkRead();
        this.clearInterceptors();
        Object[] objArray2 = (Object[])((Object[])obj.objectField)[1];
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        this.checkRead();
        this.clearInterceptors();
        intArray[1] = 10;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)10, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        int val = intArray[1];
        AOPArrayTestCase.assertEquals((int)10, (int)val);
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkRead();
        this.clearInterceptors();
        objArray2[1] = "ZZZ";
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)"ZZZ", (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        Object oval = objArray2[1];
        AOPArrayTestCase.assertEquals((Object)"ZZZ", (Object)oval);
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkRead();
        this.clearInterceptors();
        int[] intArray2 = new int[]{11, 22};
        objArray[0] = intArray2;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)intArray2, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        intArray2[1] = 10;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)10, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        val = intArray2[1];
        AOPArrayTestCase.assertEquals((int)10, (int)val);
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkRead();
        this.clearInterceptors();
        intArray[1] = 10;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        val = intArray[1];
        AOPArrayTestCase.assertEquals((int)10, (int)val);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        objArray[0] = null;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        objArray[1] = null;
        AOPArrayTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        intArray2[1] = 10;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        val = intArray2[1];
        AOPArrayTestCase.assertEquals((int)10, (int)val);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        objArray2[1] = "ZZZ";
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        this.clearInterceptors();
        oval = objArray2[1];
        AOPArrayTestCase.assertEquals((Object)"ZZZ", (Object)oval);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
    }

    public void testIgnoreDoubleUpdate() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        String sval = "X";
        this.clearInterceptors();
        obj.objects[0] = sval;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)sval, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.objects[0] = sval;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        byte byteVal = 10;
        this.clearInterceptors();
        obj.bytes[0] = byteVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)byteVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.bytes[0] = byteVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        obj.booleans[0] = false;
        boolean booleanVal = true;
        this.clearInterceptors();
        obj.booleans[0] = booleanVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)booleanVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.booleans[0] = booleanVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        booleanVal = false;
        this.clearInterceptors();
        obj.booleans[0] = booleanVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)booleanVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.booleans[0] = booleanVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        char charVal = 'h';
        this.clearInterceptors();
        obj.chars[0] = charVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)Character.valueOf(charVal), (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.chars[0] = charVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        double doubleVal = 101.1;
        this.clearInterceptors();
        obj.doubles[0] = doubleVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)doubleVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.doubles[0] = doubleVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        float floatVal = 66.6f;
        this.clearInterceptors();
        obj.floats[0] = floatVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)Float.valueOf(floatVal), (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.floats[0] = floatVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        int intVal = 1000;
        this.clearInterceptors();
        obj.ints[0] = intVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)intVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.ints[0] = intVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        int[][] intVal2d = new int[][]{{1}, {2}};
        this.clearInterceptors();
        obj.ints3d[0] = intVal2d;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)intVal2d, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.ints3d[0] = intVal2d;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        long longVal = 10001L;
        this.clearInterceptors();
        obj.longs[0] = longVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)longVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.longs[0] = longVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        short shortVal = 999;
        this.clearInterceptors();
        obj.shorts[0] = shortVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)shortVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.shorts[0] = shortVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        int[] objectVal = new int[]{1, 2, 3};
        this.clearInterceptors();
        obj.objects[0] = objectVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)objectVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        obj.objects[0] = objectVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
        intVal = 100;
        this.clearInterceptors();
        objectVal[0] = intVal;
        AOPArrayTestCase.assertEquals((int)0, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertEquals((Object)intVal, (Object)TestArrayElementInterceptor.value);
        this.checkWrite();
        this.clearInterceptors();
        objectVal[0] = intVal;
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        this.checkNoReadWrite();
    }

    public void testUnadvisedArrayFields() {
        ClassWithUnadvisedArrayFields obj = new ClassWithUnadvisedArrayFields();
        this.clearInterceptors();
        obj.objects[0] = "X";
        AOPArrayTestCase.assertEquals((Object)"X", (Object)obj.objects[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
        this.clearInterceptors();
        obj.bytes[0] = 1;
        AOPArrayTestCase.assertEquals((int)1, (int)obj.bytes[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
        this.clearInterceptors();
        obj.booleans[0] = true;
        AOPArrayTestCase.assertEquals((boolean)true, (boolean)obj.booleans[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
        this.clearInterceptors();
        obj.chars[0] = 122;
        AOPArrayTestCase.assertEquals((char)'z', (char)obj.chars[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
        this.clearInterceptors();
        obj.doubles[0] = 9.9;
        this.assertEquals(9.9, obj.doubles[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
        this.clearInterceptors();
        obj.floats[0] = 9.9f;
        this.assertEquals(9.9f, obj.floats[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
        this.clearInterceptors();
        obj.ints[0] = 100;
        AOPArrayTestCase.assertEquals((int)100, (int)obj.ints[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
        this.clearInterceptors();
        obj.longs[0] = 100L;
        AOPArrayTestCase.assertEquals((long)100L, (long)obj.longs[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
        this.clearInterceptors();
        obj.shorts[0] = 100;
        AOPArrayTestCase.assertEquals((int)100, (int)obj.shorts[0]);
        AOPArrayTestCase.assertEquals((int)-1, (int)TestArrayElementInterceptor.index);
        this.checkNoReadWrite();
    }

    public void testBranchesStillValidFollowingInstrumentation() {
        ClassWithArrayFields obj = new ClassWithArrayFields();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            int val;
            int[] ints = new int[]{0, 1, 2};
            if (i >= 1) {
                sb.append("g");
                obj.ints = ints;
                this.clearInterceptors();
                val = ints[i];
                AOPArrayTestCase.assertEquals((int)i, (int)val);
                AOPArrayTestCase.assertEquals((int)i, (int)TestArrayElementInterceptor.index);
                AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
                this.clearInterceptors();
                obj.ints[i] = i + 2;
                AOPArrayTestCase.assertEquals((int)i, (int)TestArrayElementInterceptor.index);
                AOPArrayTestCase.assertEquals((int)(i + 2), (int)((Integer)TestArrayElementInterceptor.value));
                continue;
            }
            sb.append("s");
            obj.ints = ints;
            this.clearInterceptors();
            obj.ints[i] = i + 2;
            AOPArrayTestCase.assertEquals((int)i, (int)TestArrayElementInterceptor.index);
            AOPArrayTestCase.assertEquals((int)(i + 2), (int)((Integer)TestArrayElementInterceptor.value));
            this.clearInterceptors();
            val = ints[i];
            AOPArrayTestCase.assertEquals((int)(i + 2), (int)ints[i]);
            AOPArrayTestCase.assertEquals((int)i, (int)TestArrayElementInterceptor.index);
            AOPArrayTestCase.assertNull((Object)TestArrayElementInterceptor.value);
        }
        AOPArrayTestCase.assertEquals((String)"sgg", (String)sb.toString());
    }

    void clearInterceptors() {
        TestArrayElementInterceptor.clear();
        TestArrayElementReadInterceptor.invoked = false;
        TestArrayElementWriteInterceptor.invoked = false;
    }

    void checkRead() {
        AOPArrayTestCase.assertTrue((boolean)TestArrayElementReadInterceptor.invoked);
        AOPArrayTestCase.assertFalse((boolean)TestArrayElementWriteInterceptor.invoked);
    }

    void checkWrite() {
        AOPArrayTestCase.assertFalse((boolean)TestArrayElementReadInterceptor.invoked);
        AOPArrayTestCase.assertTrue((boolean)TestArrayElementWriteInterceptor.invoked);
    }

    void checkReadAndWrite() {
        AOPArrayTestCase.assertTrue((boolean)TestArrayElementReadInterceptor.invoked);
        AOPArrayTestCase.assertTrue((boolean)TestArrayElementWriteInterceptor.invoked);
    }

    void checkNoReadWrite() {
        AOPArrayTestCase.assertFalse((boolean)TestArrayElementReadInterceptor.invoked);
        AOPArrayTestCase.assertFalse((boolean)TestArrayElementWriteInterceptor.invoked);
    }
}

