/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.beanstyleconfig;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.beanstyleconfig.AdvicePerClass;
import org.jboss.test.aop.beanstyleconfig.AdvicePerInstance;
import org.jboss.test.aop.beanstyleconfig.AdvicePerJoinpoint;
import org.jboss.test.aop.beanstyleconfig.AdvicePerVm;
import org.jboss.test.aop.beanstyleconfig.InterceptorPerClass;
import org.jboss.test.aop.beanstyleconfig.InterceptorPerInstance;
import org.jboss.test.aop.beanstyleconfig.InterceptorPerJoinpoint;
import org.jboss.test.aop.beanstyleconfig.InterceptorPerVm;
import org.jboss.test.aop.beanstyleconfig.InvokedConfig;
import org.jboss.test.aop.beanstyleconfig.InvokedConfigs;
import org.jboss.test.aop.beanstyleconfig.POJO;

public class ConfigTester
extends AOPTestWithSetup {
    public static Test suite() {
        TestSuite suite = new TestSuite("ConfigTester");
        suite.addTestSuite(ConfigTester.class);
        return suite;
    }

    public ConfigTester(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        System.out.println("setup");
        super.setUp();
        InvokedConfigs.clearData();
    }

    public void testPerVm() throws Exception {
        System.out.println("****** testPerVm");
        POJO pojo = new POJO();
        pojo.perVmMethod();
        ArrayList invoked = InvokedConfigs.getInvokedConfigs();
        ConfigTester.assertEquals((String)"Wrong number of interceptions in testPerVm", (int)2, (int)invoked.size());
        System.out.println("****** testPerVm (aspect)");
        InvokedConfig invokedConfig = (InvokedConfig)invoked.get(0);
        ConfigTester.assertEquals((String)"Wrong interceptor class in testPerVm", (String)InterceptorPerVm.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute for interceptor in testPerVm", (int)11, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string for interceptor in testPerVm", (String)InterceptorPerVm.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNull((String)"Advisor was not null in interceptor in testPerVm", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in interceptor in testPerVm", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in interceptor in testPerVm", (Object)invokedConfig.joinpoint);
        System.out.println("****** testPerVm (interceptor)");
        invokedConfig = (InvokedConfig)invoked.get(1);
        ConfigTester.assertEquals((String)"Wrong aspect class in testPerVm", (String)AdvicePerVm.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute in testPerVm", (int)21, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string attribute in testPerVm", (String)AdvicePerVm.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNull((String)"Advisor was not null in aspect in testPerVm", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in aspect in testPerVm", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in aspect in testPerVm", (Object)invokedConfig.joinpoint);
    }

    public void testPerVmStatic() throws Exception {
        System.out.println("****** testPerVmStatic");
        POJO.perVmMethodStatic();
        ArrayList invoked = InvokedConfigs.getInvokedConfigs();
        ConfigTester.assertEquals((String)"Wrong number of interceptions in testPerVmStatic", (int)2, (int)invoked.size());
        System.out.println("****** testPerVmStatic (aspect)");
        InvokedConfig invokedConfig = (InvokedConfig)invoked.get(0);
        ConfigTester.assertEquals((String)"Wrong interceptor class in testPerVmStatic", (String)InterceptorPerVm.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute for interceptor in testPerVmStatic", (int)11, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string for interceptor in testPerVmStatic", (String)InterceptorPerVm.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNull((String)"Advisor was not null in interceptor in testPerVmStatic", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in interceptor in testPerVmStatic", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in interceptor in testPerVmStatic", (Object)invokedConfig.joinpoint);
        System.out.println("****** testPerVmStatic (interceptor)");
        invokedConfig = (InvokedConfig)invoked.get(1);
        ConfigTester.assertEquals((String)"Wrong aspect class in testPerVmStatic", (String)AdvicePerVm.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute in testPerVmStatic", (int)21, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string attribute in testPerVmStatic", (String)AdvicePerVm.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNull((String)"Advisor was not null in aspect in testPerVmStatic", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in aspect in testPerVmStatic", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in aspect in testPerVmStatic", (Object)invokedConfig.joinpoint);
    }

    public void testPerClass() throws Exception {
        System.out.println("****** testPerClass");
        POJO pojo = new POJO();
        pojo.perClassMethod();
        ArrayList invoked = InvokedConfigs.getInvokedConfigs();
        ConfigTester.assertEquals((String)"Wrong number of interceptions in testPerClass", (int)invoked.size(), (int)2);
        System.out.println("****** testPerClass (aspect)");
        InvokedConfig invokedConfig = (InvokedConfig)invoked.get(0);
        ConfigTester.assertEquals((String)"Wrong interceptor class in testPerClass", (String)InterceptorPerClass.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute for interceptor in testPerClass", (int)12, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string for interceptor in testPerClass", (String)InterceptorPerClass.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in interceptor in testPerClass", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in interceptor in testPerClass", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in interceptor in testPerClass", (Object)invokedConfig.joinpoint);
        System.out.println("****** testPerClass (interceptor)");
        invokedConfig = (InvokedConfig)invoked.get(1);
        ConfigTester.assertEquals((String)"Wrong aspect class in testPerClass", (String)AdvicePerClass.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute in testPerClass", (int)22, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string attribute in testPerClass", (String)AdvicePerClass.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in aspect in testPerClass", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in aspect in testPerClass", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in aspect in testPerClass", (Object)invokedConfig.joinpoint);
    }

    public void testPerClassStatic() throws Exception {
        System.out.println("****** testPerClassStatic");
        POJO.perClassMethodStatic();
        ArrayList invoked = InvokedConfigs.getInvokedConfigs();
        ConfigTester.assertEquals((String)"Wrong number of interceptions in testPerClassStatic", (int)2, (int)invoked.size());
        System.out.println("****** testPerClassStatic (aspect)");
        InvokedConfig invokedConfig = (InvokedConfig)invoked.get(0);
        ConfigTester.assertEquals((String)"Wrong interceptor class in testPerClassStatic", (String)InterceptorPerClass.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute for interceptor in testPerClassStatic", (int)12, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string for interceptor in testPerClassStatic", (String)InterceptorPerClass.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in interceptor in testPerClassStatic", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in interceptor in testPerClassStatic", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in interceptor in testPerClassStatic", (Object)invokedConfig.joinpoint);
        System.out.println("****** testPerClassStatic (interceptor)");
        invokedConfig = (InvokedConfig)invoked.get(1);
        ConfigTester.assertEquals((String)"Wrong aspect class in testPerClassStatic", (String)AdvicePerClass.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute in testPerClassStatic", (int)22, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string attribute in testPerClassStatic", (String)AdvicePerClass.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in aspect in testPerClassStatic", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in aspect in testPerClassStatic", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in aspect in testPerClassStatic", (Object)invokedConfig.joinpoint);
    }

    public void testPerInstance() throws Exception {
        System.out.println("****** testPerInstance");
        POJO pojo = new POJO();
        pojo.perInstanceMethod();
        ArrayList invoked = InvokedConfigs.getInvokedConfigs();
        ConfigTester.assertEquals((String)"Wrong number of interceptions in testPerInstance", (int)2, (int)invoked.size());
        System.out.println("****** testPerInstance (aspect)");
        InvokedConfig invokedConfig = (InvokedConfig)invoked.get(0);
        ConfigTester.assertEquals((String)"Wrong interceptor class in testPerInstance", (String)InterceptorPerInstance.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute for interceptor in testPerInstance", (int)13, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string for interceptor in testPerInstance", (String)InterceptorPerInstance.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in interceptor in testPerInstance", (Object)invokedConfig.advisor);
        ConfigTester.assertNotNull((String)"InstanceAdvisor was null in interceptor in testPerInstance", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in interceptor in testPerInstance", (Object)invokedConfig.joinpoint);
        System.out.println("****** testPerInstance (interceptor)");
        invokedConfig = (InvokedConfig)invoked.get(1);
        ConfigTester.assertEquals((String)"Wrong aspect class in testPerInstance", (String)AdvicePerInstance.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute in testPerInstance", (int)23, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string attribute in testPerInstance", (String)AdvicePerInstance.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in aspect in testPerInstance", (Object)invokedConfig.advisor);
        ConfigTester.assertNotNull((String)"InstanceAdvisor was null in aspect in testPerInstance", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNull((String)"Joinpoint was not null in aspect in testPerInstance", (Object)invokedConfig.joinpoint);
    }

    public void testPerInstanceStatic() throws Exception {
        System.out.println("****** testPerInstanceStatic");
        POJO.perInstanceMethodStatic();
        ArrayList invoked = InvokedConfigs.getInvokedConfigs();
        ConfigTester.assertEquals((String)"Wrong number of interceptions in testPerInstanceStatic", (int)invoked.size(), (int)0);
    }

    public void testPerJoinpoint() throws Exception {
        System.out.println("****** testPerJoinpoint");
        POJO pojo = new POJO();
        pojo.perJoinpointMethod();
        ArrayList invoked = InvokedConfigs.getInvokedConfigs();
        ConfigTester.assertEquals((String)"Wrong number of interceptions in testPerJoinpoint", (int)2, (int)invoked.size());
        System.out.println("****** testPerJoinpoint (aspect)");
        InvokedConfig invokedConfig = (InvokedConfig)invoked.get(0);
        ConfigTester.assertEquals((String)"Wrong interceptor class in testPerJoinpoint", (String)InterceptorPerJoinpoint.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute for interceptor in testPerJoinpoint", (int)14, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string for interceptor in testPerJoinpoint", (String)InterceptorPerJoinpoint.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in interceptor in testPerJoinpoint", (Object)invokedConfig.advisor);
        ConfigTester.assertNotNull((String)"InstanceAdvisor was null in interceptor in testPerJoinpoint", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNotNull((String)"Joinpoint was null in interceptor in testPerJoinpoint", (Object)invokedConfig.joinpoint);
        System.out.println("****** testPerJoinpoint (interceptor)");
        invokedConfig = (InvokedConfig)invoked.get(1);
        ConfigTester.assertEquals((String)"Wrong aspect class in testPerJoinpoint", (String)AdvicePerJoinpoint.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute in testPerJoinpoint", (int)24, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string attribute in testPerJoinpoint", (String)AdvicePerJoinpoint.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in aspect in testPerJoinpoint", (Object)invokedConfig.advisor);
        ConfigTester.assertNotNull((String)"InstanceAdvisor was null in aspect in testPerJoinpoint", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNotNull((String)"Joinpoint was null in aspect in testPerJoinpoint", (Object)invokedConfig.joinpoint);
    }

    public void testPerJoinpointStatic() throws Exception {
        System.out.println("****** testPerJoinpointStatic");
        POJO.perJoinpointMethodStatic();
        ArrayList invoked = InvokedConfigs.getInvokedConfigs();
        ConfigTester.assertEquals((String)"Wrong number of interceptions in testPerJoinpointStatic", (int)2, (int)invoked.size());
        System.out.println("****** testPerJoinpointStatic (aspect)");
        InvokedConfig invokedConfig = (InvokedConfig)invoked.get(0);
        ConfigTester.assertEquals((String)"Wrong interceptor class in testPerJoinpointStatic", (String)InterceptorPerJoinpoint.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute for interceptor in testPerJoinpointStatic", (int)14, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string for interceptor in testPerJoinpointStatic", (String)InterceptorPerJoinpoint.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in interceptor in testPerJoinpointStatic", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in interceptor in testPerJoinpointStatic", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNotNull((String)"Joinpoint was null in interceptor in testPerJoinpointStatic", (Object)invokedConfig.joinpoint);
        System.out.println("****** testPerJoinpointStatic (interceptor)");
        invokedConfig = (InvokedConfig)invoked.get(1);
        ConfigTester.assertEquals((String)"Wrong aspect class in testPerJoinpointStatic", (String)AdvicePerJoinpoint.class.getName(), (String)invokedConfig.name);
        ConfigTester.assertEquals((String)"Wrong aspect int attribute in testPerJoinpointStatic", (int)24, (int)invokedConfig.intAttr);
        ConfigTester.assertEquals((String)"Wrong aspect string attribute in testPerJoinpointStatic", (String)AdvicePerJoinpoint.class.getName(), (String)invokedConfig.stringAttr);
        ConfigTester.assertNotNull((String)"Advisor was null in aspect in testPerJoinpointStatic", (Object)invokedConfig.advisor);
        ConfigTester.assertNull((String)"InstanceAdvisor was not null in aspect in testPerJoinpointStatic", (Object)invokedConfig.instanceAdvisor);
        ConfigTester.assertNotNull((String)"Joinpoint was null in aspect in testPerJoinpointStatic", (Object)invokedConfig.joinpoint);
    }
}

