/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.dynamic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.dynamic.Interceptor1;
import org.jboss.test.aop.dynamic.Interceptor2;
import org.jboss.test.aop.dynamic.POJO;
import org.jboss.test.aop.dynamic.POJOPerInstance;
import org.jboss.test.aop.dynamic.POJOProxy;
import org.jboss.test.aop.dynamic.PerInstanceInterceptor1;
import org.jboss.test.aop.dynamic.PerInstanceInterceptor2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDynamicTester
extends AOPTestWithSetup {
    public static Test suite() {
        TestSuite suite = new TestSuite("DynamicTester");
        suite.addTestSuite(SimpleDynamicTester.class);
        return suite;
    }

    public SimpleDynamicTester(String name) {
        super(name);
    }

    public void testDynamic() throws Exception {
        this.reset();
        POJO tmp = new POJO();
        this.assertInstanceOf(tmp, Advised.class);
        this.assertInterceptors(false, false);
        this.addBinding("one", "all(org.jboss.test.aop.dynamic.POJO)", Interceptor1.class);
        this.callPOJO(true, false);
        this.addBinding("two", "all(org.jboss.test.aop.dynamic.POJO)", Interceptor2.class);
        this.callPOJO(true, true);
        AspectManager.instance().removeBinding("one");
        this.callPOJO(false, true);
        this.addBinding("one", "all(org.jboss.test.aop.dynamic.POJO)", Interceptor1.class);
        this.callPOJO(true, true);
        AspectManager.instance().removeBinding("two");
        this.callPOJO(true, false);
        AspectManager.instance().removeBinding("one");
        this.callPOJO(false, false);
    }

    public void testDynamicPerInstance() throws Exception {
        this.reset();
        POJOPerInstance tmp = new POJOPerInstance();
        this.assertInstanceOf(tmp, Advised.class);
        this.assertInterceptors(false, false);
        this.addBinding("one", "all(org.jboss.test.aop.dynamic.POJOPerInstance)", PerInstanceInterceptor1.class);
        this.callPOJOPerInstance(true, false);
        this.addBinding("two", "all(org.jboss.test.aop.dynamic.POJOPerInstance)", PerInstanceInterceptor2.class);
        this.callPOJOPerInstance(true, true);
        AspectManager.instance().removeBinding("one");
        this.callPOJOPerInstance(false, true);
        this.addBinding("one", "all(org.jboss.test.aop.dynamic.POJOPerInstance)", PerInstanceInterceptor1.class);
        this.callPOJOPerInstance(true, true);
        AspectManager.instance().removeBinding("two");
        this.callPOJOPerInstance(true, false);
        AspectManager.instance().removeBinding("one");
        this.callPOJOPerInstance(false, false);
    }

    public void testClassProxyContainer() throws Exception {
        AspectManager manager = AspectManager.instance();
        this.addBinding("one", "all(org.jboss.test.aop.dynamic.POJOProxy)", Interceptor1.class);
        POJOProxy pojo = new POJOProxy();
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setTarget((Object)pojo);
        GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
        POJOProxy proxy = (POJOProxy)factory.createAdvisedProxy(params);
        this.reset();
        proxy.method();
        this.assertInterceptors(true, false);
        this.addBinding("two", "all(org.jboss.test.aop.dynamic.POJOProxy)", Interceptor2.class);
        this.reset();
        proxy.method();
        this.assertInterceptors(true, true);
        manager.removeBinding("one");
        this.reset();
        proxy.method();
        this.assertInterceptors(false, true);
        this.addBinding("one", "all(org.jboss.test.aop.dynamic.POJOProxy)", Interceptor1.class);
        this.reset();
        proxy.method();
        this.assertInterceptors(true, true);
        manager.removeBinding("two");
        this.reset();
        proxy.method();
        this.assertInterceptors(true, false);
        manager.removeBinding("one");
        this.reset();
        proxy.method();
        this.assertInterceptors(false, false);
    }

    private void callPOJO(boolean int1, boolean int2) {
        this.reset();
        POJO pojo = new POJO();
        this.assertInterceptors(int1, int2);
        this.reset();
        pojo.field = 1;
        this.assertInterceptors(int1, int2);
        this.reset();
        SimpleDynamicTester.assertEquals((int)1, (int)pojo.field);
        this.assertInterceptors(int1, int2);
        this.reset();
        pojo.method();
        this.assertInterceptors(int1, int2);
    }

    private void callPOJOPerInstance(boolean int1, boolean int2) {
        this.reset();
        POJOPerInstance pojo = new POJOPerInstance();
        this.assertPerInstanceInterceptors(false, false);
        this.reset();
        pojo.method();
        this.assertPerInstanceInterceptors(int1, int2);
        this.reset();
        pojo.field = 1;
        this.assertPerInstanceInterceptors(int1, int2);
        this.reset();
        SimpleDynamicTester.assertEquals((int)1, (int)pojo.field);
        this.assertPerInstanceInterceptors(int1, int2);
    }

    private void assertInterceptors(boolean int1, boolean int2) {
        SimpleDynamicTester.assertEquals((boolean)int1, (boolean)Interceptor1.intercepted);
        SimpleDynamicTester.assertEquals((boolean)int2, (boolean)Interceptor2.intercepted);
    }

    private void assertPerInstanceInterceptors(boolean int1, boolean int2) {
        SimpleDynamicTester.assertEquals((boolean)int1, (boolean)PerInstanceInterceptor1.intercepted);
        SimpleDynamicTester.assertEquals((boolean)int2, (boolean)PerInstanceInterceptor2.intercepted);
    }

    private void reset() {
        Interceptor1.intercepted = false;
        Interceptor2.intercepted = false;
        PerInstanceInterceptor1.intercepted = false;
        PerInstanceInterceptor2.intercepted = false;
    }

    private void addBinding(String name, String pointcut, Class<?> interceptor) throws ParseException {
        AspectManager manager = AspectManager.instance();
        AdviceBinding binding = new AdviceBinding(pointcut, null);
        binding.setName(name);
        InterceptorFactory factory = manager.getInterceptorFactory(interceptor.getName());
        binding.addInterceptorFactory(factory);
        manager.addBinding(binding);
    }

    public void testDynamicMethod() throws ParseException {
        AdviceBinding binding = new AdviceBinding("execution(public void org.jboss.test.aop.dynamic.POJO->method())", null);
        binding.setName("dynMethod");
        binding.addInterceptor(Interceptor1.class);
        AspectManager.instance().addBinding(binding);
        AdviceBinding binding2 = new AdviceBinding("execution(public void org.jboss.test.aop.dynamic.POJO->method())", null);
        binding2.setName("dynMethod2");
        binding2.addInterceptor(Interceptor2.class);
        AspectManager.instance().addBinding(binding2);
        Interceptor1.intercepted = false;
        POJO p = new POJO();
        p.method();
        SimpleDynamicTester.assertTrue((String)"POJO.method was not intercepted", (boolean)Interceptor1.intercepted);
        Interceptor1.intercepted = false;
        AspectManager.instance().removeBinding("dynMethod");
        p.method();
        SimpleDynamicTester.assertTrue((String)"POJO.method was not intercepted", (boolean)Interceptor2.intercepted);
        SimpleDynamicTester.assertFalse((String)"POJO.method should not be intercepted by Intercepor1", (boolean)Interceptor1.intercepted);
        Interceptor2.intercepted = false;
        AspectManager.instance().removeBinding("dynMethod2");
        p.method();
        SimpleDynamicTester.assertFalse((String)"POJO.method was intercepted", (boolean)Interceptor2.intercepted);
    }

    public void testDynamicField() throws ParseException {
        AdviceBinding binding = new AdviceBinding("set(* org.jboss.test.aop.dynamic.POJO->field)", null);
        binding.setName("set1");
        binding.addInterceptor(Interceptor1.class);
        AspectManager.instance().addBinding(binding);
        AdviceBinding binding2 = new AdviceBinding("get(* org.jboss.test.aop.dynamic.POJO->field)", null);
        binding2.setName("get1");
        binding2.addInterceptor(Interceptor2.class);
        AspectManager.instance().addBinding(binding2);
        AdviceBinding binding3 = new AdviceBinding("field(* org.jboss.test.aop.dynamic.POJO->field)", null);
        binding3.setName("field1");
        binding3.addInterceptor(Interceptor1.class);
        AspectManager.instance().addBinding(binding3);
        Interceptor1.clear();
        Interceptor1.intercepted = false;
        POJO p = new POJO();
        p.field = 7;
        SimpleDynamicTester.assertTrue((String)"POJO.field was not intercepted", (boolean)Interceptor1.intercepted);
        SimpleDynamicTester.assertEquals((String)"POJO.field should have been intercepted 2 times", (int)2, (int)Interceptor1.numberOfInterceptions);
        Interceptor2.intercepted = false;
        int i = p.field;
        SimpleDynamicTester.assertTrue((String)"POJO.field was not intercepted", (boolean)Interceptor2.intercepted);
        SimpleDynamicTester.assertEquals((String)"POJO.field should have been intercepted 3 times", (int)3, (int)Interceptor1.numberOfInterceptions);
        Interceptor1.intercepted = false;
        AspectManager.instance().removeBinding("set1");
        p.field = 4;
        SimpleDynamicTester.assertEquals((String)"POJO.field should have been intercepted 4 times", (int)4, (int)Interceptor1.numberOfInterceptions);
        Interceptor2.intercepted = false;
        AspectManager.instance().removeBinding("get1");
        AspectManager.instance().removeBinding("field1");
        i = p.field;
        p.field = 5;
        SimpleDynamicTester.assertEquals((String)"POJO.field should have been intercepted 4 times", (int)4, (int)Interceptor1.numberOfInterceptions);
        SimpleDynamicTester.assertFalse((String)"POJO.field was intercepted, shouldnt be.", (boolean)Interceptor2.intercepted);
    }
}

