/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.memoryleaks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import junit.framework.TestCase;
import org.jboss.profiler.jvmti.JVMTIInterface;

public class MemoryLeakTestCase
extends TestCase {
    String jbossAopPath;
    String extraClasses;
    Method aspectXmkLoaderUndeployXmlMethod;
    Method aspectManagerInstanceMethod;
    Method aspectManagerUnregisterClassLoader;

    public MemoryLeakTestCase(String name) {
        super(name);
    }

    public MemoryLeakTestCase() {
    }

    public static void main(String[] args) throws Exception {
        MemoryLeakTestCase test = new MemoryLeakTestCase();
        test.testWithClassLoader();
    }

    protected void setUp() throws Exception {
        System.setProperty("jboss.aop.disable.security", "true");
        this.jbossAopPath = System.getProperty("jboss.aop.path");
        this.extraClasses = System.getProperty("extraClasses", null);
        super.setUp();
    }

    private String getProfilerIdentify(Object obj) {
        return obj.getClass().getName() + "@" + System.identityHashCode(obj);
    }

    public void testWithClassLoader() throws Exception {
        LogManager.getLogManager();
        WeakReference<ClassLoader> weakReferenceOnLoader = null;
        Class<?> xmlLoader = null;
        try {
            String className = null;
            final ClassLoader oldloader = Thread.currentThread().getContextClassLoader();
            ClassLoader loader = MemoryLeakTestCase.newClassLoader(oldloader);
            weakReferenceOnLoader = new WeakReference<ClassLoader>(loader);
            Thread.currentThread().setContextClassLoader(loader);
            System.out.println("OLD Loader " + oldloader + ", profiler identify=" + this.getProfilerIdentify(oldloader));
            System.out.println("NEW Loader " + loader + ", profiler identify==" + this.getProfilerIdentify(loader));
            for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                System.out.println("Parent " + parent + " profilerIdentify=" + this.getProfilerIdentify(parent));
            }
            Class testClass = this.getTestCaseClass(loader);
            className = testClass.getName();
            Class<?> aspectManagerClass = loader.loadClass("org.jboss.aop.AspectManager");
            MemoryLeakTestCase.assertNotSame((Object)aspectManagerClass.getClassLoader(), (Object)((Object)((Object)this)).getClass().getClassLoader());
            MemoryLeakTestCase.assertNotSame((Object)aspectManagerClass.getClassLoader(), (Object)testClass.getClassLoader());
            System.out.println("oldLoader");
            xmlLoader = loader.loadClass("org.jboss.aop.AspectXmlLoader");
            this.initMethods(aspectManagerClass, xmlLoader);
            MemoryLeakTestCase.assertNotSame((Object)xmlLoader.getClassLoader(), (Object)loader);
            ArrayList methods = this.getTestMethods(testClass);
            Object testInstance = this.getTestInstance(testClass);
            boolean passed = this.runTests(testInstance, methods);
            MemoryLeakTestCase.assertTrue((boolean)passed);
            this.undeploy(xmlLoader);
            passed = this.runTests(testInstance, methods, true);
            System.out.println("============ Ran tests after undeploy with errors: " + passed);
            this.unregisterClassLoader(aspectManagerClass, loader);
            loader = null;
            testClass = null;
            testInstance = null;
            methods.clear();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(oldloader);
                    return null;
                }
            });
            this.clearEverySingleFieldOnInstances("org.jboss.test.JBossTestSetup");
            this.clearEverySingleFieldOnInstances("org.jboss.test.AbstractTestSetup");
            this.clearEverySingleFieldOnInstances("org.jboss.test.AbstractTestCaseWithSetup");
            MemoryLeakTestCase.assertEquals((int)1, (int)this.countInstances("org.jboss.aop.AspectManager", true));
            if (this.extraClasses != null) {
                StringTokenizer tok = new StringTokenizer(this.extraClasses, ":;,");
                while (tok.hasMoreTokens()) {
                    String clazz = tok.nextToken();
                    try {
                        this.reportInstanceReferences(weakReferenceOnLoader, clazz);
                    }
                    catch (Throwable t) {}
                }
            }
            this.checkUnload(weakReferenceOnLoader, className);
            MemoryLeakTestCase.assertNotNull((String)"The masterClassLoader needs to keep a reference, only the customer's classLoader needs to go away", xmlLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        System.out.println("Done!");
    }

    private Object getTestInstance(Class testClass) throws Exception {
        Constructor<?>[] constructors = testClass.getConstructors();
        Constructor<?> defaultConstructor = null;
        Constructor<?> nameConstructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            System.out.println("found ctor " + constructors[i]);
            Class<?>[] params = constructors[i].getParameterTypes();
            if (params.length == 0) {
                defaultConstructor = constructors[i];
                continue;
            }
            if (params.length != 1 || !params[i].equals(String.class)) continue;
            nameConstructor = constructors[i];
        }
        if (nameConstructor != null) {
            return nameConstructor.newInstance(testClass.getName());
        }
        if (defaultConstructor != null) {
            return defaultConstructor.newInstance(new Object[0]);
        }
        throw new RuntimeException("Could not find a constructor for " + testClass.getName());
    }

    private ArrayList getTestMethods(Class testClass) {
        System.out.println("Determining test methods");
        ArrayList<Method> testMethods = new ArrayList<Method>();
        Method[] methods = testClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName().indexOf("test") != 0 || methods[i].getParameterTypes().length != 0 || !methods[i].getReturnType().equals(Void.TYPE)) continue;
            testMethods.add(methods[i]);
        }
        return testMethods;
    }

    private boolean runTests(Object testInstance, ArrayList methods) {
        return this.runTests(testInstance, methods, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTests(Object testInstance, ArrayList methods, boolean breakOnError) {
        Method setup = null;
        try {
            setup = testInstance.getClass().getDeclaredMethod("setUp", new Class[0]);
            setup.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        Method tearDown = null;
        try {
            tearDown = testInstance.getClass().getDeclaredMethod("tearDown", new Class[0]);
            tearDown.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean passed = true;
        for (Method test : methods) {
            try {
                System.out.println("============ Running test " + testInstance.getClass().getName() + "." + test.getName());
                if (setup != null) {
                    setup.invoke(testInstance, new Object[0]);
                }
                test.invoke(testInstance, new Object[0]);
                if (breakOnError) continue;
                System.out.println("============ Succeeded test " + testInstance.getClass().getName() + "." + test.getName());
            }
            catch (Throwable t) {
                passed = false;
                if (breakOnError) break;
                System.out.println("============ Failed test " + testInstance.getClass().getName() + "." + test.getName() + "\n" + t);
                t.printStackTrace();
            }
            finally {
                if (tearDown == null) continue;
                try {
                    tearDown.invoke(testInstance, new Object[0]);
                }
                catch (Exception e) {}
            }
        }
        return passed;
    }

    private Class getTestCaseClass(ClassLoader loader) throws Exception {
        String className = System.getProperty("test.to.run");
        MemoryLeakTestCase.assertNotNull((String)"Test to be run must be passed in test.to.run system property", (Object)className);
        Class<?> testClass = loader.loadClass(className);
        MemoryLeakTestCase.assertSame((String)"Fix your classpath, this test is not valid", (Object)loader, (Object)testClass.getClassLoader());
        MemoryLeakTestCase.assertNotSame((Object)testClass.getClassLoader(), (Object)((Object)((Object)this)).getClass().getClassLoader());
        return testClass;
    }

    private void checkUnload(WeakReference weakReferenceOnLoader, String className) throws Exception {
        JVMTIInterface jvmti = new JVMTIInterface();
        if (jvmti.isActive()) {
            jvmti.forceReleaseOnSoftReferences();
            jvmti.forceGC();
            Class clazz = jvmti.getClassByName(className);
            if (clazz != null) {
                jvmti.heapSnapshot("snapshot", "mem");
                clazz = null;
                String report = jvmti.exploreClassReferences(className, 15, true, false, false, false, true);
                String reportDir = System.getProperty("leak.report.dir");
                MemoryLeakTestCase.assertNotNull((String)"You must pass in the directory for the reports as leak.report.dir", (Object)reportDir);
                File outputfile = new File(reportDir + "/leak-reoprt-" + className + ".html");
                FileOutputStream outfile = new FileOutputStream(outputfile);
                PrintStream realoutput = new PrintStream(outfile);
                realoutput.println(report);
                realoutput.close();
                jvmti.forceGC();
                clazz = jvmti.getClassByName(className);
                this.clearEverySingleFieldOnInstances("org.jboss.aop.AspectManager");
                clazz = jvmti.getClassByName(className);
                if (clazz == null) {
                    System.out.println("Attention: After clearing every field on AspectManager, GC could release the classLoader");
                }
                MemoryLeakTestCase.fail((String)("Class " + className + " still referenced. Look at report for more details"));
            }
        }
    }

    private void reportInstanceReferences(WeakReference weakReferenceOnLoader, String className) throws Exception {
        JVMTIInterface jvmti = new JVMTIInterface();
        if (jvmti.isActive()) {
            jvmti.forceReleaseOnSoftReferences();
            jvmti.forceGC();
            Class clazz = jvmti.getClassByName(className);
            if (clazz != null) {
                jvmti.heapSnapshot("snapshot", "mem");
                clazz = null;
                Object[] objects = jvmti.getAllObjects(className);
                System.out.println("============> Instances of " + className + " " + objects.length);
                String report = jvmti.exploreObjectReferences(className, 15, false);
                System.out.println("================= " + className + " ================");
                System.out.println(report);
                String reportDir = System.getProperty("leak.report.dir");
                MemoryLeakTestCase.assertNotNull((String)"You must pass in the directory for the reports as leak.report.dir", (Object)reportDir);
                File outputfile = new File(reportDir + "/leak-report-instances" + className + ".html");
                FileOutputStream outfile = new FileOutputStream(outputfile);
                PrintStream realoutput = new PrintStream(outfile);
                realoutput.println(report);
                realoutput.close();
            }
        }
    }

    public Field[] getDeclaredFields(Class clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class classIteration = clazz; classIteration != null; classIteration = classIteration.getSuperclass()) {
            Field[] fields = classIteration.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                list.add(fields[i]);
            }
        }
        return list.toArray(new Field[list.size()]);
    }

    private void clearEverySingleFieldOnInstances(String className) {
        System.out.println("Clearing " + className);
        JVMTIInterface jvmti = new JVMTIInterface();
        Class[] classes = jvmti.getLoadedClasses();
        Object[] objects = null;
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(className)) continue;
            System.out.println("---> Found class " + className);
            Field[] fields = this.getDeclaredFields(classes[i]);
            objects = jvmti.getAllObjects(classes[i]);
            for (int j = 0; j < objects.length; ++j) {
                MemoryLeakTestCase.resetObject(objects[j], fields);
            }
            if (objects.length != 0) continue;
            MemoryLeakTestCase.resetObject(null, fields);
        }
        classes = null;
        objects = null;
    }

    private static void resetObject(Object object, Field[] fields) {
        for (int fieldN = 0; fieldN < fields.length; ++fieldN) {
            try {
                fields[fieldN].set(object, null);
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception  happened during setField " + e);
            }
        }
    }

    private int countInstances(String name, boolean notSubClasses) {
        JVMTIInterface jvmti = new JVMTIInterface();
        Object[] objects = jvmti.getAllObjects(name);
        int subClasses = 0;
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i].getClass().getName().equals(name)) continue;
            ++subClasses;
        }
        return objects.length - subClasses;
    }

    private void unregisterClassLoader(Class aspectManagerClass, ClassLoader loader) throws Exception {
        System.out.println("============ Unregistering ClassLoader");
        Object aspectManager = this.aspectManagerInstanceMethod.invoke(null, new Object[0]);
        this.aspectManagerUnregisterClassLoader.invoke(aspectManager, loader);
    }

    private static void printVariables() {
        Properties props = System.getProperties();
        Enumeration<Object> iter = props.keys();
        System.out.println("properties:");
        while (iter.hasMoreElements()) {
            Object key = iter.nextElement();
            System.out.println(key + "=" + props.get(key));
            System.out.println();
        }
    }

    private static ClassLoader newClassLoader(ClassLoader parent) throws Exception {
        URL classLocation = MemoryLeakTestCase.class.getProtectionDomain().getCodeSource().getLocation();
        StringTokenizer tokenString = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        System.out.println("java.class.path " + System.getProperty("java.class.path"));
        String pathIgnore = System.getProperty("path.ignore");
        System.out.println("path.ignore " + pathIgnore);
        if (pathIgnore == null) {
            pathIgnore = classLocation.toString();
        } else {
            System.out.println("pathIgnore=" + pathIgnore);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenString.hasMoreElements()) {
            String value = tokenString.nextToken();
            URL itemLocation = new File(value).toURI().toURL();
            if (!itemLocation.equals(classLocation) && !itemLocation.toString().equals(pathIgnore)) {
                urls.add(itemLocation);
                continue;
            }
            System.out.println("Skipping " + classLocation);
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        URLClassLoader masterClassLoader = URLClassLoader.newInstance(urlArray, null);
        URLClassLoader appClassLoader = URLClassLoader.newInstance(new URL[]{classLocation}, masterClassLoader);
        return appClassLoader;
    }

    private void initMethods(Class aspectManagerClass, Class xmlLoader) throws Exception {
        this.aspectXmkLoaderUndeployXmlMethod = xmlLoader.getDeclaredMethod("undeployXML", URL.class);
        this.aspectManagerInstanceMethod = aspectManagerClass.getDeclaredMethod("instance", new Class[0]);
        this.aspectManagerUnregisterClassLoader = aspectManagerClass.getDeclaredMethod("unregisterClassLoader", ClassLoader.class);
    }

    private void undeploy(Class xmlLoader) throws Exception {
        String strurl = this.jbossAopPath;
        MemoryLeakTestCase.assertNotNull((String)"Property jboss.aop.path should be defined", (Object)strurl);
        strurl = strurl.replace('\\', '/');
        if (!strurl.startsWith("/")) {
            strurl = "/" + strurl;
        }
        URL url = new URL("file://" + strurl);
        this.aspectXmkLoaderUndeployXmlMethod.invoke(null, url);
        System.out.println("\n====================================================================");
        System.out.println("!!!! Undeployed " + url);
        System.out.println("=====================================================================\n");
    }
}

