/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.perjoinpoint;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.perjoinpoint.ThreadbasedTest;

public class PerJoinpointTester
extends AOPTestWithSetup {
    public static Test suite() {
        TestSuite suite = new TestSuite("PerJoinpointTester");
        suite.addTestSuite(PerJoinpointTester.class);
        return suite;
    }

    public PerJoinpointTester(String name) {
        super(name);
    }

    public void testStaticThreadbased() throws Exception {
        System.out.println("testStaticThreadbased...");
        StaticTask task1 = new StaticTask();
        StaticTask task2 = new StaticTask();
        task1.start();
        Thread.sleep(1000L);
        task2.start();
        task1.join();
        task2.join();
        if (task1.failed || task2.failed) {
            throw new RuntimeException("task failed");
        }
    }

    public void testSharedThreadbased() throws Exception {
        ThreadbasedTest test = new ThreadbasedTest();
        Task task1 = new Task();
        task1.test = test;
        Task task2 = new Task();
        task2.test = test;
        task1.start();
        Thread.sleep(1000L);
        task2.start();
        task1.join();
        task2.join();
        if (task1.failed || task2.failed) {
            throw new RuntimeException("task failed");
        }
    }

    public void testUnsharedThreadbased() throws Exception {
        Task task1 = new Task();
        task1.test = new ThreadbasedTest();
        Task task2 = new Task();
        task2.test = new ThreadbasedTest();
        task1.start();
        Thread.sleep(1000L);
        task2.start();
        task1.join();
        task2.join();
        if (task1.failed || task2.failed) {
            throw new RuntimeException("task failed");
        }
    }

    private class Task
    extends Thread {
        public boolean failed = false;
        public ThreadbasedTest test;

        private Task() {
        }

        public void run() {
            this.test.counter2 = 10;
            for (int i = 0; i < 10; ++i) {
                if (this.test.counter != i) {
                    this.failed = true;
                    break;
                }
                if (this.test.counter2 != i + 10) {
                    this.failed = true;
                    break;
                }
                ++this.test.counter;
                ++this.test.counter2;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.failed = true;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class StaticTask
    extends Thread {
        public boolean failed = false;

        private StaticTask() {
        }

        public void run() {
            ThreadbasedTest.staticCounter2 = 10;
            for (int i = 0; i < 10; ++i) {
                if (ThreadbasedTest.staticCounter != i) {
                    this.failed = true;
                    break;
                }
                if (ThreadbasedTest.staticCounter2 != i + 10) {
                    this.failed = true;
                    break;
                }
                ++ThreadbasedTest.staticCounter;
                ++ThreadbasedTest.staticCounter2;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.failed = true;
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

