/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.serialization.simple;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.serialization.simple.POJO;
import org.jboss.test.aop.serialization.simple.Proxied;
import org.jboss.test.aop.serialization.simple.SimpleInterceptor;

public class SimpleSerialiizationTestCase
extends AOPTestWithSetup {
    public static Test suite() {
        TestSuite suite = new TestSuite("SimpleSerialiizationTestCase");
        suite.addTestSuite(SimpleSerialiizationTestCase.class);
        return suite;
    }

    public SimpleSerialiizationTestCase(String name) {
        super(name);
    }

    public void testWoven() throws Exception {
        SimpleInterceptor.invoked = false;
        POJO pojo = new POJO();
        pojo.someMethod();
        SimpleSerialiizationTestCase.assertTrue((boolean)SimpleInterceptor.invoked);
        byte[] bytes = this.serialize(pojo);
        POJO newPojo = (POJO)this.deserialize(bytes);
        SimpleSerialiizationTestCase.assertNotNull((Object)newPojo);
        SimpleInterceptor.invoked = false;
        newPojo.someMethod();
        SimpleSerialiizationTestCase.assertTrue((boolean)SimpleInterceptor.invoked);
        Proxied proxied = new Proxied();
        SimpleInterceptor.invoked = false;
        proxied.someMethod();
        SimpleSerialiizationTestCase.assertFalse((boolean)SimpleInterceptor.invoked);
        Advisor advisor = ((Advised)pojo)._getAdvisor();
        Advisor newAdvisor = ((Advised)newPojo)._getAdvisor();
        SimpleSerialiizationTestCase.assertSame((Object)advisor, (Object)newAdvisor);
    }

    public void testProxy() throws Exception {
        Proxied tgt = new Proxied();
        URL url = this.getURLRelativeToProjectRoot("/src/resources/test/serialization/simple/manual-aop.xml");
        AspectXmlLoader.deployXML((URL)url);
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setTarget((Object)tgt);
        GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
        Proxied proxied = (Proxied)factory.createAdvisedProxy(params);
        proxied.someMethod();
        SimpleSerialiizationTestCase.assertTrue((boolean)SimpleInterceptor.invoked);
        byte[] bytes = this.serialize(proxied);
        Proxied newProxied = (Proxied)this.deserialize(bytes);
        SimpleSerialiizationTestCase.assertNotNull((Object)newProxied);
        SimpleInterceptor.invoked = false;
        newProxied.someMethod();
        SimpleSerialiizationTestCase.assertTrue((boolean)SimpleInterceptor.invoked);
        Advisor advisor = ((AspectManaged)proxied).getAdvisor();
        Advisor newAdvisor = ((AspectManaged)newProxied).getAdvisor();
        SimpleSerialiizationTestCase.assertSame((Object)advisor, (Object)newAdvisor);
    }
}

