/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotatedAdviceParams;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.annotatedAdviceParams.POJOException;
import org.jboss.test.aop.annotatedAdviceParams.ReturnAspectGenerics;
import org.jboss.test.aop.annotatedAdviceParams.ReturnPOJO;

public class ReturnJDK50TestCase
extends AOPTestWithSetup {
    private ReturnPOJO pojo;

    public static void main(String[] args) {
        TestRunner.run((Test)ReturnJDK50TestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReturnJDK50TestCase");
        suite.addTestSuite(ReturnJDK50TestCase.class);
        return suite;
    }

    public ReturnJDK50TestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        ReturnAspectGenerics.clear();
        this.pojo = new ReturnPOJO();
    }

    public void testGenericsExecution() throws POJOException {
        this.pojo.methodGenericsExecution(false);
        this.assertGenericsAdvices(false);
    }

    public void testGenericsExecutionWithException() {
        boolean thrown = false;
        try {
            this.pojo.methodGenericsExecution(true);
        }
        catch (POJOException e) {
            thrown = true;
        }
        ReturnJDK50TestCase.assertTrue((boolean)thrown);
        this.assertGenericsAdvices(thrown);
    }

    public void testGenericsFieldRead() {
        ReturnJDK50TestCase.assertNull(this.pojo.fieldGenerics);
        this.assertGenericsAdvices(false);
    }

    public void testGenericsCall() throws POJOException {
        this.pojo.methodGenericsCall(false);
        this.assertGenericsAdvices(false);
    }

    public void testGenericsCallWithException() {
        boolean thrown = false;
        try {
            this.pojo.methodGenericsCall(true);
        }
        catch (POJOException e) {
            thrown = true;
        }
        ReturnJDK50TestCase.assertTrue((boolean)thrown);
        this.assertGenericsAdvices(thrown);
    }

    private void assertGenericsAdvices(boolean thrown) {
        ReturnJDK50TestCase.assertTrue((boolean)ReturnAspectGenerics.around3);
        ReturnJDK50TestCase.assertTrue((boolean)ReturnAspectGenerics.around6);
        ReturnJDK50TestCase.assertEquals((!thrown ? 1 : 0) != 0, (boolean)ReturnAspectGenerics.after1);
        ReturnJDK50TestCase.assertEquals((!thrown ? 1 : 0) != 0, (boolean)ReturnAspectGenerics.after2);
        ReturnJDK50TestCase.assertEquals((!thrown ? 1 : 0) != 0, (boolean)ReturnAspectGenerics.after3);
        ReturnJDK50TestCase.assertEquals((!thrown ? 1 : 0) != 0, (boolean)ReturnAspectGenerics.after4);
        ReturnJDK50TestCase.assertEquals((!thrown ? 1 : 0) != 0, (boolean)ReturnAspectGenerics.after6);
        ReturnJDK50TestCase.assertEquals((!thrown ? 1 : 0) != 0, (boolean)ReturnAspectGenerics.after9);
        ReturnJDK50TestCase.assertEquals((!thrown ? 1 : 0) != 0, (boolean)ReturnAspectGenerics.after10);
        ReturnJDK50TestCase.assertTrue((boolean)ReturnAspectGenerics.finally1);
        ReturnJDK50TestCase.assertTrue((boolean)ReturnAspectGenerics.finally2);
        ReturnJDK50TestCase.assertTrue((boolean)ReturnAspectGenerics.finally3);
        ReturnJDK50TestCase.assertTrue((boolean)ReturnAspectGenerics.finally4);
        ReturnJDK50TestCase.assertTrue((boolean)ReturnAspectGenerics.finally6);
        ReturnJDK50TestCase.assertTrue((boolean)ReturnAspectGenerics.finally11);
    }
}

