/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.basic;

import java.util.ArrayList;
import org.jboss.test.aop.basic.Address;

public class Person {
    private String name;
    private int age;
    private Address address;
    private ArrayList hobbies;

    public Person() {
    }

    public Person(String name, int age, Address address) {
        this.name = name;
        this.age = age;
        this.address = address;
        this.hobbies = new ArrayList();
    }

    public void testOptimisticLock() {
        this.name = "Billy";
        this.requiresNew();
    }

    public void requiresNew() {
        this.name = "William";
    }

    public void testRollback() {
        this.name = "Billy";
        throw new RuntimeException("Roll it back");
    }

    public void setNameTransactional(String newName) {
        this.name = newName;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int newAge) {
        this.age = newAge;
    }

    public void testDifferentFields() {
        this.age = 5;
        this.requiresNew();
    }

    public void testOptimisticLockWithAddress() {
        this.address.setCity("Billerica");
        this.requiresNewForAddress();
    }

    public void requiresNewForAddress() {
        this.address.setCity("Rutland");
    }

    public void testRollbackForAddress() {
        this.address.setCity("Billerica");
        throw new RuntimeException("Roll it back");
    }

    public void testDifferentFieldsForAddress() {
        this.address.setState("VT");
        this.requiresNewForAddress();
    }

    public Address getAddress() {
        return this.address;
    }

    public ArrayList getHobbies() {
        return this.hobbies;
    }

    public void testListOptimisticLock() {
        this.hobbies.add("baseball");
        try {
            this.requiresNewForList();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void requiresNewForList() {
        this.hobbies.add("football");
    }

    public void testListRollback() {
        this.hobbies.add("tennis");
        throw new RuntimeException("Roll it back");
    }

    public void addHobby(String hobbie) {
        this.hobbies.add(hobbie);
    }
}

