/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.beforeafterthrowingscoped;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.beforeafterthrowingscoped.CallAction;
import org.jboss.test.aop.beforeafterthrowingscoped.CallerAspect;
import org.jboss.test.aop.beforeafterthrowingscoped.POJOCaller1;
import org.jboss.test.aop.beforeafterthrowingscoped.POJOCaller2;
import org.jboss.test.aop.beforeafterthrowingscoped.PerClassAspect;
import org.jboss.test.aop.beforeafterthrowingscoped.PerClassJoinpointAspect;
import org.jboss.test.aop.beforeafterthrowingscoped.PerInstanceAspect;
import org.jboss.test.aop.beforeafterthrowingscoped.PerJoinpointAspect;
import org.jboss.test.aop.beforeafterthrowingscoped.PerVmAspect;
import org.jboss.test.aop.beforeafterthrowingscoped.SuperPOJOCaller;
import org.jboss.test.aop.beforeafterthrowingscoped.SuperTargetPOJO;
import org.jboss.test.aop.beforeafterthrowingscoped.TargetPOJO1;
import org.jboss.test.aop.beforeafterthrowingscoped.TargetPOJO2;
import org.jboss.test.aop.beforeafterthrowingscoped.ThrownByTestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallerJoinpointScopedTestCase
extends AOPTestWithSetup {
    public CallerJoinpointScopedTestCase(String arg) {
        super(arg);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CallerJoinpointScopedTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("CallerJoinpointScopedTestCase");
        suite.addTestSuite(CallerJoinpointScopedTestCase.class);
        return suite;
    }

    public void testConstructorCall() throws ThrownByTestException {
        for (int i = 0; i < 10; ++i) {
            this.performCall(CallAction.CALL_CONSTRUCTOR);
        }
    }

    public void testMethodCall() throws ThrownByTestException {
        for (int i = 0; i < 10; ++i) {
            this.performCall(CallAction.CALL_METHOD);
        }
    }

    public void testStaticMethodCall() throws ThrownByTestException {
        for (int i = 0; i < 10; ++i) {
            this.performCall(CallAction.CALL_STATIC_METHOD);
        }
    }

    public void performCall(CallAction callAction) throws ThrownByTestException {
        SuperTargetPOJO[] targets;
        this.resetAll();
        for (SuperTargetPOJO target : targets = new SuperTargetPOJO[]{new SuperTargetPOJO(), new TargetPOJO1(), new TargetPOJO2()}) {
            this.createAndExecuteMethod(callAction, target);
            this.executeStaticMethod(callAction, target);
        }
    }

    private void createAndExecuteMethod(CallAction callAction, SuperTargetPOJO target) throws ThrownByTestException {
        String superJoinPointByCon = "super" + (Object)((Object)callAction) + "bycon";
        String joinPointByCon1 = (Object)((Object)callAction) + "bycon1";
        String joinPointByCon2 = (Object)((Object)callAction) + "bycon2";
        SuperPOJOCaller superCaller = new SuperPOJOCaller(target, callAction, false);
        this.checkAspects(superCaller, SuperPOJOCaller.class, superJoinPointByCon, false);
        boolean exceptionThrown = false;
        try {
            new SuperPOJOCaller(target, callAction, true);
        }
        catch (ThrownByTestException e) {
            exceptionThrown = true;
        }
        CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
        this.checkAspects(CallerAspect.CALLER, SuperPOJOCaller.class, superJoinPointByCon, exceptionThrown);
        POJOCaller1 caller1 = new POJOCaller1(target, callAction, false);
        this.checkAspects(caller1, POJOCaller1.class, joinPointByCon1, false);
        try {
            new POJOCaller1(target, callAction, true);
        }
        catch (ThrownByTestException e) {
            exceptionThrown = true;
        }
        CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
        this.checkAspects(CallerAspect.CALLER, POJOCaller1.class, joinPointByCon1, exceptionThrown);
        POJOCaller2 caller2 = new POJOCaller2(target, callAction, false);
        this.checkAspects(caller2, POJOCaller2.class, joinPointByCon2, false);
        try {
            new POJOCaller2(target, callAction, true);
        }
        catch (ThrownByTestException e) {
            exceptionThrown = true;
        }
        CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
        this.checkAspects(CallerAspect.CALLER, POJOCaller2.class, joinPointByCon2, exceptionThrown);
        String superJoinPointByMethod = "super" + (Object)((Object)callAction) + "bymethod";
        String joinPointByMethod1 = (Object)((Object)callAction) + "bymethod1";
        String joinPointByMethod2 = (Object)((Object)callAction) + "bymethod2";
        for (int i = 0; i < 3; ++i) {
            superCaller.method(target, callAction, false);
            this.checkAspects(superCaller, SuperPOJOCaller.class, superJoinPointByMethod, false);
            try {
                superCaller.method(target, callAction, true);
            }
            catch (ThrownByTestException e) {
                exceptionThrown = true;
            }
            CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
            this.checkAspects(superCaller, SuperPOJOCaller.class, superJoinPointByMethod, exceptionThrown);
            exceptionThrown = false;
            caller1.method(target, callAction, false);
            this.checkAspects(caller1, POJOCaller1.class, superJoinPointByMethod, false);
            try {
                caller1.method(target, callAction, true);
            }
            catch (ThrownByTestException e) {
                exceptionThrown = true;
            }
            CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
            this.checkAspects(caller1, POJOCaller1.class, superJoinPointByMethod, exceptionThrown);
            exceptionThrown = false;
            caller2.method(target, callAction, false);
            this.checkAspects(caller2, POJOCaller2.class, superJoinPointByMethod, false);
            try {
                caller2.method(target, callAction, true);
            }
            catch (ThrownByTestException e) {
                exceptionThrown = true;
            }
            CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
            this.checkAspects(caller2, POJOCaller2.class, superJoinPointByMethod, exceptionThrown);
            exceptionThrown = false;
            caller1.method1(target, callAction, false);
            this.checkAspects(caller1, POJOCaller1.class, joinPointByMethod1, false);
            try {
                caller1.method1(target, callAction, true);
            }
            catch (ThrownByTestException e) {
                exceptionThrown = true;
            }
            CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
            this.checkAspects(caller1, POJOCaller1.class, joinPointByMethod1, exceptionThrown);
            exceptionThrown = false;
            caller2.method2(target, callAction, false);
            this.checkAspects(caller2, POJOCaller2.class, joinPointByMethod2, false);
            try {
                caller2.method2(target, callAction, true);
            }
            catch (ThrownByTestException e) {
                exceptionThrown = true;
            }
            CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
            this.checkAspects(caller2, POJOCaller2.class, joinPointByMethod2, exceptionThrown);
            exceptionThrown = false;
        }
    }

    public void executeStaticMethod(CallAction callAction, SuperTargetPOJO target) throws ThrownByTestException {
        String superJoinPoint = "super" + (Object)((Object)callAction);
        String joinPoint1 = (Object)((Object)callAction) + "1";
        String joinPoint2 = (Object)((Object)callAction) + "2";
        SuperPOJOCaller.staticMethod(target, callAction, false);
        this.checkAspects(null, SuperPOJOCaller.class, superJoinPoint, false);
        boolean exceptionThrown = false;
        try {
            SuperPOJOCaller.staticMethod(target, callAction, true);
        }
        catch (ThrownByTestException e) {
            exceptionThrown = true;
        }
        CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
        this.checkAspects(null, SuperPOJOCaller.class, superJoinPoint, exceptionThrown);
        exceptionThrown = false;
        POJOCaller1.staticMethod(target, callAction, false);
        this.checkAspects(null, SuperPOJOCaller.class, superJoinPoint, false);
        try {
            POJOCaller1.staticMethod(target, callAction, true);
        }
        catch (ThrownByTestException e) {
            exceptionThrown = true;
        }
        CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
        this.checkAspects(null, SuperPOJOCaller.class, superJoinPoint, exceptionThrown);
        exceptionThrown = false;
        POJOCaller2.staticMethod(target, callAction, false);
        this.checkAspects(null, SuperPOJOCaller.class, superJoinPoint, false);
        try {
            POJOCaller2.staticMethod(target, callAction, true);
        }
        catch (ThrownByTestException e) {
            exceptionThrown = true;
        }
        CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
        this.checkAspects(null, SuperPOJOCaller.class, superJoinPoint, exceptionThrown);
        exceptionThrown = false;
        POJOCaller1.staticMethod1(target, callAction, false);
        this.checkAspects(null, POJOCaller1.class, joinPoint1, false);
        try {
            POJOCaller1.staticMethod1(target, callAction, true);
        }
        catch (ThrownByTestException e) {
            exceptionThrown = true;
        }
        CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
        this.checkAspects(null, POJOCaller1.class, joinPoint1, exceptionThrown);
        exceptionThrown = false;
        POJOCaller2.staticMethod2(target, callAction, false);
        this.checkAspects(null, POJOCaller2.class, joinPoint2, false);
        try {
            POJOCaller2.staticMethod2(target, callAction, true);
        }
        catch (ThrownByTestException e) {
            exceptionThrown = true;
        }
        CallerJoinpointScopedTestCase.assertTrue((boolean)exceptionThrown);
        this.checkAspects(null, POJOCaller2.class, joinPoint2, exceptionThrown);
    }

    private void checkAspects(SuperPOJOCaller context, Class<?> contextClass, String joinPoint, boolean exceptionThrown) {
        this.assertAspects(exceptionThrown, context == null);
        this.recordAspects(context, contextClass, joinPoint);
        this.resetAll();
    }

    private void recordAspects(SuperPOJOCaller context, Class<?> contextClass, String joinPoint) {
        if (context != null) {
            AspectRegister.addPerInstanceAspect(context);
        }
        AspectRegister.addPerJoinpointAspect(joinPoint, context);
        AspectRegister.addPerClassJoinpointAspect(contextClass, joinPoint);
        AspectRegister.addPerClassAspect(contextClass);
        AspectRegister.addPerVmAspect();
    }

    private void assertAspects(boolean exceptionThrown, boolean staticContext) {
        Object afterAspect = null;
        if (staticContext) {
            CallerJoinpointScopedTestCase.assertNull((Object)PerInstanceAspect.before);
            CallerJoinpointScopedTestCase.assertNull((Object)PerInstanceAspect.after);
            CallerJoinpointScopedTestCase.assertNull((Object)PerInstanceAspect.throwing);
            CallerJoinpointScopedTestCase.assertNull((Object)PerInstanceAspect.finaly);
        } else {
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerInstanceAspect.before);
            if (exceptionThrown) {
                CallerJoinpointScopedTestCase.assertNull((Object)PerInstanceAspect.after);
                CallerJoinpointScopedTestCase.assertNotNull((Object)PerInstanceAspect.throwing);
                afterAspect = PerInstanceAspect.throwing;
            } else {
                CallerJoinpointScopedTestCase.assertNotNull((Object)PerInstanceAspect.after);
                CallerJoinpointScopedTestCase.assertNull((Object)PerInstanceAspect.throwing);
                afterAspect = PerInstanceAspect.after;
            }
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerInstanceAspect.finaly);
            CallerJoinpointScopedTestCase.assertSame((Object)PerInstanceAspect.before, (Object)afterAspect);
            CallerJoinpointScopedTestCase.assertSame((Object)afterAspect, (Object)PerInstanceAspect.finaly);
        }
        CallerJoinpointScopedTestCase.assertNotNull((Object)PerJoinpointAspect.before);
        if (exceptionThrown) {
            CallerJoinpointScopedTestCase.assertNull((Object)PerJoinpointAspect.after);
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerJoinpointAspect.throwing);
            afterAspect = PerJoinpointAspect.throwing;
        } else {
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerJoinpointAspect.after);
            CallerJoinpointScopedTestCase.assertNull((Object)PerJoinpointAspect.throwing);
            afterAspect = PerJoinpointAspect.after;
        }
        CallerJoinpointScopedTestCase.assertNotNull((Object)PerJoinpointAspect.finaly);
        CallerJoinpointScopedTestCase.assertSame((Object)PerJoinpointAspect.before, (Object)afterAspect);
        CallerJoinpointScopedTestCase.assertSame((Object)afterAspect, (Object)PerJoinpointAspect.finaly);
        CallerJoinpointScopedTestCase.assertNotNull((Object)PerClassJoinpointAspect.before);
        if (exceptionThrown) {
            CallerJoinpointScopedTestCase.assertNull((Object)PerClassJoinpointAspect.after);
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerClassJoinpointAspect.throwing);
            afterAspect = PerClassJoinpointAspect.throwing;
        } else {
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerClassJoinpointAspect.after);
            CallerJoinpointScopedTestCase.assertNull((Object)PerClassJoinpointAspect.throwing);
            afterAspect = PerClassJoinpointAspect.after;
        }
        CallerJoinpointScopedTestCase.assertNotNull((Object)PerClassJoinpointAspect.finaly);
        CallerJoinpointScopedTestCase.assertSame((Object)PerClassJoinpointAspect.before, (Object)afterAspect);
        CallerJoinpointScopedTestCase.assertSame((Object)afterAspect, (Object)PerClassJoinpointAspect.finaly);
        CallerJoinpointScopedTestCase.assertNotNull((Object)PerClassAspect.before);
        if (exceptionThrown) {
            CallerJoinpointScopedTestCase.assertNull((Object)PerClassAspect.after);
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerClassAspect.throwing);
            afterAspect = PerClassAspect.throwing;
        } else {
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerClassAspect.after);
            CallerJoinpointScopedTestCase.assertNull((Object)PerClassAspect.throwing);
            afterAspect = PerClassAspect.after;
        }
        CallerJoinpointScopedTestCase.assertNotNull((Object)PerClassAspect.finaly);
        CallerJoinpointScopedTestCase.assertSame((Object)PerClassAspect.before, (Object)afterAspect);
        CallerJoinpointScopedTestCase.assertSame((Object)afterAspect, (Object)PerClassAspect.finaly);
        CallerJoinpointScopedTestCase.assertNotNull((Object)PerVmAspect.before);
        if (exceptionThrown) {
            CallerJoinpointScopedTestCase.assertNull((Object)PerVmAspect.after);
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerVmAspect.throwing);
            afterAspect = PerVmAspect.throwing;
        } else {
            CallerJoinpointScopedTestCase.assertNotNull((Object)PerVmAspect.after);
            CallerJoinpointScopedTestCase.assertNull((Object)PerVmAspect.throwing);
            afterAspect = PerVmAspect.after;
        }
        CallerJoinpointScopedTestCase.assertNotNull((Object)PerVmAspect.finaly);
        CallerJoinpointScopedTestCase.assertSame((Object)PerVmAspect.before, (Object)afterAspect);
        CallerJoinpointScopedTestCase.assertSame((Object)afterAspect, (Object)PerVmAspect.finaly);
    }

    private void resetAll() {
        PerInstanceAspect.reset();
        PerJoinpointAspect.reset();
        PerClassJoinpointAspect.reset();
        PerClassAspect.reset();
        PerVmAspect.reset();
        CallerAspect.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AspectRegister {
        private static Map<Class, PerClassAspect> PER_CLASS = new HashMap<Class, PerClassAspect>();
        private static Map<String, PerJoinpointAspect> PER_JOINPOINT = new HashMap<String, PerJoinpointAspect>();
        private static Map<SuperPOJOCaller, PerInstanceAspect> PER_INSTANCE = new HashMap<SuperPOJOCaller, PerInstanceAspect>();
        private static Map<String, PerClassJoinpointAspect> PER_CLASS_JOINPOINT = new HashMap<String, PerClassJoinpointAspect>();
        private static PerVmAspect PER_VM = null;

        AspectRegister() {
        }

        public static void addPerJoinpointAspect(String joinpoint, SuperPOJOCaller instance) {
            AspectRegister.addAspect(joinpoint + instance, PerJoinpointAspect.before, PER_JOINPOINT);
        }

        public static void addPerInstanceAspect(SuperPOJOCaller instance) {
            AspectRegister.addAspect(instance, PerInstanceAspect.before, PER_INSTANCE);
        }

        public static void addPerClassJoinpointAspect(Class clazz, String joinpoint) {
            AspectRegister.addAspect(clazz + joinpoint, PerClassJoinpointAspect.before, PER_CLASS_JOINPOINT);
        }

        public static void addPerClassAspect(Class clazz) {
            AspectRegister.addAspect(clazz, PerClassAspect.before, PER_CLASS);
        }

        public static void addPerVmAspect() {
            if (PER_VM != null) {
                Assert.assertSame((Object)PER_VM, (Object)PerVmAspect.before);
            }
            PER_VM = PerVmAspect.before;
        }

        private static <K, V> void addAspect(K key, V aspect, Map<K, V> map) {
            if (map.containsKey(key)) {
                Assert.assertSame(map.get(key), aspect);
            } else {
                map.put(key, aspect);
            }
            for (Map.Entry<K, V> e : map.entrySet()) {
                if (e.getKey() == key || e.getKey().equals(key)) continue;
                Assert.assertNotSame((String)("Unexpected same value\nkey1:" + e.getKey() + " - key2:" + key), e.getValue(), aspect);
            }
        }
    }
}

