/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.beforeafterthrowingstack;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.beforeafterthrowingstack.Aspect;
import org.jboss.test.aop.beforeafterthrowingstack.POJO;
import org.jboss.test.aop.beforeafterthrowingstack.ThrownByTestException;

public class BeforeAfterThrowingStackTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)BeforeAfterThrowingStackTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("BeforeAfterThrowingStackTestCase");
        suite.addTestSuite(BeforeAfterThrowingStackTestCase.class);
        return suite;
    }

    public BeforeAfterThrowingStackTestCase(String name) {
        super(name);
    }

    public void testMethodNoStack() {
        Aspect.reset();
        POJO pojo = new POJO();
        pojo.noStack();
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.before);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.after);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.throwing);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.finaly);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.aroundBefore);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.aroundAfter);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.aroundThrowing);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.aroundFinally);
    }

    public void testMethodWithStack() {
        Aspect.reset();
        POJO pojo = new POJO();
        pojo.stack();
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.before);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.after);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.throwing);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.finaly);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.aroundBefore);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.aroundAfter);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.aroundThrowing);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.aroundFinally);
    }

    public void testMethodWithStackAndException() {
        Aspect.reset();
        POJO pojo = new POJO();
        try {
            pojo.stackWithException();
            BeforeAfterThrowingStackTestCase.fail((String)"Should have had ThrownByTestException");
        }
        catch (ThrownByTestException thrownByTestException) {
            // empty catch block
        }
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.before);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.after);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.throwing);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.finaly);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.aroundBefore);
        BeforeAfterThrowingStackTestCase.assertEquals((int)0, (int)Aspect.aroundAfter);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.aroundThrowing);
        BeforeAfterThrowingStackTestCase.assertEquals((int)1, (int)Aspect.aroundFinally);
    }
}

