/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.inforesolve;

import org.jboss.aop.joinpoint.ConstructorExecution;
import org.jboss.aop.joinpoint.FieldAccess;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.aop.joinpoint.MethodExecution;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.inforesolve.POJO;
import org.jboss.test.aop.inforesolve.ResolveAnnotationAspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoResolveAnnotationTestCase
extends AOPTestWithSetup {
    public InfoResolveAnnotationTestCase(String arg0) {
        super(arg0);
    }

    public void testResolveAnnotationsFromInfo() throws Exception {
        ResolveAnnotationAspect.clear();
        POJO pojo = new POJO();
        InfoResolveAnnotationTestCase.assertNotNull((Object)pojo);
        this.check(ConstructorExecution.class, "class", "ctor");
        ResolveAnnotationAspect.clear();
        pojo.field = 100;
        this.check(FieldAccess.class, "class", "field");
        ResolveAnnotationAspect.clear();
        InfoResolveAnnotationTestCase.assertEquals((int)100, (int)pojo.field);
        this.check(FieldAccess.class, "class", "field");
        ResolveAnnotationAspect.clear();
        POJO.staticField = 101;
        this.check(FieldAccess.class, "class", "staticField");
        ResolveAnnotationAspect.clear();
        InfoResolveAnnotationTestCase.assertEquals((int)101, (int)POJO.staticField);
        this.check(FieldAccess.class, "class", "staticField");
        ResolveAnnotationAspect.clear();
        InfoResolveAnnotationTestCase.assertEquals((int)201, (int)pojo.method(200));
        this.check(MethodExecution.class, "class", "method");
        ResolveAnnotationAspect.clear();
        InfoResolveAnnotationTestCase.assertEquals((int)302, (int)pojo.staticMethod(300));
        this.check(MethodExecution.class, "class", "staticMethod");
    }

    private void check(Class<? extends JoinPointBean> expectedInfoClazz, String expectedClassString, String expectedJoinPointString) {
        InfoResolveAnnotationTestCase.assertNotNull((Object)ResolveAnnotationAspect.joinPoint);
        InfoResolveAnnotationTestCase.assertTrue((boolean)expectedInfoClazz.isAssignableFrom(ResolveAnnotationAspect.joinPoint.getClass()));
        InfoResolveAnnotationTestCase.assertNotNull((Object)ResolveAnnotationAspect.classAnnotation);
        InfoResolveAnnotationTestCase.assertEquals((String)expectedClassString, (String)ResolveAnnotationAspect.classAnnotation.value());
        InfoResolveAnnotationTestCase.assertNotNull((Object)ResolveAnnotationAspect.joinpointAnnotation);
        InfoResolveAnnotationTestCase.assertEquals((String)expectedJoinPointString, (String)ResolveAnnotationAspect.joinpointAnnotation.value());
    }
}

