/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.instanceofannotated;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.instanceofannotated.AnnotatedSuperClass;
import org.jboss.test.aop.instanceofannotated.CountingInterceptor;
import org.jboss.test.aop.instanceofannotated.EmptyInterface;
import org.jboss.test.aop.instanceofannotated.Introduced;
import org.jboss.test.aop.instanceofannotated.Introduced2;
import org.jboss.test.aop.instanceofannotated.Introduced3;
import org.jboss.test.aop.instanceofannotated.IntroducedPOJO;
import org.jboss.test.aop.instanceofannotated.POJO;
import org.jboss.test.aop.instanceofannotated.Type;
import org.jboss.test.aop.instanceofannotated.WildcardPOJO;

public class InstanceOfAnnotatedTester
extends AOPTestWithSetup {
    public static Test suite() {
        TestSuite suite = new TestSuite("InstanceOfAnnotatedTester");
        suite.addTestSuite(InstanceOfAnnotatedTester.class);
        return suite;
    }

    public InstanceOfAnnotatedTester(String name) {
        super(name);
    }

    public void testInstanceOfAnnotations() throws Exception {
        POJO pojo = new POJO();
        CountingInterceptor.count = 0;
        pojo.annotatedMethod();
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("annotatedMethod did not intercept " + CountingInterceptor.count);
        }
        CountingInterceptor.count = 0;
        pojo.otherAnnotatedMethod();
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("otherAnnotatedMethod did not intercept " + CountingInterceptor.count);
        }
        CountingInterceptor.count = 0;
        pojo.superClassMethod();
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("superClassMethod did not intercept " + CountingInterceptor.count);
        }
        AnnotatedSuperClass superClass = new AnnotatedSuperClass();
        CountingInterceptor.count = 0;
        superClass.superClassMethod();
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("AnnotatedSuperClass.superClassMethod did not intercept " + CountingInterceptor.count);
        }
        try {
            EmptyInterface ei = (EmptyInterface)((Object)pojo);
            System.out.println("Cast POJO to Empty interface " + ei);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("POJO does not implement EmptyInterface");
        }
    }

    public void testInstanceOfWildcards() throws Exception {
        CountingInterceptor.count = 0;
        WildcardPOJO pojo = new WildcardPOJO();
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("Did not intercept constructor" + CountingInterceptor.count);
        }
        CountingInterceptor.count = 0;
        pojo.someMethod();
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("Did not intercept someMethod()" + CountingInterceptor.count);
        }
        CountingInterceptor.count = 0;
        pojo.otherMethod();
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("Did not intercept otherMethod()" + CountingInterceptor.count);
        }
        CountingInterceptor.count = 0;
        pojo.anotherMethod();
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("Did not intercept anotherMethod()" + CountingInterceptor.count);
        }
    }

    public void testReturnTypeAndParams() throws Exception {
        CountingInterceptor.count = 0;
        POJO pojo = new POJO(new Type(3), new Type(4), 5);
        if (CountingInterceptor.count != 2) {
            throw new RuntimeException("Did not intercept constructor:" + CountingInterceptor.count);
        }
        CountingInterceptor.count = 0;
        pojo.paramsAndInstanceofReturn(new Type(3), new Type(4), 5);
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("Did not intercept method with instanceof return:" + CountingInterceptor.count);
        }
        CountingInterceptor.count = 0;
        pojo.paramsAndTypedefReturn(new Type(4), new Type(5), 6);
        if (CountingInterceptor.count != 2) {
            throw new RuntimeException("Did not intercept method with typedef return:" + CountingInterceptor.count);
        }
    }

    public void testFieldTypes() throws Exception {
        CountingInterceptor.count = 0;
        POJO pojo = new POJO();
        pojo.instanceofField = new Type(5);
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("Did not intercept instanceof field:" + CountingInterceptor.count);
        }
        CountingInterceptor.count = 0;
        pojo.typedefField = new Type(5);
        if (CountingInterceptor.count != 1) {
            throw new RuntimeException("Did not intercept typedef field:" + CountingInterceptor.count);
        }
    }

    public void testTypeExpressions() throws Exception {
        Class<IntroducedPOJO> introducedPOJO = IntroducedPOJO.class;
        ClassAdvisor advisor = AspectManager.instance().getAdvisor(introducedPOJO);
        Introduced introduced = (Introduced)advisor.resolveTypedAnnotation(Introduced.class);
        InstanceOfAnnotatedTester.assertNotNull((String)"Class did not have the @Introduced annotation", (Object)introduced);
        Constructor<?> con = introducedPOJO.getConstructors()[0];
        introduced = (Introduced)advisor.resolveTypedAnnotation(con, Introduced.class);
        InstanceOfAnnotatedTester.assertNotNull((String)"Constructor did not have the @Introduced annotation", (Object)introduced);
        Introduced2 introduced2 = (Introduced2)advisor.resolveTypedAnnotation(con, Introduced2.class);
        InstanceOfAnnotatedTester.assertNotNull((String)"Constructor did not have the @Introduced2 annotation", (Object)introduced2);
        Introduced3 introduced3 = (Introduced3)advisor.resolveTypedAnnotation(con, Introduced3.class);
        InstanceOfAnnotatedTester.assertNull((String)"Constructor has the @Introduced3 annotation", (Object)introduced3);
        Field field = introducedPOJO.getField("field");
        introduced = (Introduced)advisor.resolveTypedAnnotation(field, Introduced.class);
        InstanceOfAnnotatedTester.assertNotNull((String)"Field did not have the @Introduced annotation", (Object)introduced);
        introduced2 = (Introduced2)advisor.resolveTypedAnnotation(field, Introduced2.class);
        InstanceOfAnnotatedTester.assertNotNull((String)"Field did not have the @Introduced2 annotation", (Object)introduced2);
        Method method = introducedPOJO.getMethod("someMethod", Type.class, Type.class);
        introduced = (Introduced)advisor.resolveTypedAnnotation(method, Introduced.class);
        InstanceOfAnnotatedTester.assertNotNull((String)"Method did not have the @Introduced annotation", (Object)introduced);
        introduced2 = (Introduced2)advisor.resolveTypedAnnotation(method, Introduced2.class);
        InstanceOfAnnotatedTester.assertNotNull((String)"Method did not have the @Introduced2 annotation", (Object)introduced2);
        introduced3 = (Introduced3)advisor.resolveTypedAnnotation(method, Introduced3.class);
        InstanceOfAnnotatedTester.assertNull((String)"Method has the @Introduced3 annotation", (Object)introduced3);
    }
}

