/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.introduction;

import java.rmi.MarshalledObject;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.introduction.BaseClass;
import org.jboss.test.aop.introduction.InterceptorHandledIntroduction;
import org.jboss.test.aop.introduction.NonSerializedIntroduction;
import org.jboss.test.aop.introduction.OverrideObjectInterface;
import org.jboss.test.aop.introduction.OverrideObjectPOJO;
import org.jboss.test.aop.introduction.POJO;
import org.jboss.test.aop.introduction.POJOSubClass;
import org.jboss.test.aop.introduction.POJOSuperClass;
import org.jboss.test.aop.introduction.SerializedIntroduction;
import org.jboss.test.aop.introduction.SerializedPOJO;
import org.jboss.test.aop.introduction.SubClass;

public class IntroductionTester
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run(IntroductionTester.class);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("IntroductionTester");
        suite.addTestSuite(IntroductionTester.class);
        return suite;
    }

    public IntroductionTester(String name) {
        super(name);
    }

    public void testSerialization() throws Exception {
        SerializedPOJO pojo = new SerializedPOJO();
        ((NonSerializedIntroduction)((Object)pojo)).setNonMessage("hello");
        ((SerializedIntroduction)((Object)pojo)).setMessage("world");
        if (!((NonSerializedIntroduction)((Object)pojo)).getNonMessage().equals("hello")) {
            throw new Exception("non serialized isn't set correctly");
        }
        if (!((SerializedIntroduction)((Object)pojo)).getMessage().equals("world")) {
            throw new Exception("serialized isn't set correctly");
        }
        MarshalledObject<SerializedPOJO> mo = new MarshalledObject<SerializedPOJO>(pojo);
        if (!((NonSerializedIntroduction)((Object)(pojo = mo.get()))).getNonMessage().equals("original")) {
            throw new Exception("non serialized isn't set correctly" + ((NonSerializedIntroduction)((Object)pojo)).getNonMessage().equals("original"));
        }
        if (!((SerializedIntroduction)((Object)pojo)).getMessage().equals("world")) {
            throw new Exception("serialized isn't set correctly");
        }
        IntroductionTester.assertTrue((boolean)((NonSerializedIntroduction)((Object)pojo))._testUnderscore());
    }

    public void testHandledByInterceptor() throws Exception {
        POJO pojo = new POJO();
        int ret = ((InterceptorHandledIntroduction)((Object)pojo)).handledByIntroduction();
        IntroductionTester.assertEquals((int)5, (int)ret);
        POJOSubClass pojoSubClass = new POJOSubClass();
        ret = ((InterceptorHandledIntroduction)((Object)pojoSubClass)).handledByIntroduction();
        IntroductionTester.assertEquals((int)25, (int)ret);
        POJOSuperClass pojoSuperClass = new POJOSuperClass();
        ret = ((InterceptorHandledIntroduction)((Object)pojoSuperClass)).handledByIntroduction();
        IntroductionTester.assertEquals((int)1, (int)ret);
    }

    public void testOverrideBaseclassMethodsWithMixin() throws Exception {
        BaseClass base = new BaseClass();
        IntroductionTester.assertEquals((String)"sumfink", (String)base.getNonMessage());
        SubClass sub = new SubClass();
        NonSerializedIntroduction intro = (NonSerializedIntroduction)((Object)sub);
        IntroductionTester.assertEquals((String)"original", (String)intro.getNonMessage());
    }

    public void testObjectHasSameMethodsAsIntroduction() throws Exception {
        OverrideObjectPOJO pojo = new OverrideObjectPOJO();
        IntroductionTester.assertFalse((boolean)pojo.invokedEquals);
        IntroductionTester.assertFalse((boolean)pojo.invokedHashCode);
        IntroductionTester.assertFalse((boolean)pojo.invokedToString);
        OverrideObjectInterface iface = (OverrideObjectInterface)((Object)pojo);
        ((Object)iface).equals(null);
        IntroductionTester.assertTrue((boolean)pojo.invokedEquals);
        ((Object)iface).hashCode();
        IntroductionTester.assertTrue((boolean)pojo.invokedHashCode);
        ((Object)iface).toString();
        IntroductionTester.assertTrue((boolean)pojo.invokedToString);
    }
}

