/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.jdk15.dynamic.prepareField;

import org.jboss.test.aop.AOPTestDelegate;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.jdk15.dynamic.common.BindingInterceptor;
import org.jboss.test.aop.jdk15.dynamic.common.InstanceInterceptor;
import org.jboss.test.aop.jdk15.dynamic.common.InterceptionsCount;
import org.jboss.test.aop.jdk15.dynamic.common.POJOWrappingInfo;
import org.jboss.test.aop.jdk15.dynamic.common.ScenarioLoader;

public class HotSwapEnabledTester
extends AOPTestWithSetup {
    private ScenarioLoader scenarioLoader;

    public HotSwapEnabledTester(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.scenarioLoader = new ScenarioLoader(((AOPTestDelegate)this.getDelegate()).getSystemProperties());
    }

    private void assertUnwrapped(POJOWrappingInfo wrappingInfo) {
        HotSwapEnabledTester.assertFalse((boolean)wrappingInfo.isConstructorWrapped());
        HotSwapEnabledTester.assertFalse((boolean)wrappingInfo.isFieldReadWrapped());
        HotSwapEnabledTester.assertFalse((boolean)wrappingInfo.isFieldWriteWrapped());
        HotSwapEnabledTester.assertFalse((boolean)wrappingInfo.isMethodWrapped());
    }

    private void assertFullyWrapped(POJOWrappingInfo wrappingInfo) {
        HotSwapEnabledTester.assertTrue((boolean)wrappingInfo.isConstructorWrapped());
        HotSwapEnabledTester.assertTrue((boolean)wrappingInfo.isFieldReadWrapped());
        HotSwapEnabledTester.assertTrue((boolean)wrappingInfo.isFieldWriteWrapped());
        HotSwapEnabledTester.assertTrue((boolean)wrappingInfo.isMethodWrapped());
    }

    private void assertOnlyFieldWrapped(POJOWrappingInfo wrappingInfo) {
        HotSwapEnabledTester.assertFalse((boolean)wrappingInfo.isConstructorWrapped());
        HotSwapEnabledTester.assertTrue((boolean)wrappingInfo.isFieldReadWrapped());
        HotSwapEnabledTester.assertTrue((boolean)wrappingInfo.isFieldWriteWrapped());
        HotSwapEnabledTester.assertFalse((boolean)wrappingInfo.isMethodWrapped());
    }

    public void testPerClassLoadAfterInterception() throws Throwable {
        POJOWrappingInfo[] wrappingInfos = this.scenarioLoader.interceptPerClassLoadAfter();
        this.assertFullyWrapped(wrappingInfos[0]);
        this.assertUnwrapped(wrappingInfos[1]);
        InterceptionsCount instance = InstanceInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.total);
        InterceptionsCount binding = BindingInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertTrue((binding.total >= 5 && binding.total <= 8 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertTrue((binding.constructor >= 1 && binding.constructor <= 2 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertTrue((binding.fieldRead >= 1 && binding.fieldRead <= 2 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertTrue((binding.fieldWrite >= 1 && binding.fieldWrite <= 2 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertEquals((int)2, (int)binding.method);
    }

    public void testPerClassLoadBeforeInterception() throws Throwable {
        POJOWrappingInfo[] wrappingInfos = this.scenarioLoader.interceptPerClassLoadBefore();
        this.assertUnwrapped(wrappingInfos[0]);
        this.assertOnlyFieldWrapped(wrappingInfos[1]);
        this.assertUnwrapped(wrappingInfos[2]);
        InterceptionsCount instance = InstanceInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.total);
        InterceptionsCount binding = BindingInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)2, (int)binding.total);
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.constructor);
        HotSwapEnabledTester.assertEquals((int)1, (int)binding.fieldRead);
        HotSwapEnabledTester.assertEquals((int)1, (int)binding.fieldWrite);
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.method);
    }

    public void testAddAndRemoveBindingTwice() throws Throwable {
        POJOWrappingInfo[] wrappingInfos = this.scenarioLoader.addAndRemoveBindingTwice();
        this.assertUnwrapped(wrappingInfos[0]);
        this.assertOnlyFieldWrapped(wrappingInfos[1]);
        this.assertUnwrapped(wrappingInfos[2]);
        this.assertOnlyFieldWrapped(wrappingInfos[3]);
        this.assertUnwrapped(wrappingInfos[4]);
        InterceptionsCount instance = InstanceInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.total);
        InterceptionsCount binding = BindingInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)4, (int)binding.total);
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.constructor);
        HotSwapEnabledTester.assertEquals((int)2, (int)binding.fieldRead);
        HotSwapEnabledTester.assertEquals((int)2, (int)binding.fieldWrite);
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.method);
    }

    public void testPerInstanceInterception() throws Throwable {
        POJOWrappingInfo[] wrappingInfos = this.scenarioLoader.interceptPerInstance();
        this.assertUnwrapped(wrappingInfos[0]);
        this.assertOnlyFieldWrapped(wrappingInfos[1]);
        InterceptionsCount binding = BindingInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.total);
        InterceptionsCount instance = InstanceInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertTrue((instance.total >= 2 && instance.total <= 4 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.constructor);
        HotSwapEnabledTester.assertTrue((instance.fieldRead >= 1 && instance.fieldRead <= 2 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertTrue((instance.fieldWrite >= 1 && instance.fieldWrite <= 2 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.method);
    }

    public void testPerInstanceGcInterception() throws Throwable {
        POJOWrappingInfo[] wrappingInfos = this.scenarioLoader.interceptPerInstanceGC();
        this.assertUnwrapped(wrappingInfos[0]);
        this.assertOnlyFieldWrapped(wrappingInfos[1]);
        this.assertUnwrapped(wrappingInfos[2]);
        InterceptionsCount binding = BindingInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.total);
        InterceptionsCount instance = InstanceInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertTrue((instance.total >= 2 && instance.total <= 4 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.constructor);
        HotSwapEnabledTester.assertTrue((instance.fieldRead >= 1 && instance.fieldRead <= 2 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertTrue((instance.fieldWrite >= 1 && instance.fieldWrite <= 2 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.method);
    }

    public void testPerClassPerInstanceInterception() throws Throwable {
        POJOWrappingInfo[] wrappingInfos = this.scenarioLoader.interceptPerClassPerInstance();
        this.assertUnwrapped(wrappingInfos[0]);
        this.assertOnlyFieldWrapped(wrappingInfos[1]);
        this.assertOnlyFieldWrapped(wrappingInfos[2]);
        InterceptionsCount binding = BindingInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)2, (int)binding.total);
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.constructor);
        HotSwapEnabledTester.assertEquals((int)1, (int)binding.fieldRead);
        HotSwapEnabledTester.assertEquals((int)1, (int)binding.fieldWrite);
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.method);
        InterceptionsCount instance = InstanceInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)2, (int)instance.total);
        HotSwapEnabledTester.assertEquals((int)1, (int)instance.fieldRead);
        HotSwapEnabledTester.assertEquals((int)1, (int)instance.fieldWrite);
    }

    public void testPerInstancePerClassInterception() throws Throwable {
        POJOWrappingInfo[] wrappingInfos = this.scenarioLoader.interceptPerInstancePerClass();
        this.assertOnlyFieldWrapped(wrappingInfos[0]);
        this.assertOnlyFieldWrapped(wrappingInfos[1]);
        this.assertOnlyFieldWrapped(wrappingInfos[2]);
        InterceptionsCount binding = BindingInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)2, (int)binding.total);
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.constructor);
        HotSwapEnabledTester.assertEquals((int)1, (int)binding.fieldRead);
        HotSwapEnabledTester.assertEquals((int)1, (int)binding.fieldWrite);
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.method);
        InterceptionsCount instance = InstanceInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertTrue((instance.total >= 4 && instance.total <= 6 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.constructor);
        HotSwapEnabledTester.assertTrue((instance.fieldRead >= 2 && instance.fieldRead <= 3 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertTrue((instance.fieldWrite >= 2 && instance.fieldWrite <= 3 ? 1 : 0) != 0);
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.method);
    }

    public void testAfterBindingRemovalExecution() throws Throwable {
        POJOWrappingInfo[] wrappingInfos = this.scenarioLoader.executeAfterBindingRemoval();
        this.assertUnwrapped(wrappingInfos[0]);
        InterceptionsCount binding = BindingInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)0, (int)binding.total);
        InterceptionsCount instance = InstanceInterceptor.getInterceptionsCount();
        HotSwapEnabledTester.assertEquals((int)0, (int)instance.total);
    }
}

