/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.jdk15annotated;

import org.jboss.aop.Aspect;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.MethodInvocation;

@Aspect(scope=Scope.PER_CLASS)
public class AspectPerClass {
    public int constructorCalled;
    public int methodCalled;
    public int fieldRead;
    public int fieldWrite;

    @Bind(pointcut="execution(org.jboss.test.aop.jdk15annotated.POJO*->new())")
    public Object constructorAdvice(ConstructorInvocation invocation) throws Throwable {
        System.out.println("AspectPerClass.constructorAdvice accessing: " + invocation.getConstructor().toString());
        ++this.constructorCalled;
        return invocation.invokeNext();
    }

    @Bind(pointcut="execution(void org.jboss.test.aop.jdk15annotated.POJO*->someMethod())")
    public Object methodAdvice(MethodInvocation invocation) throws Throwable {
        System.out.println("AspectPerClass.methodAdvice accessing: " + invocation.getMethod().toString());
        ++this.methodCalled;
        return invocation.invokeNext();
    }

    @Bind(pointcut="set(* org.jboss.test.aop.jdk15annotated.POJO*->field)")
    public Object fieldAdvice(FieldWriteInvocation invocation) throws Throwable {
        System.out.println("AspectPerClass.fieldAdvice writing to field: " + invocation.getField().getName());
        ++this.fieldWrite;
        return invocation.invokeNext();
    }

    @Bind(pointcut="get(* org.jboss.test.aop.jdk15annotated.POJO*->field)")
    public Object fieldAdvice(FieldReadInvocation invocation) throws Throwable {
        System.out.println("AspectPerClass.fieldAdvice reading field: " + invocation.getField().getName());
        ++this.fieldRead;
        return invocation.invokeNext();
    }

    public void reset() {
        this.constructorCalled = 0;
        this.methodCalled = 0;
        this.fieldRead = 0;
        this.fieldWrite = 0;
    }
}

