/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.marshalling;

import java.rmi.MarshalledObject;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class MarshallingInterceptor
implements Interceptor {
    public String getName() {
        return "MarshallingInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object[] args = ((MethodInvocation)invocation).getArguments();
        MarshalledObject<Invocation> mo = new MarshalledObject<Invocation>(invocation);
        MethodInvocation inv = (MethodInvocation)mo.get();
        Object[] margs = inv.getArguments();
        if (args != null) {
            if (margs == null) {
                throw new RuntimeException("Unmarshalled args were null");
            }
            if (margs.length != args.length) {
                throw new RuntimeException("Wrong length, expected " + args.length + ", actual " + margs.length);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(margs[i])) continue;
                throw new RuntimeException(i + " expcted " + args[i] + ", actual " + margs[i]);
            }
        }
        return invocation.invokeNext();
    }
}

