/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.test.aop.reflection.CallerInterceptor;
import org.jboss.test.aop.reflection.NotAdvisedPOJO;
import org.jboss.test.aop.reflection.ReflectionAopPOJO;
import org.jboss.test.aop.reflection.ReflectionAopRootPOJO;
import org.jboss.test.aop.reflection.ReflectionAspectTester;
import org.jboss.test.aop.reflection.SimplePerVmInterceptor;

public class ReflectionPOJO {
    static final Package LANG_PACKAGE = Package.getPackage("java.lang");

    public ReflectionPOJO() {
    }

    public ReflectionPOJO(int x) {
        try {
            System.out.println("*** reflection (from constructor): Sanity checks");
            SimplePerVmInterceptor.reset();
            ReflectionAopPOJO pojo = new ReflectionAopPOJO(8);
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept constructor");
            }
            if (pojo.j != 8) {
                throw new RuntimeException("POJO.j was not 8");
            }
            SimplePerVmInterceptor.reset();
            pojo.method(10);
            if (SimplePerVmInterceptor.methodIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept method call");
            }
            SimplePerVmInterceptor.reset();
            pojo.j = 5;
            if (SimplePerVmInterceptor.fieldWriteIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept field write");
            }
            SimplePerVmInterceptor.reset();
            int i = pojo.j;
            System.out.println("i=" + i);
            if (SimplePerVmInterceptor.fieldReadIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept field read");
            }
            CallerInterceptor.reset();
            pojo = new ReflectionAopPOJO(false);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept construction");
            }
            CallerInterceptor.reset();
            pojo.method(false);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept method(boolean) call");
            }
            CallerInterceptor.reset();
            SimplePerVmInterceptor.reset();
            pojo = new ReflectionAopPOJO(100L);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept constructor(long) call");
            }
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept constructor(long) call");
            }
            CallerInterceptor.reset();
            SimplePerVmInterceptor.reset();
            pojo.otherMethod(200L);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept method(long) call");
            }
            if (SimplePerVmInterceptor.methodIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept method(long) call");
            }
            System.out.println("*** reflection (from constructor): Class.newInstance");
            Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            pojo = (ReflectionAopPOJO)clazz.newInstance();
            System.out.println("reflection call - end");
            if (ReflectionAspectTester.constructor == null) {
                throw new RuntimeException("Not intercepted");
            }
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor not invoked for reflected default constructor");
            }
            System.out.println("*** reflection (from constructor): Constructor.newInstance");
            Constructor constructor = clazz.getConstructor(Integer.TYPE);
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            pojo = (ReflectionAopPOJO)constructor.newInstance(new Integer(4));
            System.out.println("reflection call - end");
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor not invoked for reflected constructor(int)");
            }
            if (pojo.j != 4) {
                throw new RuntimeException("POJO.j was not 8 following reflection");
            }
            System.out.println("*** reflection (from constructor): Method.invoke");
            Method method = clazz.getMethod("method", Integer.TYPE);
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            method.invoke((Object)pojo, new Integer(55));
            System.out.println("reflection call - end");
            if (SimplePerVmInterceptor.methodIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept reflected method call");
            }
            System.out.println("*** reflection (from constructor): Field.setInt");
            Field field = clazz.getField("j");
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            field.setInt(pojo, 10);
            System.out.println("reflection call - end");
            if (ReflectionAspectTester.field == null || (Integer)ReflectionAspectTester.args[0] != 10) {
                throw new RuntimeException("Not intercepted");
            }
            if (SimplePerVmInterceptor.fieldWriteIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept reflected field write");
            }
            System.out.println("*** reflection (from constructor): Field.getInt");
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            int j = field.getInt(pojo);
            System.out.println("reflection call - end");
            if (ReflectionAspectTester.field == null || j != 10) {
                throw new RuntimeException("Not intercepted");
            }
            if (SimplePerVmInterceptor.fieldReadIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept reflected field read");
            }
            System.out.println("*** reflection (from constructor): Checking not advised constructors, fields and methods");
            SimplePerVmInterceptor.reset();
            constructor = clazz.getConstructor(String.class);
            pojo = (ReflectionAopPOJO)constructor.newInstance("x");
            method = clazz.getMethod("method", new Class[0]);
            method.invoke((Object)pojo, new Object[0]);
            field = clazz.getField("k");
            field.setInt(pojo, 5);
            field.getInt(pojo);
            if (SimplePerVmInterceptor.hasIntercepted()) {
                throw new RuntimeException("SimplePerVmInterceptor intercepted something that should have been left alone");
            }
            System.out.println("*** reflection (from constructor): Checking not advised constructor");
            Class<NotAdvisedPOJO> notAdvisedClazz = NotAdvisedPOJO.class;
            constructor = notAdvisedClazz.getConstructor(new Class[0]);
            NotAdvisedPOJO naPojo = (NotAdvisedPOJO)constructor.newInstance(new Object[0]);
            System.out.println("*** reflection (from constructor): Checking not advised method");
            method = notAdvisedClazz.getMethod("method", new Class[0]);
            method.invoke((Object)naPojo, new Object[0]);
            System.out.println("*** reflection (from constructor): Checking not advised field set");
            field = notAdvisedClazz.getField("i");
            field.setInt(naPojo, 1);
            System.out.println("*** reflection (from constructor): Checking not advised field get");
            field.getInt(naPojo);
            System.out.println("*** reflection (from constructor): Checking constructor caller");
            CallerInterceptor.reset();
            constructor = clazz.getConstructor(Boolean.TYPE);
            pojo = (ReflectionAopPOJO)constructor.newInstance(Boolean.TRUE);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept reflected construction");
            }
            System.out.println("*** reflection (from constructor): Checking method caller");
            CallerInterceptor.reset();
            method = clazz.getMethod("method", Boolean.TYPE);
            method.invoke((Object)pojo, Boolean.FALSE);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept reflected method(boolean) call");
            }
            System.out.println("*** reflection (from constructor): Checking constructor caller and execution");
            CallerInterceptor.reset();
            SimplePerVmInterceptor.reset();
            constructor = clazz.getConstructor(Long.TYPE);
            pojo = (ReflectionAopPOJO)constructor.newInstance(new Long(100L));
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept constructor(long) call");
            }
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept constructor(long) call");
            }
            System.out.println("*** reflection (from constructor): Checking method caller and execution");
            CallerInterceptor.reset();
            SimplePerVmInterceptor.reset();
            method = clazz.getMethod("otherMethod", Long.TYPE);
            method.invoke((Object)pojo, new Long(100L));
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept method(long) call");
            }
            if (SimplePerVmInterceptor.methodIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept method(long) call");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testCreationAndFieldAccess() {
        try {
            System.out.println("*** reflection (from method): Sanity checks");
            SimplePerVmInterceptor.reset();
            ReflectionAopPOJO pojo = new ReflectionAopPOJO(8);
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept constructor");
            }
            if (pojo.j != 8) {
                throw new RuntimeException("POJO.j was not 8");
            }
            SimplePerVmInterceptor.reset();
            pojo.method(10);
            if (SimplePerVmInterceptor.methodIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept method call");
            }
            SimplePerVmInterceptor.reset();
            pojo.j = 5;
            if (SimplePerVmInterceptor.fieldWriteIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept field write");
            }
            SimplePerVmInterceptor.reset();
            int i = pojo.j;
            System.out.println("i=" + i);
            if (SimplePerVmInterceptor.fieldReadIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept field read");
            }
            CallerInterceptor.reset();
            pojo = new ReflectionAopPOJO(false);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept construction");
            }
            CallerInterceptor.reset();
            pojo.method(false);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept method(boolean) call");
            }
            CallerInterceptor.reset();
            SimplePerVmInterceptor.reset();
            pojo = new ReflectionAopPOJO(100L);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept constructor(long) call");
            }
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept constructor(long) call");
            }
            CallerInterceptor.reset();
            SimplePerVmInterceptor.reset();
            pojo.otherMethod(200L);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept method(long) call");
            }
            if (SimplePerVmInterceptor.methodIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept method(long) call");
            }
            System.out.println("*** reflection (from method): Class.newInstance");
            Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            pojo = (ReflectionAopPOJO)clazz.newInstance();
            System.out.println("reflection call - end");
            if (ReflectionAspectTester.constructor == null) {
                throw new RuntimeException("Not intercepted");
            }
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor not invoked for reflected default constructor");
            }
            System.out.println("*** reflection (from method): Constructor.newInstance");
            Constructor constructor = clazz.getConstructor(Integer.TYPE);
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            pojo = (ReflectionAopPOJO)constructor.newInstance(new Integer(4));
            System.out.println("reflection call - end");
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor not invoked for reflected constructor(int)");
            }
            if (pojo.j != 4) {
                throw new RuntimeException("POJO.j was not 8 following reflection");
            }
            System.out.println("*** reflection (from method): Method.invoke");
            Method method = clazz.getMethod("method", Integer.TYPE);
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            method.invoke((Object)pojo, new Integer(55));
            System.out.println("reflection call - end");
            if (SimplePerVmInterceptor.methodIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept reflected method call");
            }
            System.out.println("*** reflection (from method): Field.setInt");
            Field field = clazz.getField("j");
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            field.setInt(pojo, 10);
            System.out.println("reflection call - end");
            if (ReflectionAspectTester.field == null || (Integer)ReflectionAspectTester.args[0] != 10) {
                throw new RuntimeException("Not intercepted");
            }
            if (SimplePerVmInterceptor.fieldWriteIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept reflected field write");
            }
            System.out.println("*** reflection (from method): Field.getInt");
            SimplePerVmInterceptor.reset();
            System.out.println("reflection call");
            int j = field.getInt(pojo);
            System.out.println("reflection call - end");
            if (ReflectionAspectTester.field == null || j != 10) {
                throw new RuntimeException("Not intercepted");
            }
            if (SimplePerVmInterceptor.fieldReadIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept reflected field read");
            }
            SimplePerVmInterceptor.reset();
            constructor = clazz.getConstructor(String.class);
            pojo = (ReflectionAopPOJO)constructor.newInstance("x");
            method = clazz.getMethod("method", new Class[0]);
            method.invoke((Object)pojo, new Object[0]);
            field = clazz.getField("k");
            field.setInt(pojo, 5);
            field.getInt(pojo);
            if (SimplePerVmInterceptor.hasIntercepted()) {
                throw new RuntimeException("SimplePerVmInterceptor intercepted something that should have been left alone");
            }
            System.out.println("*** reflection (from method): Checking not advised constructor");
            Class<NotAdvisedPOJO> notAdvisedClazz = NotAdvisedPOJO.class;
            constructor = notAdvisedClazz.getConstructor(new Class[0]);
            NotAdvisedPOJO naPojo = (NotAdvisedPOJO)constructor.newInstance(new Object[0]);
            System.out.println("*** reflection (from method): Checking not advised method");
            method = notAdvisedClazz.getMethod("method", new Class[0]);
            method.invoke((Object)naPojo, new Object[0]);
            System.out.println("*** reflection (from method): Checking not advised field set");
            field = notAdvisedClazz.getField("i");
            field.setInt(naPojo, 1);
            System.out.println("*** reflection (from method): Checking not advised field get");
            field.getInt(naPojo);
            System.out.println("*** reflection (from method): Checking constructor caller");
            CallerInterceptor.reset();
            constructor = clazz.getConstructor(Boolean.TYPE);
            pojo = (ReflectionAopPOJO)constructor.newInstance(Boolean.TRUE);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept reflected construction");
            }
            System.out.println("*** reflection (from method): Checking method caller");
            CallerInterceptor.reset();
            method = clazz.getMethod("method", Boolean.TYPE);
            method.invoke((Object)pojo, Boolean.FALSE);
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept reflected method(boolean) call");
            }
            System.out.println("*** reflection (from constructor): Checking constructor caller and execution");
            CallerInterceptor.reset();
            SimplePerVmInterceptor.reset();
            constructor = clazz.getConstructor(Long.TYPE);
            pojo = (ReflectionAopPOJO)constructor.newInstance(new Long(100L));
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept constructor(long) call");
            }
            if (SimplePerVmInterceptor.constructorIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept constructor(long) call");
            }
            System.out.println("*** reflection (from constructor): Checking method caller and execution");
            CallerInterceptor.reset();
            SimplePerVmInterceptor.reset();
            method = clazz.getMethod("otherMethod", Long.TYPE);
            method.invoke((Object)pojo, new Long(100L));
            if (CallerInterceptor.intercepted != 1) {
                throw new RuntimeException("CallerInterceptor did not intercept method(long) call");
            }
            if (SimplePerVmInterceptor.methodIntercepted != 1) {
                throw new RuntimeException("SimplePerVmInterceptor did not intercept method(long) call");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testCleanGetMethods() {
        System.out.println("*** reflection (from method): Class.getMethods()");
        Class<ReflectionAopPOJO> pojoClass = ReflectionAopPOJO.class;
        Class<ReflectionAopRootPOJO> pojoRoot = ReflectionAopRootPOJO.class;
        try {
            int i;
            Method[] check = new Method[]{pojoClass.getMethod("method", new Class[0]), pojoClass.getMethod("method", Integer.TYPE), pojoClass.getMethod("method", Boolean.TYPE), pojoClass.getMethod("method", Integer.TYPE, Long.TYPE), pojoRoot.getMethod("method", Integer.TYPE, Long.TYPE, Short.TYPE), pojoClass.getMethod("otherMethod", Long.TYPE), pojoClass.getMethod("helloWorld", String.class)};
            Method[] methods = pojoClass.getMethods();
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (i = 0; i < methods.length; ++i) {
                if (methods[i].getDeclaringClass().getPackage().equals(LANG_PACKAGE)) continue;
                methodList.add(methods[i]);
            }
            for (i = 0; i < check.length; ++i) {
                if (methodList.remove(check[i])) continue;
                throw new RuntimeException("\"Cleaned\" Class.getMethods() did not return all expected methods: " + check[i]);
            }
            if (methodList.size() > 0) {
                StringBuffer sb = new StringBuffer("The following methods should not have ben returned by \"Cleaned\" Class.getMethods():\n");
                Iterator it = methodList.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                }
                throw new RuntimeException(sb.toString());
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void testCleanGetDeclaredMethods() {
        System.out.println("*** reflection (from method): Class.getDeclaredMethods()");
        Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
        try {
            int i;
            Method[] check = new Method[]{clazz.getDeclaredMethod("method", new Class[0]), clazz.getDeclaredMethod("method", Integer.TYPE), clazz.getDeclaredMethod("method", Boolean.TYPE), clazz.getMethod("method", Integer.TYPE, Long.TYPE), clazz.getMethod("otherMethod", Long.TYPE), clazz.getDeclaredMethod("privateMethod", new Class[0]), clazz.getMethod("helloWorld", String.class)};
            Method[] methods = clazz.getDeclaredMethods();
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (i = 0; i < methods.length; ++i) {
                methodList.add(methods[i]);
            }
            for (i = 0; i < check.length; ++i) {
                if (methodList.remove(check[i])) continue;
                throw new RuntimeException("\"Cleaned\" Class.getDeclaredMethods() did not return all expected methods: " + check[i]);
            }
            if (methodList.size() > 0) {
                StringBuffer sb = new StringBuffer("The following methods should not have ben returned by \"Cleaned\" Class.getDeclaredMethods():\n");
                Iterator it = methodList.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                }
                throw new RuntimeException(sb.toString());
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void testCleanGetDeclaredFields() {
        System.out.println("*** reflection (from method): Class.getDeclaredFields()");
        Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
        try {
            int i;
            Field[] check = new Field[]{clazz.getDeclaredField("i"), clazz.getDeclaredField("j"), clazz.getDeclaredField("k")};
            Field[] fields = clazz.getDeclaredFields();
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (i = 0; i < fields.length; ++i) {
                fieldList.add(fields[i]);
            }
            for (i = 0; i < check.length; ++i) {
                if (fieldList.remove(check[i])) continue;
                throw new RuntimeException("\"Cleaned\" Class.getDeclaredFields() did not return all expected fields: " + check[i]);
            }
            if (fieldList.size() > 0) {
                StringBuffer sb = new StringBuffer("The following methods should not have ben returned by \"Cleaned\" Class.getDeclaredFields():\n");
                Iterator it = fieldList.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                }
                throw new RuntimeException(sb.toString());
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void testCleanGetInterfaces() {
        System.out.println("*** reflection (from method): Class.getInterfaces()");
        ReflectionAopPOJO pojo = new ReflectionAopPOJO();
        System.out.println("pojo=" + pojo);
        Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length != 1) {
            throw new RuntimeException("Expected 1 interface, got " + interfaces.length);
        }
        if (!interfaces[0].getName().equals("org.jboss.test.aop.reflection.Introduction")) {
            throw new RuntimeException("Did not get expected interface org.jboss.test.aop.reflection.Introduction");
        }
    }

    public void testCleanGetDeclaredMethod() {
        System.out.println("*** reflection (from method): Class.getDeclaredMethod()");
        Class<ReflectionAopPOJO> pojoClass = ReflectionAopPOJO.class;
        Class<ReflectionAopRootPOJO> pojoRoot = ReflectionAopRootPOJO.class;
        try {
            Method m = pojoClass.getDeclaredMethod("method", Integer.TYPE, Long.TYPE, Short.TYPE);
            throw new RuntimeException("Should not be here: " + m);
        }
        catch (NoSuchMethodException e) {
            Method m;
            try {
                m = pojoRoot.getDeclaredMethod("method", Integer.TYPE, Long.TYPE, Short.TYPE);
                if (!(m.getName().equals("method") && m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopRootPOJO") && m.getParameterTypes()[0].equals(Integer.TYPE) && m.getParameterTypes()[1].equals(Long.TYPE))) {
                    throw new RuntimeException("Wrong method got");
                }
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException("Expected method not there");
            }
            try {
                m = pojoClass.getDeclaredMethod("method", Integer.TYPE, Long.TYPE);
                if (!(m.getName().equals("method") && m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO") && m.getParameterTypes()[0].equals(Integer.TYPE) && m.getParameterTypes()[1].equals(Long.TYPE))) {
                    throw new RuntimeException("Wrong method got");
                }
            }
            catch (NoSuchMethodException e3) {
                throw new RuntimeException("Expected method not there");
            }
            try {
                m = pojoClass.getDeclaredMethod("method", Integer.TYPE);
                if (!(m.getName().equals("method") && m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO") && m.getParameterTypes()[0].equals(Integer.TYPE))) {
                    throw new RuntimeException("Wrong method got");
                }
            }
            catch (NoSuchMethodException e4) {
                throw new RuntimeException("Expected method not there");
            }
            try {
                m = pojoClass.getDeclaredMethod("method", new Class[0]);
                if (!m.getName().equals("method") || !m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO")) {
                    throw new RuntimeException("Wrong method got");
                }
            }
            catch (NoSuchMethodException e5) {
                throw new RuntimeException("Expected method not there");
            }
            try {
                m = pojoClass.getDeclaredMethod("privateMethod", new Class[0]);
                if (!m.getName().equals("privateMethod") || !m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO")) {
                    throw new RuntimeException("Wrong method got");
                }
            }
            catch (NoSuchMethodException e6) {
                throw new RuntimeException("Expected method not there");
            }
            try {
                m = pojoClass.getMethod("notThere", new Class[0]);
                throw new RuntimeException("Method should not be there " + m);
            }
            catch (NoSuchMethodException e7) {
                try {
                    Method m2 = pojoClass.getMethod("_getAdvisor", new Class[0]);
                    throw new RuntimeException("Method should have been cleaned " + m2);
                }
                catch (NoSuchMethodException e8) {
                    try {
                        Method m3 = pojoRoot.getMethod("_getAdvisor", new Class[0]);
                        throw new RuntimeException("Method should have been cleaned " + m3);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return;
                    }
                }
            }
        }
    }

    public void testCleanGetMethod() {
        Method m;
        System.out.println("*** reflection (from method): Class.getMethod()");
        Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
        try {
            m = clazz.getMethod("method", Integer.TYPE, Long.TYPE, Short.TYPE);
            if (!(m.getName().equals("method") && m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopRootPOJO") && m.getParameterTypes()[0].equals(Integer.TYPE) && m.getParameterTypes()[1].equals(Long.TYPE))) {
                throw new RuntimeException("Wrong method got");
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Expected method not there");
        }
        try {
            m = clazz.getMethod("method", Integer.TYPE, Long.TYPE);
            if (!(m.getName().equals("method") && m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO") && m.getParameterTypes()[0].equals(Integer.TYPE) && m.getParameterTypes()[1].equals(Long.TYPE))) {
                throw new RuntimeException("Wrong method got");
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Expected method not there");
        }
        try {
            m = clazz.getMethod("method", Integer.TYPE);
            if (!(m.getName().equals("method") && m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO") && m.getParameterTypes()[0].equals(Integer.TYPE))) {
                throw new RuntimeException("Wrong method got");
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Expected method not there");
        }
        try {
            m = clazz.getMethod("method", new Class[0]);
            if (!m.getName().equals("method") || !m.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO")) {
                throw new RuntimeException("Wrong method got");
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Expected method not there");
        }
        try {
            m = clazz.getMethod("notThere", new Class[0]);
            throw new RuntimeException("Method should not be there " + m);
        }
        catch (NoSuchMethodException e) {
            try {
                Method m2 = clazz.getMethod("_getAdvisor", new Class[0]);
                throw new RuntimeException("Method should have been cleaned " + m2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }
    }

    public void testCleanGetDeclaredField() {
        Field f;
        System.out.println("*** reflection (from method): Class.getDeclaredField()");
        Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
        try {
            f = clazz.getDeclaredField("i");
            if (!(f.getName().equals("i") && f.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO") && f.getType().equals(Integer.TYPE))) {
                throw new RuntimeException("Wrong field got");
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Expected method not there");
        }
        try {
            f = clazz.getDeclaredField("j");
            if (!(f.getName().equals("j") && f.getDeclaringClass().getName().equals("org.jboss.test.aop.reflection.ReflectionAopPOJO") && f.getType().equals(Integer.TYPE))) {
                throw new RuntimeException("Wrong field got");
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Expected method not there");
        }
    }

    public void testCleanGetClasses() {
        System.out.println("*** reflection (from method): Class.getClasses()");
        HashSet<String> classSet = new HashSet<String>();
        classSet.add("org.jboss.test.aop.reflection.ReflectionAopPOJO$AopPOJOInner");
        classSet.add("org.jboss.test.aop.reflection.ReflectionAopRootPOJO$AopRootPOJOInner");
        Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
        Class<?>[] classes = clazz.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            String name = classes[i].getName();
            if (classSet.contains(name)) continue;
            throw new RuntimeException(name + " was in the list of classes and should have been removed");
        }
        if (classes.length != classSet.size()) {
            throw new RuntimeException("Not all the declared classes were returned");
        }
    }

    public void testCleanGetDeclaredClasses() {
        System.out.println("*** reflection (from method): Class.getDeclaredClasses()");
        HashSet<String> declaredClasses = new HashSet<String>();
        declaredClasses.add("org.jboss.test.aop.reflection.ReflectionAopPOJO$AopPOJOInner");
        Class<ReflectionAopPOJO> clazz = ReflectionAopPOJO.class;
        Class<?>[] classes = clazz.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            String name = classes[i].getName();
            if (declaredClasses.contains(name)) continue;
            throw new RuntimeException(name + " was in the list of declared classes and should have been removed");
        }
        if (classes.length != declaredClasses.size()) {
            throw new RuntimeException("Not all the declared classes were returned");
        }
    }
}

