/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.schema;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTestCase
extends AOPTestWithSetup {
    public SchemaTestCase(String arg0) {
        super(arg0);
    }

    public void testSchema() throws Exception {
        URL schemaUrl = AspectXmlLoader.class.getResource("/jboss-aop_2_0.xsd");
        SchemaTestCase.assertNotNull((Object)schemaUrl);
        Schema schema = this.getSchema(schemaUrl);
        List<File> files = this.getAopXmlFiles();
        for (File file : files) {
            System.out.println("Validating " + file);
            Reader rdr = this.massageFile(file, schemaUrl);
            this.parseAndValidateXmlFile(rdr, schema);
        }
    }

    private void parseAndValidateXmlFile(Reader reader, Schema schema) throws Exception {
        MyErrorHandler handler = new MyErrorHandler();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setValidating(true);
            docBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", true);
            docBuilderFactory.setSchema(schema);
            InputSource source = new InputSource(reader);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(handler);
            docBuilder.parse(source);
        }
        catch (Exception e) {
            throw new Exception("Error reading file", e);
        }
        finally {
            reader.close();
        }
        if (handler.getType() != null && handler.getException() != null) {
            throw new Exception(handler.getType(), handler.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader massageFile(File file, URL schemaUrl) throws Exception {
        BufferedReader is = new BufferedReader(new FileReader(file));
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            InputSource source = new InputSource(is);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(source);
            Element root = doc.getDocumentElement();
            NamedNodeMap map = root.getAttributes();
            if (map.getLength() == 0) {
                StringWriter writer = new StringWriter();
                root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                root.setAttribute("xsi:noNamespaceSchemaLocation", schemaUrl.toString());
                DOMWriter domWriter = new DOMWriter((Writer)new BufferedWriter(writer));
                domWriter.setWriteXMLDeclaration(true);
                domWriter.print((Node)doc);
                StringReader stringReader = new StringReader(writer.getBuffer().toString());
                return stringReader;
            }
        }
        finally {
            ((Reader)is).close();
        }
        return new BufferedReader(new FileReader(file));
    }

    private Schema getSchema(URL url) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(url);
        return schema;
    }

    private List<File> getAopXmlFiles() throws IOException, URISyntaxException {
        URL url = this.getURLRelativeToProjectRoot("/src/resources/test/");
        File root = new File(url.toURI());
        ArrayList<File> files = new ArrayList<File>();
        this.getAopXmlFiles(files, root);
        return files;
    }

    private void getAopXmlFiles(List<File> files, File directory) {
        File[] dirFiles;
        for (File file : dirFiles = directory.listFiles()) {
            if (file.getName().equals(".svn")) continue;
            if (file.isDirectory()) {
                this.getAopXmlFiles(files, file);
                continue;
            }
            if (!file.getPath().endsWith("-aop.xml")) continue;
            files.add(file);
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        String type;
        SAXParseException exception;

        private MyErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.exception = exception;
            this.type = "Parser Error";
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.exception = exception;
            this.type = "Parser Fatal Error";
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.exception = exception;
            this.type = "Parser Warning";
        }

        protected String getType() {
            return this.type;
        }

        protected SAXParseException getException() {
            return this.exception;
        }
    }
}

