/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.stress;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.jboss.test.aop.stress.Scenario;
import org.jboss.test.aop.stress.ScenarioLoggingDecorator;
import org.jboss.test.aop.stress.ScenarioPropertyReader;
import org.jboss.test.aop.stress.ScenarioPropertyReaderFactory;
import org.jboss.test.aop.stress.SkipWarmup;

public class ScenarioRunner {
    private Class testCaseClass;
    ScenarioPropertyReaderFactory factory;
    private int warmup;
    private int loops;
    private int threads;
    private boolean randomSleepInterval;
    private int sleeptimeMillis;
    Random random = new Random(10L);
    boolean logging;

    public ScenarioRunner(Class testCaseClass) {
        this.testCaseClass = testCaseClass;
        this.factory = new ScenarioPropertyReaderFactory(testCaseClass);
    }

    private void initialisePropertiesForTest(TestCase testCase) {
        String testName = testCase == null ? "" : testCase.getName();
        ScenarioPropertyReader reader = this.factory.getPropertyReader(testName);
        this.warmup = reader.getIntProperty("warmup");
        this.loops = reader.getIntProperty("loops");
        this.threads = reader.getIntProperty("threads");
        this.randomSleepInterval = reader.getBooleanProperty("random_sleep_interval");
        this.sleeptimeMillis = reader.getIntProperty("sleeptime_millis");
        this.logging = reader.getBooleanProperty("logging");
        System.out.println("============================================");
        System.out.println("Configured ScenarioRunner for " + this.testCaseClass.getName() + "." + testName);
        System.out.println("   warmup:                  " + this.warmup);
        System.out.println("   loops:                   " + this.loops);
        System.out.println("   threads:                 " + this.threads);
        System.out.println("   Random sleep Interval:   " + this.randomSleepInterval);
        System.out.println("   Sleep time millis:       " + this.randomSleepInterval);
        System.out.println("   Logging:                 " + this.logging);
        System.out.println("============================================");
    }

    public void executeScenario(Scenario scenario, TestCase testCase) throws Exception {
        Scenario[] scenarios = new Scenario[]{scenario};
        this.executeScenario(scenarios, testCase);
    }

    public void executeScenario(Scenario[] scenarios, TestCase testCase) throws Exception {
        this.initialisePropertiesForTest(testCase);
        this.warmupScenario(scenarios);
        this.executeScenarios(scenarios);
    }

    private void warmupScenario(Scenario[] scenarios) throws Exception {
        ScenarioLoader loader = this.getLoader(0, scenarios, true);
        loader.start();
        loader.join();
    }

    private void executeScenarios(Scenario[] scenarios) throws Exception {
        int thread;
        int thread2;
        System.out.println("Starting run with Scenarios " + this.getScenarioNames(scenarios));
        long start = System.currentTimeMillis();
        ScenarioLoader[] loaders = new ScenarioLoader[this.threads];
        for (thread2 = 0; thread2 < this.threads; ++thread2) {
            loaders[thread2] = this.getLoader(thread2, scenarios, false);
        }
        System.out.println("Starting threads...");
        for (thread2 = 0; thread2 < loaders.length; ++thread2) {
            loaders[thread2].start();
        }
        for (thread2 = 0; thread2 < loaders.length; ++thread2) {
            loaders[thread2].join();
        }
        long end = System.currentTimeMillis();
        boolean hadExceptions = false;
        for (thread = 0; thread < loaders.length; ++thread) {
            if (loaders[thread].exceptions.size() <= 0) continue;
            hadExceptions = true;
            Iterator it = loaders[thread].exceptions.iterator();
            while (it.hasNext()) {
                ((Exception)it.next()).printStackTrace(System.err);
            }
        }
        System.out.println("--- DONE --- test took " + (end - start) + " ms");
        for (thread = 0; thread < loaders.length; ++thread) {
            loaders[thread] = null;
        }
        if (hadExceptions) {
            throw new Exception("Exceptions occurred, see System.err");
        }
    }

    private ScenarioLoader getLoader(int thread, Scenario[] scenarios, boolean forWarmup) {
        int num = thread % scenarios.length;
        Scenario scenario = scenarios[num];
        if (this.logging) {
            scenario = new ScenarioLoggingDecorator(scenario);
        }
        return new ScenarioLoader(scenario, thread, forWarmup);
    }

    private int getSleepInterval() {
        if (this.sleeptimeMillis == 0) {
            return this.sleeptimeMillis;
        }
        if (this.randomSleepInterval) {
            return this.random.nextInt(this.sleeptimeMillis);
        }
        return this.sleeptimeMillis;
    }

    private String getScenarioNames(Scenario[] scenarios) {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < scenarios.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(scenarios[i].getName());
        }
        buf.append("]");
        return buf.toString();
    }

    private class ScenarioLoader
    extends Thread {
        int thread;
        Scenario scenario;
        int loop;
        ArrayList exceptions = new ArrayList();
        boolean forWarmup;

        ScenarioLoader(Scenario scenario, int thread, boolean forWarmup) {
            this.scenario = scenario;
            this.thread = thread;
            this.forWarmup = forWarmup;
        }

        public void run() {
            if (this.forWarmup && this.scenario.getClass().isAnnotationPresent(SkipWarmup.class)) {
                System.out.println("Skipping warmup for " + this.scenario.getName());
                return;
            }
            int max = this.forWarmup ? ScenarioRunner.this.warmup : ScenarioRunner.this.loops;
            try {
                while (this.loop++ < max) {
                    this.scenario.execute(this.thread, this.loop);
                    Thread.sleep(ScenarioRunner.this.getSleepInterval());
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                this.exceptions.add(e);
                e.printStackTrace();
            }
        }
    }
}

