/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.stress.weavetest;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.jboss.aop.classpool.AOPClassPoolRepository;
import org.jboss.test.aop.stress.AbstractScenario;
import org.jboss.test.aop.stress.SkipWarmup;
import org.jboss.test.aop.stress.weavetest.Factory;
import org.jboss.test.aop.stress.weavetest.MethodCaller;
import org.jboss.test.aop.stress.weavetest.TemplatePOJO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SkipWarmup
public class GenerateClassesScenario
extends AbstractScenario {
    private static final String WOVEN = ".Woven";
    private static final String VANILLA = ".Vanilla";
    boolean initialised;
    private File directory;
    ClassPool pool;
    String packageName;
    List<Factory> wovenFactories = new ArrayList<Factory>();
    List<Factory> vanillaFactories = new ArrayList<Factory>();

    public List<Factory> getVanillaFactories() {
        return this.vanillaFactories;
    }

    public List<Factory> getWovenFactories() {
        return this.wovenFactories;
    }

    @Override
    public void execute(int thread, int loop) throws Exception {
        if (thread > 0) {
            throw new RuntimeException("This test can only be used with one thred");
        }
        if (!this.initialised) {
            this.initialise();
            this.initialised = true;
        }
        this.vanillaFactories.add(this.generateClassAndFactory(loop, VANILLA));
        this.wovenFactories.add(this.generateClassAndFactory(loop, WOVEN));
    }

    private Factory generateClassAndFactory(int loop, String rootName) throws Exception {
        CtClass clazz = this.createClass(loop, rootName);
        clazz.writeFile(this.directory.getAbsolutePath());
        clazz.detach();
        CtClass factoryClass = this.createFactory(loop, rootName);
        factoryClass.writeFile(this.directory.getAbsolutePath());
        Class realClass = factoryClass.toClass();
        return (Factory)realClass.newInstance();
    }

    private CtClass createClass(int loop, String rootName) throws Exception {
        CtClass clazz = this.pool.makeClass(this.packageName + rootName + loop);
        clazz.addInterface(this.pool.get(MethodCaller.class.getName()));
        CtField field = new CtField(CtClass.intType, "counter", clazz);
        field.setModifiers(0);
        clazz.addField(field);
        CtMethod method = CtNewMethod.make((String)"public void method(){counter++;}", (CtClass)clazz);
        method.setModifiers(1);
        clazz.addMethod(method);
        return clazz;
    }

    private CtClass createFactory(int loop, String rootName) throws Exception {
        CtClass clazz = this.pool.makeClass(this.packageName + rootName + "Factory" + loop);
        clazz.addInterface(this.pool.get(Factory.class.getName()));
        CtMethod method = CtNewMethod.make((String)("public " + this.packageName + ".MethodCaller create(){return new " + this.packageName + rootName + loop + "();}"), (CtClass)clazz);
        method.setModifiers(1);
        clazz.addMethod(method);
        method = CtNewMethod.make((String)("public java.lang.Class loadClass(){return java.lang.Class.forName(\"" + this.packageName + rootName + loop + "\", false, this.getClass().getClassLoader());}"), (CtClass)clazz);
        method.setModifiers(1);
        clazz.addMethod(method);
        return clazz;
    }

    private void initialise() throws Exception {
        this.initDirectory();
        this.pool = AOPClassPoolRepository.getInstance().registerClassLoader(this.getClass().getClassLoader());
        this.packageName = this.getClass().getPackage().getName();
        CtClass clazz = this.pool.get("org.jboss.test.aop.stress.weavetest.TemplatePOJO");
        if (clazz == null) {
            throw new RuntimeException(TemplatePOJO.class.getName() + " does not exist in pool");
        }
    }

    private void initDirectory() throws Exception {
        URL url = TemplatePOJO.class.getProtectionDomain().getCodeSource().getLocation();
        URI uri = url.toURI();
        this.directory = new File(uri);
    }
}

