/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.ClassicCallerInfoAdder;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedCallerInvocations;

public class OptimizedCallerTransformer
extends CallerTransformer {
    public OptimizedCallerTransformer(Instrumentor instrumentor, AspectManager manager) {
        super(instrumentor, manager, true, new ClassicCallerInfoAdder(instrumentor));
    }

    protected CallerTransformer.CallerExprEditor callerExprEditorFactory(ClassAdvisor advisor, CtClass clazz) {
        return new OptimizedCallerExprEditor(advisor, clazz);
    }

    class OptimizedCallerExprEditor
    extends CallerTransformer.CallerExprEditor {
        public OptimizedCallerExprEditor(ClassAdvisor advisor, CtClass callingClass) {
            super(OptimizedCallerTransformer.this, advisor, callingClass);
        }

        protected void setupConstructor(CallerTransformer.ConstructorDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                String createName = this.getOptimizedMethodCalledByConstructorClassName(cd.callingIndex, this.callingClass.getName(), cd.calledHash);
                String invocationClassName = OptimizedCallerInvocations.createOptimizedMethodCalledByConInvocationClass(OptimizedCallerTransformer.this.instrumentor, createName, this.callingClass, cd.calledMethod, cd.callingIndex, cd.calledHash);
                this.callerInfos.put(cd.callerInfoField, invocationClassName);
                OptimizedCallerTransformer.this.callerInfoAdder.addMethodByConInfoField(this.callingClass, cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
            }
        }

        protected void setupMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(md.callerInfoField) == null) {
                String createName = this.getOptimizedMethodCalledByMethodClassName(md.callingHash, this.callingClass.getName(), md.calledHash);
                String invocationClassName = OptimizedCallerInvocations.createOptimizedMethodCalledByMethodInvocationClass(OptimizedCallerTransformer.this.instrumentor, createName, this.callingClass, md.calledMethod, md.callingHash, md.calledHash);
                this.callerInfos.put(md.callerInfoField, invocationClassName);
                OptimizedCallerTransformer.this.callerInfoAdder.addMethodByMethodInfoField(this.callingClass, md.callerInfoField, md.callingHash, md.classname, md.calledHash);
            }
        }

        protected void setupMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                if (!cd.isTgtConAdvised) {
                    String createName = this.getOptimizedConCalledByMethodInvocationClassName(cd.callingHash, this.callingClass.getName(), cd.calledHash);
                    String invocationClassName = OptimizedCallerInvocations.createOptimizedConCalledByMethodInvocationClass(OptimizedCallerTransformer.this.instrumentor, createName, this.callingClass, cd.calledConstructor, cd.callingHash, cd.calledHash);
                    this.callerInfos.put(cd.callerInfoField, invocationClassName);
                } else {
                    this.callerInfos.put(cd.callerInfoField, "whatever");
                }
                OptimizedCallerTransformer.this.callerInfoAdder.addConByMethodInfoField(this.callingClass, cd.callerInfoField, cd.callingHash, cd.classname, cd.calledHash);
            }
        }

        protected void setupConstructor(CallerTransformer.ConByConDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                if (!cd.isTgtConAdvised) {
                    String createName = this.getOptimizedConCalledByConInvocationClassName(cd.callingIndex, this.callingClass.getName(), cd.calledHash);
                    String invocationClassName = OptimizedCallerInvocations.createOptimizedConCalledByConInvocationClass(OptimizedCallerTransformer.this.instrumentor, createName, this.callingClass, cd.calledConstructor, cd.callingIndex, cd.calledHash);
                    this.callerInfos.put(cd.callerInfoField, invocationClassName);
                } else {
                    this.callerInfos.put(cd.callerInfoField, "whatever");
                }
                OptimizedCallerTransformer.this.callerInfoAdder.addConByConInfoField(this.callingClass, cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
            }
        }

        protected void replaceMethodCallInCon(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException {
            String invocationClassName = (String)this.callerInfos.get(cd.callerInfoField);
            String typedTargetObject = Modifier.isStatic(cd.calledMethod.getModifiers()) ? "" : "invocation.typedTargetObject=$0;";
            String replaced = CallerTransformer.methodByConInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "    (info, this, $0, $args, info.getInterceptors());" + typedTargetObject + OptimizedBehaviourInvocations.setArguments(cd.calledMethod.getParameterTypes().length) + "invocation.setTargetObject($0);" + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
            cd.call.replace(replaced);
        }

        protected void replaceMethodCallInMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException {
            String callingObject = ", null";
            if (!Modifier.isStatic(md.where.getModifiers())) {
                callingObject = ", this";
            }
            String invocationClassName = (String)this.callerInfos.get(md.callerInfoField);
            String typedTargetObject = Modifier.isStatic(md.calledMethod.getModifiers()) ? "" : "invocation.typedTargetObject=$0;";
            String replaced = CallerTransformer.methodByMethodInfoFromWeakReference("info", md.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "    (info" + callingObject + ", $0, $args, info.getInterceptors());" + OptimizedBehaviourInvocations.setArguments(md.calledMethod.getParameterTypes().length) + typedTargetObject + "invocation.setTargetObject($0);" + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
            md.call.replace(replaced);
        }

        protected void replaceConCallInMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            if (cd.isTgtConAdvised) {
                super.replaceConCallInMethod(cd);
                return;
            }
            String callingObject = "null";
            if (!Modifier.isStatic(cd.where.getModifiers())) {
                callingObject = "this";
            }
            String invocationClassName = (String)this.callerInfos.get(cd.callerInfoField);
            String replaced = CallerTransformer.conByMethodInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + "java.lang.Object callingObject = " + callingObject + "; " + invocationClassName + " invocation = new " + invocationClassName + "    (info," + callingObject + ", $args, info.getInterceptors());" + OptimizedBehaviourInvocations.setArguments(cd.calledConstructor.getParameterTypes().length) + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
            cd.call.replace(replaced);
        }

        protected void replaceConCallInCon(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            if (cd.isTgtConAdvised) {
                super.replaceConCallInCon(cd);
                return;
            }
            String invocationClassName = (String)this.callerInfos.get(cd.callerInfoField);
            String replaced = CallerTransformer.conByConInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "(info, this, $args, info.getInterceptors());" + OptimizedBehaviourInvocations.setArguments(cd.calledConstructor.getParameterTypes().length) + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
            cd.call.replace(replaced);
        }
    }
}

