/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.AbstractJavassistBody;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;
import org.jboss.reflect.plugins.javassist.JavassistParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.Body;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.ModifierInfo;
import org.jboss.reflect.spi.MutableConstructorInfo;
import org.jboss.reflect.spi.NotFoundException;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistConstructorInfo
extends JavassistAnnotatedParameterInfo
implements MutableConstructorInfo {
    private static final long serialVersionUID = -2255405601790592604L;
    private static final JavassistReflectionFactory reflectionFactory = new JavassistReflectionFactory(true);
    private CtConstructor ctConstructor;
    private transient JavassistConstructor constructor;

    public JavassistConstructorInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtConstructor ctConstructor) {
        super(annotationHelper);
        this.typeInfo = typeInfo;
        this.ctConstructor = ctConstructor;
    }

    public int getModifiers() {
        return this.ctConstructor.getModifiers();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.ctConstructor.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.ctConstructor.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.ctConstructor.getModifiers());
    }

    public ClassInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            try {
                CtClass[] types = this.ctConstructor.getExceptionTypes();
                this.exceptionTypes = new ClassInfo[types.length];
                for (int i = 0; i < types.length; ++i) {
                    this.exceptionTypes[i] = (ClassInfo)this.typeInfo.getFactory().getTypeInfo(types[i]);
                }
            }
            catch (javassist.NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for exception types of constructor", e);
            }
        }
        return this.exceptionTypes;
    }

    public ParameterInfo[] getParameters() {
        if (this.parameters == null) {
            this.generateParameters();
        }
        return this.parameters;
    }

    public TypeInfo[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.generateParameters();
        }
        return this.parameterTypes;
    }

    public Object newInstance(Object[] args) throws Throwable {
        if (this.constructor == null) {
            this.constructor = reflectionFactory.createConstructor(this.ctConstructor);
        }
        return this.constructor.newInstance(args);
    }

    protected int getHashCode() {
        int result = this.getDeclaringClass().hashCode();
        this.generateParameters();
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                result = 29 * result + this.parameterTypes[i].hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ConstructorInfo)) {
            return false;
        }
        ConstructorInfo other = (ConstructorInfo)obj;
        if (!this.getDeclaringClass().equals(other.getDeclaringClass())) {
            return false;
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append(Arrays.asList(this.getParameterTypes()));
        super.toString(buffer);
    }

    protected void generateParameters() {
        try {
            int i;
            CtClass[] types = this.ctConstructor.getParameterTypes();
            this.parameterTypes = new TypeInfo[types.length];
            for (i = 0; i < types.length; ++i) {
                this.parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(types[i]);
            }
            this.parameters = new ParameterInfo[types.length];
            for (i = 0; i < types.length; ++i) {
                this.parameters[i] = new JavassistParameterInfo(this.annotationHelper, this, i, this.parameterTypes[i]);
            }
        }
        catch (javassist.NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for parameters of constructor", e);
        }
    }

    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.ctConstructor);
    }

    protected void createParameterAnnotations() {
        try {
            Object[][] parameterAnnotations = this.ctConstructor.getParameterAnnotations();
            super.setupParameterAnnotations(parameterAnnotations);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected CtConstructor getCtConstructor() {
        return this.ctConstructor;
    }

    public void setBody(Body body) {
        if (!(body instanceof AbstractJavassistBody)) {
            throw new IllegalArgumentException("Body is not an instance of AbstractJavassistBody");
        }
        ((AbstractJavassistBody)body).createBody(this.ctConstructor);
        this.typeInfo.clearConstructorCache();
    }

    public void setExceptions(String[] exceptions) {
        try {
            this.ctConstructor.setExceptionTypes(JavassistUtil.toCtClass(exceptions));
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
        this.typeInfo.clearConstructorCache();
    }

    public void setExceptions(ClassInfo[] exceptions) {
        try {
            this.ctConstructor.setExceptionTypes(JavassistUtil.toCtClass(exceptions));
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
        this.typeInfo.clearConstructorCache();
    }

    public void setModifier(ModifierInfo mi) {
        this.typeInfo.clearMethodCache();
        this.ctConstructor.setModifiers(mi.getModifiers());
    }

    public void setParameters(String[] parameters) {
        for (String p : parameters) {
            try {
                this.ctConstructor.addParameter(JavassistUtil.toCtClass(p));
            }
            catch (CannotCompileException e) {
                throw new org.jboss.reflect.spi.CannotCompileException(e.toString());
            }
        }
        this.typeInfo.clearConstructorCache();
    }

    public void setParameters(ClassInfo[] parameters) {
        for (ClassInfo clazz : parameters) {
            try {
                this.ctConstructor.addParameter(JavassistUtil.toCtClass(clazz));
            }
            catch (CannotCompileException e) {
                throw new org.jboss.reflect.spi.CannotCompileException(e.toString());
            }
        }
        this.typeInfo.clearConstructorCache();
    }
}

