/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.util.Arrays;
import java.util.Stack;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistHelper {
    static String determineType(CtClass clazz, CtClass search, int parameter) {
        Stack<CtClass> hierarchy = new Stack<CtClass>();
        try {
            JavassistHelper.determineHierarchy(hierarchy, clazz, search);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return JavassistHelper.determineType(hierarchy, parameter);
    }

    static int determineInfoIndex(TypeInfo[] actualTypeArguments, CtClass clazz, CtClass search, int parameter) {
        Stack<CtClass> hierarchy = new Stack<CtClass>();
        try {
            JavassistHelper.determineHierarchy(hierarchy, clazz, search);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return JavassistHelper.determineInfoIndex(actualTypeArguments, hierarchy, parameter);
    }

    private static String determineType(Stack<CtClass> hierarchy, int parameter) {
        TypeDecider decider = new TypeDecider();
        decider.determineType(hierarchy, parameter);
        return decider.name;
    }

    private static int determineInfoIndex(TypeInfo[] actualTypeArguments, Stack<CtClass> hierarchy, int parameter) {
        TypeDecider decider = new TypeDecider();
        decider.determineType(hierarchy, parameter);
        return decider.lastIndex;
    }

    static SignatureAttribute.ClassSignature getClassSignature(CtClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        SignatureAttribute signature = (SignatureAttribute)clazz.getClassFile().getAttribute("Signature");
        if (signature == null) {
            return null;
        }
        String sig = signature.getSignature();
        try {
            return SignatureAttribute.toClassSignature(sig);
        }
        catch (BadBytecode e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean determineHierarchy(Stack<CtClass> hierarchy, CtClass current, CtClass search) throws NotFoundException {
        CtClass superClass;
        boolean result;
        if (hierarchy == null) {
            throw new IllegalArgumentException("Null hierarchy");
        }
        if (current == null) {
            throw new IllegalArgumentException("Null current");
        }
        if (search == null) {
            throw new IllegalArgumentException("Null search");
        }
        if (current == null) {
            return false;
        }
        hierarchy.push(current);
        if (current.equals(search)) {
            return true;
        }
        CtClass[] interfaces = current.getInterfaces();
        if (search.isInterface() && interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                result = JavassistHelper.determineHierarchy(hierarchy, interfaces[i], search);
                if (!result) continue;
                return true;
            }
        }
        if (result = JavassistHelper.determineHierarchy(hierarchy, superClass = current.getSuperclass(), search)) {
            return true;
        }
        hierarchy.pop();
        return false;
    }

    private static SignatureAttribute.TypeArgument findSuperClassOrInterfaceArguments(CtClass parent, SignatureAttribute.ClassSignature classSig, int index) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        SignatureAttribute.TypeArgument[] arguments = null;
        if (parent.isInterface()) {
            Object[] types = classSig.getInterfaces();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].getName().equals(parent.getName())) continue;
                arguments = types[i].getTypeArguments();
                break;
            }
            if (arguments == null) {
                throw new IllegalStateException("Could not find " + parent.getName() + " in " + Arrays.toString(types));
            }
        } else {
            arguments = classSig.getSuperClass().getTypeArguments();
        }
        if (arguments.length <= index) {
            throw new IllegalArgumentException("Argument " + index + " requested, but only " + arguments.length + " exist");
        }
        return arguments[index];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDecider {
        int lastIndex;
        CtClass last = null;
        String name;

        private TypeDecider() {
        }

        private void determineType(Stack<CtClass> hierarchy, int parameter) {
            CtClass clazz = null;
            SignatureAttribute.TypeParameter targetType = null;
            this.lastIndex = parameter;
            block0: while (!hierarchy.empty()) {
                this.last = clazz;
                clazz = hierarchy.pop();
                SignatureAttribute.ClassSignature classSig = JavassistHelper.getClassSignature(clazz);
                if (classSig == null) break;
                SignatureAttribute.TypeParameter[] typeParameters = classSig.getParameters();
                if (this.last == null) {
                    if (typeParameters.length <= parameter) {
                        throw new IllegalArgumentException("Parameter " + parameter + " requested, but only " + typeParameters.length + " exist.");
                    }
                    targetType = typeParameters[parameter];
                    continue;
                }
                SignatureAttribute.TypeArgument argument = JavassistHelper.findSuperClassOrInterfaceArguments(this.last, classSig, this.lastIndex);
                SignatureAttribute.ObjectType type = argument.getType();
                if (type == null) continue;
                if (type instanceof SignatureAttribute.ClassType) {
                    this.name = ((SignatureAttribute.ClassType)type).getName();
                    return;
                }
                String name = null;
                if (type instanceof SignatureAttribute.TypeVariable) {
                    name = ((SignatureAttribute.TypeVariable)type).getName();
                }
                for (int i = 0; i < typeParameters.length; ++i) {
                    if (!typeParameters[i].getName().equals(name)) continue;
                    this.lastIndex = i;
                    targetType = typeParameters[i];
                    continue block0;
                }
            }
            if (targetType != null) {
                this.name = ((SignatureAttribute.ClassType)targetType.getClassBound()).getName();
                return;
            }
        }
    }
}

