/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.AbstractJavassistBody;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.Body;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ModifierInfo;
import org.jboss.reflect.spi.MutableMethodInfo;
import org.jboss.reflect.spi.MutableMethodInfoCommand;
import org.jboss.reflect.spi.NotFoundException;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistMethodInfo
extends JavassistAnnotatedParameterInfo
implements MutableMethodInfo {
    private static final long serialVersionUID = 101183748227690112L;
    private static final JavassistReflectionFactory reflectionFactory = new JavassistReflectionFactory(true);
    private CtMethod ctMethod;
    private transient JavassistMethod method;
    private transient TypeInfo returnType;

    public JavassistMethodInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtMethod ctMethod) {
        super(annotationHelper);
        this.typeInfo = typeInfo;
        this.ctMethod = ctMethod;
    }

    public String getName() {
        return this.ctMethod.getName();
    }

    public ClassInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public int getModifiers() {
        return this.ctMethod.getModifiers();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            try {
                CtClass[] types = this.ctMethod.getExceptionTypes();
                this.exceptionTypes = new ClassInfo[types.length];
                for (int i = 0; i < types.length; ++i) {
                    this.exceptionTypes[i] = (ClassInfo)this.typeInfo.getFactory().getTypeInfo(types[i]);
                }
            }
            catch (javassist.NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for exception types of method " + this.getName(), e);
            }
        }
        return this.exceptionTypes;
    }

    public TypeInfo getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        try {
            CtClass clazz = this.ctMethod.getReturnType();
            this.returnType = this.typeInfo.getFactory().getTypeInfo(clazz);
            return this.returnType;
        }
        catch (javassist.NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for return type of method " + this.getName(), e);
        }
    }

    public ParameterInfo[] getParameters() {
        if (this.parameters == null) {
            this.generateParameters();
        }
        return this.parameters;
    }

    public TypeInfo[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.generateParameters();
        }
        return this.parameterTypes;
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        if (this.method == null) {
            this.method = reflectionFactory.createMethod(this.ctMethod);
        }
        return this.method.invoke(target, args);
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDeclaringClass().equals(other.getDeclaringClass())) {
            return false;
        }
        if (!this.getReturnType().equals(other.getReturnType())) {
            return false;
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    protected void generateParameters() {
        try {
            int i;
            CtClass[] types = this.ctMethod.getParameterTypes();
            this.parameterTypes = new TypeInfo[types.length];
            for (i = 0; i < types.length; ++i) {
                this.parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(types[i]);
            }
            this.parameters = new ParameterInfo[types.length];
            for (i = 0; i < types.length; ++i) {
                this.parameters[i] = new JavassistParameterInfo(this.annotationHelper, this, i, this.parameterTypes[i]);
            }
        }
        catch (javassist.NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for parameters of " + this.getName(), e);
        }
    }

    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.ctMethod);
    }

    protected CtBehavior getParameterizedObject() {
        return this.ctMethod;
    }

    protected void createParameterAnnotations() {
        try {
            Object[][] parameterAnnotations = this.ctMethod.getParameterAnnotations();
            super.setupParameterAnnotations(parameterAnnotations);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void executeCommand(MutableMethodInfoCommand mmc) {
    }

    public CtMethod getCtMethod() {
        return this.ctMethod;
    }

    public void setBody(Body body) {
        this.typeInfo.clearMethodCache();
        if (!(body instanceof AbstractJavassistBody)) {
            throw new IllegalArgumentException("Body is not an instance of AbstractJavassistBody");
        }
        ((AbstractJavassistBody)body).createBody(this.ctMethod);
    }

    public void setExceptions(String[] exceptions) {
        this.typeInfo.clearMethodCache();
        try {
            this.ctMethod.setExceptionTypes(JavassistUtil.toCtClass(exceptions));
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
    }

    public void setExceptions(ClassInfo[] exceptions) {
        try {
            this.ctMethod.setExceptionTypes(JavassistUtil.toCtClass(exceptions));
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
        this.typeInfo.clearMethodCache();
    }

    public void setModifier(ModifierInfo mi) {
        this.ctMethod.setModifiers(mi.getModifiers());
        this.typeInfo.clearMethodCache();
    }

    public void setName(String name) {
        this.ctMethod.setName(name);
        this.typeInfo.clearMethodCache();
    }

    public void setParameters(String[] parameters) {
        for (String p : parameters) {
            try {
                this.ctMethod.addParameter(JavassistUtil.toCtClass(p));
            }
            catch (CannotCompileException e) {
                throw new org.jboss.reflect.spi.CannotCompileException(e.toString());
            }
        }
        this.typeInfo.clearMethodCache();
    }

    public void setParameters(ClassInfo[] parameters) {
        for (ClassInfo clazz : parameters) {
            try {
                this.ctMethod.addParameter(JavassistUtil.toCtClass(clazz));
            }
            catch (CannotCompileException e) {
                throw new org.jboss.reflect.spi.CannotCompileException(e.toString());
            }
        }
        this.typeInfo.clearMethodCache();
    }

    public void setReturnType(String returnType) {
        throw new RuntimeException("Method not supported by Javassist");
    }

    public void setReturnType(ClassInfo returnType) {
        throw new RuntimeException("Method not supported by Javassist");
    }
}

