/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.AnnotationAttributeImpl;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationValueFactory;
import org.jboss.reflect.plugins.AnnotationValueImpl;
import org.jboss.reflect.plugins.EnumConstantInfoImpl;
import org.jboss.reflect.plugins.javassist.JavassistAnnotationInfo;
import org.jboss.reflect.plugins.javassist.JavassistArrayInfoImpl;
import org.jboss.reflect.plugins.javassist.JavassistEnumInfo;
import org.jboss.reflect.plugins.javassist.JavassistParameterizedClassInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.plugins.javassist.classpool.ClassPoolFactory;
import org.jboss.reflect.plugins.javassist.classpool.DefaultClassPoolFactory;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MutableClassInfo;
import org.jboss.reflect.spi.MutableTypeInfoFactory;
import org.jboss.reflect.spi.NumberInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.NotImplementedException;
import org.jboss.util.collection.WeakClassCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistTypeInfoFactoryImpl
extends WeakClassCache
implements MutableTypeInfoFactory,
AnnotationHelper {
    private static ClassPoolFactory poolFactory = DefaultClassPoolFactory.getInstance();
    static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];

    public static ClassPoolFactory getPoolFactory() {
        return poolFactory;
    }

    public static void setPoolFactory(ClassPoolFactory classPoolFactory) {
        poolFactory = classPoolFactory;
    }

    public static NoClassDefFoundError raiseClassNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class " + name);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    public static NoClassDefFoundError raiseClassNotFound(String name, ClassNotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class " + name);
        ex.initCause(e);
        throw ex;
    }

    public static NoClassDefFoundError raiseMethodNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoSuchMethodError ex = new NoSuchMethodError("Unable to find method " + name);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    public static NoClassDefFoundError raiseFieldNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoSuchFieldError ex = new NoSuchFieldError("Unable to find field " + name);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    protected Object instantiate(Class clazz) {
        try {
            CtClass ctClass = this.getCtClass(clazz.getName(), clazz.getClassLoader());
            if (clazz.isArray()) {
                TypeInfo componentType = this.getTypeInfo(clazz.getComponentType());
                return new JavassistArrayInfoImpl(this, ctClass, clazz, componentType);
            }
            if (ctClass.isAnnotation()) {
                JavassistAnnotationInfo result = new JavassistAnnotationInfo(this, ctClass, clazz);
                CtMethod[] methods = ctClass.getDeclaredMethods();
                AnnotationAttributeImpl[] atttributes = new AnnotationAttributeImpl[methods.length];
                for (int i = 0; i < methods.length; ++i) {
                    atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), this.getTypeInfo(methods[i].getReturnType()), null);
                }
                result.setAttributes(atttributes);
                return result;
            }
            if (ctClass.isEnum()) {
                JavassistEnumInfo enumInfo = new JavassistEnumInfo(this, ctClass, clazz);
                CtField[] fields = ctClass.getFields();
                EnumConstantInfoImpl[] constants = new EnumConstantInfoImpl[fields.length];
                int i = 0;
                for (CtField field : fields) {
                    AnnotationValue[] annotations = this.getAnnotations(field);
                    constants[i++] = new EnumConstantInfoImpl(field.getName(), enumInfo, annotations);
                }
                enumInfo.setEnumConstants(constants);
                return enumInfo;
            }
            return new JavassistTypeInfo(this, ctClass, clazz);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected TypeInfo instantiate(CtClass ctClass, Class<?> clazz) {
        try {
            if (ctClass.isArray()) {
                TypeInfo componentType = this.getTypeInfo(ctClass.getComponentType());
                return new JavassistArrayInfoImpl(this, ctClass, clazz, componentType);
            }
            if (ctClass.isAnnotation()) {
                JavassistAnnotationInfo result = new JavassistAnnotationInfo(this, ctClass, clazz);
                CtMethod[] methods = ctClass.getDeclaredMethods();
                AnnotationAttributeImpl[] atttributes = new AnnotationAttributeImpl[methods.length];
                for (int i = 0; i < methods.length; ++i) {
                    atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), this.getTypeInfo(methods[i].getReturnType()), null);
                }
                result.setAttributes(atttributes);
                return result;
            }
            if (ctClass.isEnum()) {
                JavassistEnumInfo enumInfo = new JavassistEnumInfo(this, ctClass, clazz);
                CtField[] fields = ctClass.getFields();
                EnumConstantInfoImpl[] constants = new EnumConstantInfoImpl[fields.length];
                int i = 0;
                for (CtField field : fields) {
                    AnnotationValue[] annotations = this.getAnnotations(field);
                    constants[i++] = new EnumConstantInfoImpl(field.getName(), enumInfo, annotations);
                }
                enumInfo.setEnumConstants(constants);
                return enumInfo;
            }
            return new JavassistTypeInfo(this, ctClass, clazz);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(String name, ClassLoader cl) throws ClassNotFoundException {
        return this.get(name, cl, null);
    }

    public TypeInfo get(String name, ClassLoader cl, Class<?> clazz) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        try {
            CtClass ctClass = poolFactory.getPoolForLoader(cl).get(name);
            return this.get(ctClass, clazz);
        }
        catch (NotFoundException nfe) {
            throw new ClassNotFoundException(nfe.getMessage());
        }
    }

    public TypeInfo get(Class clazz) {
        try {
            ClassLoader cl = clazz.getClassLoader();
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            return this.get(clazz.getName(), cl, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + e.getMessage());
        }
    }

    public TypeInfo get(CtClass ctClass, Class<?> clazz) {
        TypeInfo result;
        if (ctClass == null) {
            throw new IllegalArgumentException("Null class");
        }
        if (ctClass instanceof CtPrimitiveType) {
            return this.instantiate(ctClass, clazz);
        }
        Map classLoaderCache = this.getClassLoaderCache(ctClass.getClassPool().getClassLoader());
        WeakReference<Object> weak = classLoaderCache.get(ctClass.getName());
        if (weak != null && (result = (TypeInfo)weak.get()) != null) {
            if (this.compare(ctClass, (ClassInfo)result)) {
                return result;
            }
            classLoaderCache.remove(ctClass.getName());
        }
        result = this.instantiate(ctClass, clazz);
        weak = new WeakReference<TypeInfo>(result);
        classLoaderCache.put(ctClass.getName(), weak);
        return result;
    }

    protected TypeInfo getTypeInfo(CtClass ctClass) {
        try {
            String name = this.convertName(ctClass);
            ClassLoader cl = JavassistUtil.getClassLoader(ctClass);
            return this.getTypeInfo(name, cl);
        }
        catch (ClassNotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(ctClass.getName(), e);
        }
    }

    protected String convertName(CtClass clazz) {
        CtClass temp = clazz;
        if (temp.isArray()) {
            JBossStringBuilder buffer = new JBossStringBuilder();
            try {
                while (temp.isArray()) {
                    buffer.append('[');
                    temp = temp.getComponentType();
                }
                if (temp.isPrimitive()) {
                    CtPrimitiveType primitive = (CtPrimitiveType)temp;
                    buffer.append(Character.toString(primitive.getDescriptor()));
                } else {
                    buffer.append('L');
                    buffer.append(temp.getName());
                    buffer.append(';');
                }
                return buffer.toString();
            }
            catch (NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(clazz.getName(), e);
            }
        }
        return clazz.getName();
    }

    protected CtClass getCtClass(String name, ClassLoader classLoader) {
        try {
            return poolFactory.getPoolForLoader(classLoader).get(name);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(name, e);
        }
    }

    protected CtClass getCtClass(String name) {
        return this.getCtClass(name, null);
    }

    protected void generate(Class clazz, Object result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeInfo getTypeInfo(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(clazz.getName());
        if (primitive != null) {
            return primitive;
        }
        NumberInfo number = NumberInfo.valueOf(clazz.getName());
        if (number != null) {
            NumberInfo numberInfo = number;
            synchronized (numberInfo) {
                if (number.getPhase() != NumberInfo.Phase.INITIALIZING) {
                    if (number.getPhase() != NumberInfo.Phase.COMPLETE) {
                        number.initializing();
                        number.setDelegate(this.get((Class)clazz));
                    }
                    return number;
                }
            }
        }
        return this.get((Class)clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException {
        PrimitiveInfo primitive;
        if (name == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if ((primitive = PrimitiveInfo.valueOf(name)) != null) {
            return primitive;
        }
        NumberInfo number = NumberInfo.valueOf(name);
        if (number != null) {
            NumberInfo numberInfo = number;
            synchronized (numberInfo) {
                if (number.getPhase() != NumberInfo.Phase.INITIALIZING) {
                    if (number.getPhase() != NumberInfo.Phase.COMPLETE) {
                        number.initializing();
                        number.setDelegate(this.get((Class)Class.forName(name, false, cl)));
                    }
                    return number;
                }
            }
        }
        Class<?> clazz = Class.forName(name, false, cl);
        return this.getTypeInfo(clazz);
    }

    @Override
    public TypeInfo getTypeInfo(Type type) {
        if (type instanceof Class) {
            return this.getTypeInfo((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.getParameterizedType((ParameterizedType)type);
        }
        throw new NotImplementedException("getTypeInfo");
    }

    private TypeInfo getParameterizedType(ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        ClassInfo raw = (ClassInfo)this.getTypeInfo(rawType);
        Type[] types = type.getActualTypeArguments();
        TypeInfo[] typeInfos = new TypeInfo[types.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            try {
                typeInfos[i] = this.getTypeInfo(types[i]);
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return new JavassistParameterizedClassInfo(this, raw, typeInfos);
    }

    @Override
    public AnnotationValue[] getAnnotations(Object obj) {
        try {
            Object[] annotations;
            if (obj instanceof CtMember) {
                annotations = ((CtMember)obj).getAvailableAnnotations();
            } else if (obj instanceof CtClass) {
                annotations = ((CtClass)obj).getAvailableAnnotations();
            } else {
                throw new RuntimeException("Attempt was made to read annotations from unsupported type " + obj.getClass().getName() + ": " + obj);
            }
            if (annotations.length == 0) {
                return NO_ANNOTATIONS;
            }
            AnnotationValue[] annotationValues = new AnnotationValueImpl[annotations.length];
            for (int i = 0; i < annotations.length; ++i) {
                Class<? extends Annotation> clazz = ((Annotation)annotations[i]).annotationType();
                AnnotationInfo info = (AnnotationInfo)this.getTypeInfo(clazz);
                annotationValues[i] = AnnotationValueFactory.createAnnotationValue(this, this, info, annotations[i]);
            }
            return annotationValues;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public AnnotationValue createAnnotationValue(AnnotationInfo info, Object ann) {
        return AnnotationValueFactory.createAnnotationValue(this, this, info, ann);
    }

    private boolean compare(CtClass clazz, ClassInfo info) {
        return clazz.getDeclaredMethods().length == info.getDeclaredMethods().length && clazz.getDeclaredConstructors().length == info.getDeclaredConstructors().length && clazz.getDeclaredFields().length == info.getDeclaredFields().length;
    }

    @Override
    public MutableClassInfo getMutable(String name, ClassLoader cl) {
        try {
            CtClass clazz = poolFactory.getPoolForLoader(cl).get(name);
            return new JavassistTypeInfo(this, clazz, null);
        }
        catch (NotFoundException e) {
            throw new org.jboss.reflect.spi.NotFoundException(e.toString());
        }
    }

    @Override
    public MutableClassInfo createNewMutableClass(String name) {
        CtClass clazz = poolFactory.getPoolForLoader(null).makeClass(name);
        return new JavassistTypeInfo(this, clazz, null);
    }

    @Override
    public MutableClassInfo createNewMutableClass(String name, ClassInfo superClass) {
        CtClass clazz = poolFactory.getPoolForLoader(superClass.getClassLoader()).makeClass(name, JavassistUtil.toCtClass(superClass));
        return new JavassistTypeInfo(this, clazz, null);
    }

    @Override
    public MutableClassInfo createNewMutableInterface(String name) {
        CtClass clazz = poolFactory.getPoolForLoader(null).makeInterface(name);
        return new JavassistTypeInfo(this, clazz, null);
    }

    @Override
    public MutableClassInfo createNewMutableInterface(String name, ClassInfo superClass) {
        CtClass clazz = poolFactory.getPoolForLoader(superClass.getClassLoader()).makeInterface(name, JavassistUtil.toCtClass(superClass));
        return new JavassistTypeInfo(this, clazz, null);
    }
}

