/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.aop.AdvisorFactory;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.WeavingStrategySupport;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.logging.Logger;

public class ClassicWeavingStrategy
extends WeavingStrategySupport {
    private static final Logger logger = Logger.getLogger(ClassicWeavingStrategy.class);
    private boolean verbose = AspectManager.verbose;

    public byte[] translate(AspectManager manager, String className, ClassLoader loader, byte[] classfileBuffer) throws Exception {
        if (ClassicWeavingStrategy.isReEntry()) {
            return null;
        }
        ClassicWeavingStrategy.setReEntry();
        super.setTransformationStarted();
        try {
            if (manager.isNonAdvisableClassName(className)) {
                byte[] byArray = null;
                return byArray;
            }
            ScopedClassPool pool = (ScopedClassPool)ClassPoolRepository.getInstance().registerClassLoader(loader);
            CtClass clazz = null;
            try {
                clazz = pool.getLocally(className);
            }
            catch (NotFoundException e) {
                ByteArrayClassPath cp = new ByteArrayClassPath(className, classfileBuffer);
                pool.insertClassPath((ClassPath)cp);
                clazz = pool.getLocally(className);
            }
            if (clazz.isArray()) {
                if (this.verbose && logger.isDebugEnabled()) {
                    logger.debug("cannot compile, isArray: " + className);
                }
                pool.flushClass(className);
                byte[] e = null;
                return e;
            }
            if (clazz.isInterface()) {
                if (this.verbose && logger.isDebugEnabled()) {
                    logger.debug("cannot compile, isInterface: " + className);
                }
                pool.flushClass(className);
                byte[] e = null;
                return e;
            }
            if (clazz.isFrozen()) {
                if (this.verbose && logger.isDebugEnabled()) {
                    logger.debug("warning, isFrozen: " + className);
                }
                clazz.defrost();
            }
            ClassAdvisor advisor = AdvisorFactory.getClassAdvisor(clazz, manager);
            Instrumentor instrumentor = InstrumentorFactory.getInstrumentor((ClassPool)pool, manager, manager.dynamicStrategy.getJoinpointClassifier(), manager.dynamicStrategy.getDynamicTransformationObserver(clazz));
            if (!Instrumentor.isTransformable(clazz)) {
                if (this.verbose && logger.isDebugEnabled()) {
                    logger.debug("[cannot compile] implements Untransformable: " + className);
                }
                pool.flushClass(className);
                byte[] byArray = null;
                return byArray;
            }
            manager.attachMetaData(advisor, clazz, true);
            manager.applyInterfaceIntroductions(advisor, clazz);
            boolean transformed = instrumentor.transform(clazz, advisor);
            if (transformed) {
                pool.lockInCache(clazz);
                if (AspectManager.debugClasses) {
                    SecurityActions.debugWriteFile(clazz);
                }
                byte[] rtn = clazz.toBytecode();
                if (AspectManager.getPrune()) {
                    clazz.prune();
                }
                byte[] byArray = rtn;
                return byArray;
            }
            pool.soften(clazz);
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception ex) {
            if (!(ex instanceof NotFoundException)) {
                if (this.verbose) {
                    logger.error(ex);
                } else {
                    logger.error("[error] " + ex.getMessage() + ".. Do verbose mode if you want full stack trace.");
                }
            }
            throw ex;
        }
        finally {
            ClassicWeavingStrategy.clearReEntry();
        }
    }
}

