/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.aop.util.MethodHashing;

public class OptimizedMethodInvocations
extends OptimizedBehaviourInvocations {
    static String getOptimizedInvocationClassName(CtClass clazz, CtMethod method) {
        long hash = JavassistMethodHashing.methodHash(method);
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append(".").append(method.getName()).append("_").append(Long.toString(hash).replace('-', 'N'));
        return sb.toString();
    }

    public static String getOptimizedInvocationClassName(Method method) throws Exception {
        long hash = MethodHashing.methodHash(method);
        StringBuffer sb = new StringBuffer(method.getDeclaringClass().getName());
        sb.append(".").append(method.getName()).append("_").append(Long.toString(hash).replace('-', 'N'));
        return sb.toString();
    }

    protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtMethod method, CtMethod notAdvisedMethod) throws NotFoundException, CannotCompileException {
        ClassPool pool = instrumentor.getClassPool();
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        String className = OptimizedMethodInvocations.getOptimizedInvocationClassName(clazz, method);
        boolean makeInnerClass = true;
        CtClass invocation = OptimizedMethodInvocations.makeInvocationClass(pool, makeInnerClass, clazz, className, methodInvocation);
        CtClass[] params = method.getParameterTypes();
        OptimizedMethodInvocations.addArgumentFieldsAndAccessors(pool, invocation, params, true);
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        if (!isStatic) {
            CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
            target.setModifiers(1);
            invocation.addField(target);
        }
        OptimizedMethodInvocations.addDispatch(invocation, "invokeTarget", notAdvisedMethod, isStatic);
        OptimizedMethodInvocations.addCopy(invocation, method.getParameterTypes(), isStatic);
        TransformerCommon.compileOrLoadClass(method.getDeclaringClass(), invocation);
        return invocation.getName();
    }

    static final void addDispatch(CtClass invocation, String methodName, CtMethod method, boolean isStatic) throws NotFoundException, CannotCompileException {
        StringBuffer dispatchLine = new StringBuffer();
        boolean isVoid = method.getReturnType().equals(CtClass.voidType);
        if (!isVoid) {
            dispatchLine.append("return ($w)");
        }
        dispatchLine.append(isStatic ? method.getDeclaringClass().getName() : " typedTargetObject");
        dispatchLine.append('.');
        dispatchLine.append(method.getName());
        OptimizedMethodInvocations.addDispatch(invocation, methodName, method.getParameterTypes(), dispatchLine.toString(), "", isVoid ? "  return null;" : "");
    }

    static void addCopy(CtClass invocation, CtClass[] params, boolean isStatic) throws NotFoundException, CannotCompileException {
        CtMethod template = invocation.getSuperclass().getDeclaredMethod("copy");
        StringBuffer code = new StringBuffer("{");
        code.append("   ").append(invocation.getName()).append(" wrapper = new ");
        code.append(invocation.getName());
        code.append("(this.interceptors, methodHash, advisedMethod, unadvisedMethod, advisor); ");
        code.append("   wrapper.arguments = this.arguments; ");
        code.append("   wrapper.metadata = this.metadata; ");
        code.append("   wrapper.currentInterceptor = this.currentInterceptor; ");
        code.append("   wrapper.instanceResolver = this.instanceResolver; ");
        if (!isStatic) {
            code.append("   wrapper.typedTargetObject = this.typedTargetObject; ");
            code.append("   wrapper.targetObject = this.targetObject; ");
        }
        for (int i = 0; i < params.length; ++i) {
            code.append("   wrapper.arg").append(i).append(" = this.arg").append(i).append("; ");
        }
        code.append("   return wrapper; }");
        CtMethod copy = CtNewMethod.make(template.getReturnType(), "copy", template.getParameterTypes(), template.getExceptionTypes(), code.toString(), invocation);
        copy.setModifiers(template.getModifiers());
        invocation.addMethod(copy);
    }
}

