/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AbstractAdvice;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.PerInstanceAdvice;
import org.jboss.aop.advice.PerInstanceInterceptor;
import org.jboss.aop.advice.PerJoinpointAdvice;
import org.jboss.aop.advice.PerJoinpointInterceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.aop.proxy.container.ContainerProxyFactory;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.proxy.container.MarshalledAdvice;
import org.jboss.aop.proxy.container.MarshalledProxyAdvisor;
import org.jboss.aop.proxy.container.SecurityActions;
import org.jboss.aop.util.MethodHashing;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalledContainerProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final GUID GUID = new GUID();
    private transient AspectManaged proxyInstance;
    private String proxyClassName;
    private ContainerProxyCacheKey key;
    private Object[] mixins;
    private Object delegate;
    private Class<?> clazz;
    private SimpleMetaData metadata;
    private String[] introducedInterfaces;
    private Set<String> targetInterfaces = new HashSet<String>();
    MarshalledInterceptors marshalledInterceptors;
    private String instanceAdvisorDomainName;

    public MarshalledContainerProxy(AspectManaged proxyInstance, ContainerProxyCacheKey key, Object[] mixins, Object delegate, Advisor currentAdvisor, SimpleMetaData metadata) {
        this.proxyInstance = proxyInstance;
        Class<?> proxyClass = proxyInstance.getClass();
        this.proxyClassName = proxyClass.getName();
        this.key = key;
        this.mixins = mixins;
        this.delegate = delegate;
        this.clazz = currentAdvisor.getClazz();
        this.checkInstanceAdvisor(currentAdvisor);
        this.metadata = metadata;
        this.marshalledInterceptors = new MarshalledInterceptors(currentAdvisor, mixins);
        Class<?>[] proxyInterfaces = proxyClass.getInterfaces();
        ArrayList<String> ifs = new ArrayList<String>();
        for (int i = 0; i < proxyInterfaces.length; ++i) {
            String name = proxyInterfaces[i].getName();
            if (name.equals(Untransformable.class.getName()) || name.equals(Delegate.class.getName()) || name.equals(AspectManaged.class.getName())) continue;
            if (proxyInterfaces[i].isAssignableFrom(this.clazz)) {
                this.targetInterfaces.add(this.clazz.getName());
                continue;
            }
            ifs.add(proxyInterfaces[i].getName());
        }
        this.introducedInterfaces = ifs.toArray(new String[ifs.size()]);
    }

    private void checkInstanceAdvisor(Advisor advisor) {
        if (advisor instanceof InstanceProxyContainer) {
            AspectManager manager = advisor.getManager();
            this.instanceAdvisorDomainName = manager.getManagerFQN();
        }
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            if (this.isLocal()) {
                return this.localReadResolve();
            }
            return this.remoteReadResolve();
        }
        catch (Exception e) {
            InvalidObjectException ex = new InvalidObjectException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            ex.initCause(e);
            throw ex;
        }
    }

    private Object localReadResolve() throws Exception {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        Class<?> proxyClass = tcl.loadClass(this.proxyClassName);
        Object proxy = proxyClass.newInstance();
        Delegate delegate = (Delegate)proxy;
        delegate.localUnmarshal(this);
        return proxy;
    }

    private Object remoteReadResolve() throws Exception {
        if (this.marshalledInterceptors.getException() != null) {
            throw new Exception("Could not read object, an error happened when writing it on the server", this.marshalledInterceptors.getException());
        }
        MarshalledProxyAdvisor advisor = this.marshalledInterceptors.getMarshalledAdvisor();
        advisor.setClazz(this.clazz);
        boolean objectAsSuper = this.key.getClazz().equals(Object.class);
        Class<?> proxyClass = ContainerProxyFactory.getProxyClass(objectAsSuper, this.key, advisor, this);
        Delegate proxy = (Delegate)proxyClass.newInstance();
        proxy.remoteUnmarshal(this, advisor);
        return proxy;
    }

    private boolean isLocal() {
        return this.key.getGuid().equals(GUID);
    }

    public ContainerProxyCacheKey getKey() {
        return this.key;
    }

    public Object[] getMixins() {
        return this.mixins;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public SimpleMetaData getMetadata() {
        return this.metadata;
    }

    public String getInstanceAdvisorDomainName() {
        return this.instanceAdvisorDomainName;
    }

    protected String[] getIntroducedInterfaces() {
        return this.introducedInterfaces;
    }

    protected Set<String> getTargetInterfaces() {
        return this.targetInterfaces;
    }

    private static class MethodHashingException
    extends IOException {
        private static final long serialVersionUID = 1L;

        MethodHashingException(Exception e) {
            super("Error hashing method");
            super.initCause(e);
        }
    }

    private static class MarshalledMethodInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        transient MarshalledContainerProxy proxy;
        long advisedHash;
        long unadvisedHash;
        Interceptor[] interceptors;
        Class<?> clazz;
        transient boolean requiresInstanceAdvisor;

        public MarshalledMethodInfo(MarshalledContainerProxy proxy, MethodInfo info) throws IOException {
            this.proxy = proxy;
            try {
                this.advisedHash = MethodHashing.methodHash(info.getMethod());
                this.unadvisedHash = MethodHashing.methodHash(info.getUnadvisedMethod());
            }
            catch (Exception e) {
                throw new MethodHashingException(e);
            }
            this.clazz = info.getMethod().getDeclaringClass();
            this.populateInterceptors(info);
        }

        public boolean getRequiresInstanceAdvisor() {
            return this.requiresInstanceAdvisor;
        }

        private void populateInterceptors(MethodInfo info) {
            Interceptor[] icptrs = info.getInterceptors();
            if (icptrs != null) {
                ArrayList<Interceptor> allIcptrs = new ArrayList<Interceptor>(icptrs.length);
                for (int i = 0; i < icptrs.length; ++i) {
                    InstanceAdvisor ia;
                    if (!(icptrs[i] instanceof AbstractAdvice)) {
                        InstanceAdvisor ia2;
                        Interceptor icptr = null;
                        if (icptrs[i] instanceof PerInstanceInterceptor && !Modifier.isStatic(info.getMethod().getModifiers())) {
                            this.requiresInstanceAdvisor = true;
                            ia2 = this.getProxyInstanceAdvisor();
                            icptr = ((PerInstanceInterceptor)icptrs[i]).getAspectInstance(ia2);
                        } else if (icptrs[i] instanceof PerJoinpointInterceptor && !Modifier.isStatic(info.getMethod().getModifiers())) {
                            this.requiresInstanceAdvisor = true;
                            ia2 = this.getProxyInstanceAdvisor();
                            icptr = ((PerJoinpointInterceptor)icptrs[i]).getAspectInstance(ia2);
                        } else {
                            icptr = icptrs[i];
                        }
                        if (icptr == null) continue;
                        allIcptrs.add(icptr);
                        continue;
                    }
                    AbstractAdvice advice = (AbstractAdvice)icptrs[i];
                    Object aspectInstance = null;
                    if (icptrs[i] instanceof PerInstanceAdvice && !Modifier.isStatic(info.getMethod().getModifiers())) {
                        this.requiresInstanceAdvisor = true;
                        ia = this.getProxyInstanceAdvisor();
                        aspectInstance = ((PerInstanceAdvice)advice).getAspectInstance(ia);
                    } else if (icptrs[i] instanceof PerJoinpointAdvice && !Modifier.isStatic(info.getMethod().getModifiers())) {
                        this.requiresInstanceAdvisor = true;
                        ia = this.getProxyInstanceAdvisor();
                        aspectInstance = ((PerJoinpointAdvice)advice).getAspectInstance(ia);
                    } else {
                        aspectInstance = advice.getAspectInstance();
                    }
                    if (aspectInstance == null) continue;
                    MarshalledAdvice ma = new MarshalledAdvice(aspectInstance, icptrs[i].getName(), advice.getAdviceName());
                    allIcptrs.add(ma);
                }
                this.interceptors = allIcptrs.toArray(new Interceptor[allIcptrs.size()]);
            }
        }

        private InstanceAdvisor getProxyInstanceAdvisor() {
            InstanceAdvisor ia = this.proxy.proxyInstance.getInstanceAdvisor();
            this.proxy.checkInstanceAdvisor((InstanceProxyContainer)ia);
            return ia;
        }

        public MethodInfo getMethodInfo(Advisor advisor) {
            MethodInfo info = new MethodInfo(this.clazz, this.advisedHash, this.unadvisedHash, advisor);
            info.setInterceptors(this.interceptors);
            return info;
        }

        public String toString() {
            return this.advisedHash + " " + (this.interceptors == null ? "null" : Arrays.asList(this.interceptors));
        }
    }

    private class MarshalledInterceptors
    implements Serializable {
        private static final long serialVersionUID = 1L;
        transient Advisor currentAdvisor;
        Object[] mixins;
        private Exception exception;

        public MarshalledInterceptors(Advisor currentAdvisor, Object[] mixins) {
            this.currentAdvisor = currentAdvisor;
            this.mixins = mixins;
        }

        public Exception getException() {
            return this.exception;
        }

        public MarshalledProxyAdvisor getMarshalledAdvisor() {
            return (MarshalledProxyAdvisor)this.currentAdvisor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream out) throws IOException {
            ObjectOutputStream test = new ObjectOutputStream(new ByteArrayOutputStream());
            try {
                MethodInfo[] methodInfos = this.getMethodInfos();
                MarshalledMethodInfo[] marshalledInfos = new MarshalledMethodInfo[methodInfos.length];
                for (int i = 0; i < methodInfos.length; ++i) {
                    MarshalledMethodInfo info;
                    marshalledInfos[i] = info = new MarshalledMethodInfo(MarshalledContainerProxy.this, methodInfos[i]);
                    try {
                        test.writeObject(info);
                        continue;
                    }
                    catch (Exception e) {
                        IOException ex = new IOException("An error happened serializing the info for " + this.getExceptionExpression(methodInfos[i]));
                        ex.initCause(e);
                        out.writeObject(ex);
                        try {
                            test.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        return;
                    }
                }
                out.writeObject(marshalledInfos);
            }
            finally {
                try {
                    test.close();
                }
                catch (Exception e) {}
            }
        }

        private MethodInfo[] getMethodInfos() {
            if (this.currentAdvisor instanceof MarshalledProxyAdvisor) {
                return ((MarshalledProxyAdvisor)this.currentAdvisor).getMethodInfos();
            }
            return ((ClassProxyContainer)this.currentAdvisor).getMethodInfos();
        }

        private String getExceptionExpression(MethodInfo info) {
            Method m = info.getMethod();
            StringBuilder expr = new StringBuilder();
            if (m == null) {
                expr.append("a method");
            } else {
                expr.append(m.getDeclaringClass().getName());
                expr.append(".");
                expr.append(m.getName());
                expr.append("(");
                boolean first = true;
                for (Class<?> c : m.getParameterTypes()) {
                    if (first) {
                        first = false;
                    } else {
                        expr.append(", ");
                    }
                    expr.append(c.getName());
                }
                expr.append(")");
            }
            return expr.toString();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Object o = in.readObject();
            if (o instanceof IOException) {
                this.exception = (IOException)o;
                return;
            }
            MarshalledProxyAdvisor advisor = new MarshalledProxyAdvisor("Unmarshalled", AspectManager.getTopLevelAspectManager());
            MarshalledMethodInfo[] marshalledInfos = (MarshalledMethodInfo[])o;
            MethodInfo[] methodInfos = new MethodInfo[marshalledInfos.length];
            for (int i = 0; i < marshalledInfos.length; ++i) {
                methodInfos[i] = marshalledInfos[i].getMethodInfo(advisor);
                advisor.addMethodInfo(methodInfos[i]);
            }
            this.currentAdvisor = advisor;
        }
    }
}

