/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.scope;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.metadata.spi.scope.UnmodifiableScopeKey;
import org.jboss.util.collection.ConcurrentSkipListMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeKey
implements Serializable,
Cloneable {
    private static final ConcurrentSkipListMap<ScopeLevel, Scope> EMPTY_SCOPES = new UnmodifiableConcurrentSkipListMap<ScopeLevel, Scope>();
    private static final long serialVersionUID = -496238095349593370L;
    public static final ScopeKey DEFAULT_SCOPE = new ScopeKey(new Scope(CommonLevels.JVM, "THIS"));
    private volatile ConcurrentSkipListMap<ScopeLevel, Scope> scopes = EMPTY_SCOPES;
    private ScopeLevel maxScopeLevel;
    private volatile boolean frozen;

    public ScopeKey() {
    }

    public ScopeKey(Scope scope) {
        this.addScope(scope);
    }

    public ScopeKey(ScopeLevel level, Object qualifier) {
        this.addScope(level, qualifier);
    }

    public ScopeKey(Collection<Scope> scopes) {
        if (scopes == null) {
            throw new IllegalArgumentException("Null scopes");
        }
        for (Scope scope : scopes) {
            this.addScope(scope);
        }
    }

    public ScopeKey(Scope[] scopes) {
        if (scopes == null) {
            throw new IllegalArgumentException("Null scopes");
        }
        for (Scope scope : scopes) {
            this.addScope(scope);
        }
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        if (this.scopes.isEmpty()) {
            throw new IllegalStateException("Attempt to freeze an empty key");
        }
        this.frozen = true;
    }

    public ScopeKey getOptimizedKey() {
        return new UnmodifiableScopeKey(this);
    }

    public Collection<Scope> getScopes() {
        return Collections.unmodifiableCollection(this.scopes.values());
    }

    public Scope getScope(ScopeLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Null level");
        }
        return this.scopes.get(level);
    }

    public ScopeLevel getMaxScopeLevel() {
        return this.maxScopeLevel;
    }

    public ScopeKey getParent() {
        if (this.scopes.size() < 2) {
            return null;
        }
        ScopeKey result = new ScopeKey();
        Iterator<Scope> i = this.scopes.values().iterator();
        while (i.hasNext()) {
            Scope scope = i.next();
            if (!i.hasNext()) continue;
            result.addScope(scope);
        }
        return result;
    }

    public boolean isParent(ScopeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        Collection<Scope> keyValues = key.getScopesCollection();
        if (keyValues.size() < 2) {
            return false;
        }
        if (this.scopes.size() != keyValues.size() - 1) {
            return false;
        }
        Iterator<Scope> thisScopes = this.scopes.values().iterator();
        Iterator<Scope> keyScopes = keyValues.iterator();
        while (thisScopes.hasNext()) {
            Scope keyScope;
            Scope thisScope = thisScopes.next();
            if (thisScope.equals(keyScope = keyScopes.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scope addScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Null scope");
        }
        if (this.frozen) {
            throw new IllegalStateException("The scope key is frozen");
        }
        if (this.scopes == EMPTY_SCOPES) {
            ScopeKey scopeKey = this;
            synchronized (scopeKey) {
                if (this.scopes == EMPTY_SCOPES) {
                    this.scopes = new ConcurrentSkipListMap();
                }
            }
        }
        ScopeLevel level = scope.getScopeLevel();
        Scope result = this.scopes.put(level, scope);
        if (this.maxScopeLevel == null || level.compareTo(this.maxScopeLevel) >= 0) {
            this.maxScopeLevel = level;
        }
        return result;
    }

    public Scope addScope(ScopeLevel level, Object qualifier) {
        Scope scope = new Scope(level, qualifier);
        return this.addScope(scope);
    }

    public Scope removeScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Null scope");
        }
        return this.removeScopeLevel(scope.getScopeLevel());
    }

    public Scope getScopeLevel(ScopeLevel scopeLevel) {
        if (scopeLevel == null) {
            throw new IllegalArgumentException("Null scope level");
        }
        return this.scopes.get(scopeLevel);
    }

    public Scope removeScopeLevel(ScopeLevel scopeLevel) {
        if (scopeLevel == null) {
            throw new IllegalArgumentException("Null scope level");
        }
        if (this.frozen) {
            throw new IllegalStateException("The scope key is frozen");
        }
        if (this.scopes == EMPTY_SCOPES) {
            return null;
        }
        Scope result = this.scopes.remove(scopeLevel);
        if (scopeLevel.equals(this.maxScopeLevel)) {
            this.maxScopeLevel = null;
            Iterator<ScopeLevel> i$ = this.scopes.keySet().iterator();
            while (i$.hasNext()) {
                ScopeLevel level;
                this.maxScopeLevel = level = i$.next();
            }
        }
        return result;
    }

    public String toString() {
        return this.scopes.values().toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ScopeKey)) {
            return false;
        }
        ScopeKey other = (ScopeKey)object;
        if (other instanceof UnmodifiableScopeKey) {
            return other.equals(this);
        }
        return this.scopes.equals(other.scopes);
    }

    public int hashCode() {
        return ScopeKey.computeHashCode(this.scopes.values());
    }

    public ScopeKey clone() {
        try {
            ScopeKey result = (ScopeKey)super.clone();
            result.scopes = new ConcurrentSkipListMap<ScopeLevel, Scope>((SortedMap<ScopeLevel, Scope>)this.scopes);
            result.frozen = false;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    protected Scope[] getArray() {
        Collection<Scope> scopes = this.getScopes();
        return scopes.toArray(new Scope[0]);
    }

    protected Collection<Scope> getScopesCollection() {
        return this.scopes.values();
    }

    protected static int computeHashCode(Scope[] scopeArray) {
        return ScopeKey.computeHashCode(Arrays.asList(scopeArray));
    }

    protected static int computeHashCode(Iterable<Scope> scopeCollection) {
        int hashCode = 0;
        for (Scope scope : scopeCollection) {
            hashCode += scope.hashCode();
        }
        return hashCode;
    }

    static {
        DEFAULT_SCOPE.freeze();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableConcurrentSkipListMap<K, V>
    extends ConcurrentSkipListMap<K, V> {
        private static final long serialVersionUID = 1L;

        private UnmodifiableConcurrentSkipListMap() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }
    }
}

