/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.bytecode;

import java.lang.reflect.Method;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.util.proxy.RuntimeSupport;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistBehaviorFactory;
import org.jboss.reflect.plugins.javassist.bytecode.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavassistMethodFactory
extends JavassistBehaviorFactory {
    private static final String[] interfaceNames = new String[]{JavassistMethod.class.getName()};
    private static final Method[] methods = new Method[1];
    private final CtMethod ctMethod;
    private final String className = JavassistMethod.class.getName() + counter.incrementAndGet();

    JavassistMethodFactory(Class<?> superClass, CtMethod ctMethod, boolean debug) {
        super(superClass, ctMethod, debug);
        this.ctMethod = ctMethod;
    }

    @Override
    String getGeneratedClassName() {
        return this.className;
    }

    @Override
    String[] getInterfaceNames() {
        return interfaceNames;
    }

    private CtClass getReturnType() {
        try {
            return this.ctMethod.getReturnType();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    MethodInfo implementMethod(int index, ConstPool cp) {
        if (index >= methods.length) {
            return null;
        }
        Method method = methods[index];
        String desc = RuntimeSupport.makeDescriptor(method);
        MethodInfo minfo = new MethodInfo(cp, method.getName(), desc);
        minfo.setAccessFlags(1);
        this.setThrows(minfo, cp, method.getExceptionTypes());
        Bytecode code = new Bytecode(cp, 0, 0);
        int pc = code.currentPc();
        boolean isStatic = Modifier.isStatic(this.ctBehavior.getModifiers());
        if (!isStatic) {
            code.addAload(1);
            code.addCheckcast(this.ctMethod.getDeclaringClass());
        }
        this.addParameters(code, this.getParameterTypes(), 2);
        if (isStatic) {
            code.addInvokestatic(this.ctMethod.getDeclaringClass(), this.ctMethod.getName(), this.ctMethod.getSignature());
        } else if (this.ctMethod.getDeclaringClass().isInterface()) {
            code.addInvokeinterface(this.ctMethod.getDeclaringClass(), this.ctMethod.getName(), this.ctMethod.getSignature(), this.countParameterStackSize(0, this.getParameterTypes()));
        } else {
            code.addInvokevirtual(this.ctMethod.getDeclaringClass(), this.ctMethod.getName(), this.ctMethod.getSignature());
        }
        if (this.getReturnType() == CtClass.voidType) {
            code.addOpcode(1);
            code.addOpcode(176);
        } else {
            this.boxReturnValue(code, this.getReturnType());
            code.addOpcode(176);
        }
        code.setMaxLocals(3);
        CodeAttribute ca = code.toCodeAttribute();
        minfo.setCodeAttribute(ca);
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        writer.sameFrame(pc);
        ca.setAttribute(writer.toStackMapTable(cp));
        return minfo;
    }

    static {
        try {
            JavassistMethodFactory.methods[0] = SecurityActions.getDeclaredMethod(JavassistMethod.class, "invoke", Object.class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

