/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.jdk15.dynamic.common;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Properties;
import org.jboss.aop.AspectManager;
import org.jboss.test.aop.jdk15.dynamic.common.InterceptionsCount;
import org.jboss.test.aop.jdk15.dynamic.common.POJOWrappingInfo;

public class ScenarioLoader {
    private URL[] urls;
    private ClassLoader classLoader;
    private Object scenarioRunner;
    private Class scenarioRunnerClass;
    private Field totalInterceptions;
    private Field fieldReadInterceptions;
    private Field fieldWriteInterceptions;
    private Field constructorInterceptions;
    private Field methodInterceptions;
    private boolean scenarioRunned = false;

    public ScenarioLoader(Properties properties) throws Exception {
        this.urls = new URL[]{new URL("file:" + properties.getProperty("scenario.jar"))};
        System.out.println("URLS " + Arrays.asList(this.urls));
        this.classLoader = new URLClassLoader(this.urls, this.getClass().getClassLoader());
        this.scenarioRunnerClass = this.classLoader.loadClass(this.getClass().getPackage().getName() + ".scenario.ScenarioRunner");
        Class<?> interceptionsCountClass = this.classLoader.loadClass(InterceptionsCount.class.getName());
        this.totalInterceptions = interceptionsCountClass.getField("total");
        this.fieldReadInterceptions = interceptionsCountClass.getField("fieldRead");
        this.fieldWriteInterceptions = interceptionsCountClass.getField("fieldWrite");
        this.constructorInterceptions = interceptionsCountClass.getField("constructor");
        this.methodInterceptions = interceptionsCountClass.getField("method");
        this.scenarioRunner = this.scenarioRunnerClass.newInstance();
    }

    public POJOWrappingInfo[] interceptPerClassLoadBefore() throws Throwable {
        return this.executeScenario("interceptPerClassLoadBefore");
    }

    public POJOWrappingInfo[] interceptPerClassLoadAfter() throws Throwable {
        return this.executeScenario("interceptPerClassLoadAfter");
    }

    public POJOWrappingInfo[] addAndRemoveBindingTwice() throws Throwable {
        return this.executeScenario("addAndRemoveBindingTwice");
    }

    public POJOWrappingInfo[] executeAfterBindingRemoval() throws Throwable {
        return this.executeScenario("executeAfterBindingRemoval");
    }

    public POJOWrappingInfo[] interceptPerInstance() throws Throwable {
        return this.executeScenario("interceptPerInstance");
    }

    public POJOWrappingInfo[] interceptPerInstanceGC() throws Throwable {
        return this.executeScenario("interceptPerInstanceGC");
    }

    public POJOWrappingInfo[] interceptPerClassPerInstance() throws Throwable {
        return this.executeScenario("interceptPerClassPerInstance");
    }

    public POJOWrappingInfo[] interceptPerInstancePerClass() throws Throwable {
        return this.executeScenario("interceptPerInstancePerClass");
    }

    private POJOWrappingInfo[] executeScenario(String scenarioName) throws Throwable {
        if (this.scenarioRunned) {
            throw new RuntimeException("Should not run more than one scenario.");
        }
        Method method = this.scenarioRunnerClass.getMethod(scenarioName, new Class[0]);
        POJOWrappingInfo[] result = null;
        try {
            result = (POJOWrappingInfo[])method.invoke(this.scenarioRunner, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        this.scenarioRunned = true;
        this.removeClassLoaderFromAspectManager();
        return result;
    }

    public void removeClassLoaderFromAspectManager() {
        AspectManager.instance().unregisterClassLoader(this.classLoader);
    }
}

