/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.jdk15annotated;

import java.rmi.MarshalledObject;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.jdk15annotated.AnnotatedAspectFactory;
import org.jboss.test.aop.jdk15annotated.AnotherPOJO;
import org.jboss.test.aop.jdk15annotated.AspectPerClass;
import org.jboss.test.aop.jdk15annotated.AspectPerInstance;
import org.jboss.test.aop.jdk15annotated.AspectPerVM;
import org.jboss.test.aop.jdk15annotated.CFlowAspect;
import org.jboss.test.aop.jdk15annotated.ComparableMixin;
import org.jboss.test.aop.jdk15annotated.CountingInterceptor;
import org.jboss.test.aop.jdk15annotated.EmptyInterface;
import org.jboss.test.aop.jdk15annotated.ExternalizableMixin;
import org.jboss.test.aop.jdk15annotated.Interceptions;
import org.jboss.test.aop.jdk15annotated.IntroducedAnnotationInterceptor;
import org.jboss.test.aop.jdk15annotated.IntroducedAnnotationPOJO;
import org.jboss.test.aop.jdk15annotated.MyAnnotation;
import org.jboss.test.aop.jdk15annotated.NoInterfacesPOJO;
import org.jboss.test.aop.jdk15annotated.NoInterfacesPOJO2;
import org.jboss.test.aop.jdk15annotated.POJO;
import org.jboss.test.aop.jdk15annotated.POJO2;
import org.jboss.test.aop.jdk15annotated.PreparePOJO;
import org.jboss.test.aop.jdk15annotated.PreparedPOJO;
import org.jboss.test.aop.jdk15annotated.SimpleDynamicCFlow;
import org.jboss.test.aop.jdk15annotated.TypedefAspect;
import org.jboss.test.aop.jdk15annotated.VariaPOJO;

public class AnnotatedTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)AnnotatedTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AnnotatedTester");
        suite.addTestSuite(AnnotatedTestCase.class);
        return suite;
    }

    public AnnotatedTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinding() throws Exception {
        System.out.println("***** testBinding() ****");
        AspectPerVM vm = null;
        AspectPerClass perClass = null;
        AspectPerClass perClass2 = null;
        try {
            System.out.println("---- POJO ---");
            POJO pojo = new POJO();
            ++pojo.field;
            pojo.someMethod();
            System.out.println("---- POJO2 ---");
            POJO2 pojo2 = new POJO2();
            ++pojo2.field;
            pojo2.someMethod();
            System.out.println("-- get stats --");
            vm = (AspectPerVM)AspectManager.instance().getPerVMAspect("org.jboss.test.aop.jdk15annotated.AspectPerVM");
            System.out.println("perVM stats: " + vm.constructorCalled + " " + vm.methodCalled + " " + vm.fieldRead + " " + vm.fieldWrite);
            AnnotatedTestCase.assertEquals((int)2, (int)vm.constructorCalled);
            AnnotatedTestCase.assertEquals((int)2, (int)vm.methodCalled);
            AnnotatedTestCase.assertEquals((int)2, (int)vm.fieldRead);
            AnnotatedTestCase.assertEquals((int)2, (int)vm.fieldWrite);
            Advisor advisor = ((Advised)pojo)._getAdvisor();
            perClass = (AspectPerClass)advisor.getPerClassAspect("org.jboss.test.aop.jdk15annotated.AspectPerClass");
            System.out.println("POJO perClass stats: " + perClass.constructorCalled + " " + perClass.methodCalled + " " + perClass.fieldRead + " " + perClass.fieldWrite);
            AnnotatedTestCase.assertEquals((int)1, (int)perClass.constructorCalled);
            AnnotatedTestCase.assertEquals((int)1, (int)perClass.methodCalled);
            AnnotatedTestCase.assertEquals((int)1, (int)perClass.fieldRead);
            AnnotatedTestCase.assertEquals((int)1, (int)perClass.fieldWrite);
            advisor = ((Advised)pojo2)._getAdvisor();
            perClass2 = (AspectPerClass)advisor.getPerClassAspect("org.jboss.test.aop.jdk15annotated.AspectPerClass");
            System.out.println("POJO2 perClass stats: " + perClass.constructorCalled + " " + perClass.methodCalled + " " + perClass.fieldRead + " " + perClass.fieldWrite);
            AnnotatedTestCase.assertEquals((int)1, (int)perClass2.constructorCalled);
            AnnotatedTestCase.assertEquals((int)1, (int)perClass2.methodCalled);
            AnnotatedTestCase.assertEquals((int)1, (int)perClass2.fieldRead);
            AnnotatedTestCase.assertEquals((int)1, (int)perClass2.fieldWrite);
            InstanceAdvisor ia = ((Advised)pojo)._getInstanceAdvisor();
            AspectPerInstance perInstance = (AspectPerInstance)ia.getPerInstanceAspect("org.jboss.test.aop.jdk15annotated.AspectPerInstance");
            System.out.println("pojo perInstance stats: " + perInstance.methodCalled + " " + perInstance.fieldRead + " " + perInstance.fieldWrite);
            AnnotatedTestCase.assertEquals((int)1, (int)perInstance.methodCalled);
            AnnotatedTestCase.assertEquals((int)1, (int)perInstance.fieldRead);
            AnnotatedTestCase.assertEquals((int)1, (int)perInstance.fieldWrite);
            ia = ((Advised)pojo2)._getInstanceAdvisor();
            perInstance = (AspectPerInstance)ia.getPerInstanceAspect("org.jboss.test.aop.jdk15annotated.AspectPerInstance");
            System.out.println("pojo2 perInstance stats: " + perInstance.methodCalled + " " + perInstance.fieldRead + " " + perInstance.fieldWrite);
            AnnotatedTestCase.assertEquals((int)1, (int)perInstance.methodCalled);
            AnnotatedTestCase.assertEquals((int)1, (int)perInstance.fieldRead);
            AnnotatedTestCase.assertEquals((int)1, (int)perInstance.fieldWrite);
        }
        finally {
            if (vm != null) {
                vm.reset();
            }
            if (perClass != null) {
                perClass.reset();
            }
            if (perClass2 != null) {
                perClass2.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompostition() throws Exception {
        AspectPerVM vm = null;
        try {
            System.out.println("***** testCompostition() ****");
            System.out.println("---- AnotherPOJO ---");
            AnotherPOJO apojo = new AnotherPOJO();
            ++apojo.field;
            apojo.someMethod();
            vm = (AspectPerVM)AspectManager.instance().getPerVMAspect("org.jboss.test.aop.jdk15annotated.AspectPerVM");
            AnnotatedTestCase.assertEquals((int)4, (int)vm.anotherPOJOAccess);
        }
        finally {
            if (vm != null) {
                vm.reset();
            }
        }
    }

    public void testMixin() throws Exception {
        System.out.println("***** testMixin() ****");
        ExternalizableMixin.write = false;
        ExternalizableMixin.read = false;
        NoInterfacesPOJO pojo = new NoInterfacesPOJO();
        pojo.stuff = "hello world";
        MarshalledObject<NoInterfacesPOJO> mo = new MarshalledObject<NoInterfacesPOJO>(pojo);
        pojo = mo.get();
        System.out.println("deserialized pojo2.stuff2: " + pojo.stuff);
        AnnotatedTestCase.assertTrue((String)"writeExternal was not called", (boolean)ExternalizableMixin.write);
        AnnotatedTestCase.assertTrue((String)"readExternal was not called", (boolean)ExternalizableMixin.read);
        ExternalizableMixin.write = false;
        ExternalizableMixin.read = false;
        NoInterfacesPOJO2 pojo2 = new NoInterfacesPOJO2();
        pojo2.stuff = "whatever";
        MarshalledObject<NoInterfacesPOJO2> mo2 = new MarshalledObject<NoInterfacesPOJO2>(pojo2);
        pojo2 = mo2.get();
        System.out.println("deserialized pojo2.stuff2: " + pojo2.stuff);
        AnnotatedTestCase.assertTrue((String)"writeExternal was not called for pojo2", (boolean)ExternalizableMixin.write);
        AnnotatedTestCase.assertTrue((String)"readExternal was not called for pojo2", (boolean)ExternalizableMixin.read);
        ComparableMixin.COMPARED = false;
        ((Comparable)((Object)pojo2)).compareTo(null);
        AnnotatedTestCase.assertTrue((String)"mixin method was not called", (boolean)ComparableMixin.COMPARED);
    }

    public void testIntroduction() throws Exception {
        System.out.println("***** testIntroduction() ****");
        NoInterfacesPOJO pojo = new NoInterfacesPOJO();
        try {
            EmptyInterface eif = (EmptyInterface)((Object)pojo);
        }
        catch (Exception e) {
            throw new RuntimeException("pojo does not implement EmptyInterface");
        }
        NoInterfacesPOJO2 pojo2 = new NoInterfacesPOJO2();
        try {
            EmptyInterface eif = (EmptyInterface)((Object)pojo2);
        }
        catch (Exception e) {
            throw new RuntimeException("pojo2 does not implement EmptyInterface");
        }
    }

    public void testInterceptorDef() throws Exception {
        System.out.println("***** testInterceptorDef() ****");
        CountingInterceptor.count = 0;
        VariaPOJO pojo = new VariaPOJO();
        pojo.methodWithInterceptor();
        System.out.println("Count: " + CountingInterceptor.count);
        AnnotatedTestCase.assertEquals((String)"execution of POJO.methodWithInterceptor() was not intercepted", (int)1, (int)CountingInterceptor.count);
        CountingInterceptor.count = 0;
        pojo.methodWithInterceptorFactory();
        System.out.println("Count: " + CountingInterceptor.count);
        AnnotatedTestCase.assertEquals((String)"execution of POJO.methodWithInterceptorFactory() was not intercepted", (int)1, (int)CountingInterceptor.count);
    }

    public void testTypedef() throws Exception {
        System.out.println("***** testTypedef() ****");
        VariaPOJO pojo = new VariaPOJO();
        pojo.methodWithTypedef();
        System.out.println("Intercepted: " + TypedefAspect.intercepted);
        AnnotatedTestCase.assertTrue((String)"execution of POJO.methodWithTypedef() was not intercepted", (boolean)TypedefAspect.intercepted);
    }

    public void testCFlow() throws Exception {
        System.out.println("***** testCFlow() ****");
        CFlowAspect.cflowAccess = 0;
        VariaPOJO pojo = new VariaPOJO();
        pojo.cflowMethod1();
        AnnotatedTestCase.assertEquals((String)"Wrong number of interceptions 1) for cflow Advice", (int)1, (int)CFlowAspect.cflowAccess);
        CFlowAspect.cflowAccess = 0;
        pojo.cflowMethod2();
        System.out.println("ints: " + CFlowAspect.cflowAccess);
        AnnotatedTestCase.assertEquals((String)"Wrong number of interceptions 2) for cflow Advice", (int)1, (int)CFlowAspect.cflowAccess);
    }

    public void testPrepare() throws Exception {
        System.out.println("***** testPrepare() ****");
        PreparePOJO pojo = new PreparePOJO();
        pojo.someMethod();
        Advised advised = (Advised)pojo;
        Advisor advisor = advised._getAdvisor();
    }

    public void testPrepareAtClassLevel() throws Exception {
        System.out.println("***** testPrepareAtClassLevel() ****");
        PreparedPOJO pojo = new PreparedPOJO();
        pojo.someMethod();
        Advised advised = (Advised)pojo;
        Advisor advisor = advised._getAdvisor();
    }

    public void testDynamicCFlow() throws Exception {
        System.out.println("***** testDynamicCFlow() ****");
        CFlowAspect.cflowAccess = 0;
        VariaPOJO pojo = new VariaPOJO();
        pojo.dynamicCFlowMethod();
        AnnotatedTestCase.assertEquals((String)"Wrong number of interceptions for dynamic cflow Advice", (int)0, (int)CFlowAspect.cflowAccess);
        SimpleDynamicCFlow.execute = true;
        pojo.dynamicCFlowMethod();
        AnnotatedTestCase.assertEquals((String)"Wrong number of interceptions for dynamic cflow Advice", (int)1, (int)CFlowAspect.cflowAccess);
        SimpleDynamicCFlow.execute = false;
        pojo.dynamicCFlowMethod();
        AnnotatedTestCase.assertEquals((String)"Wrong number of interceptions for dynamic cflow Advice (2)", (int)1, (int)CFlowAspect.cflowAccess);
    }

    public void testAnnotationIntroduction() throws Exception {
        System.out.println("***** testAnnotationIntroduction() ****");
        IntroducedAnnotationPOJO pojo = new IntroducedAnnotationPOJO();
        AnnotatedTestCase.assertNull((String)"IntroducedAnnotationPOJO should not have had a constructor annotation", (Object)IntroducedAnnotationInterceptor.lastMyAnnotation);
        pojo.annotationIntroductionMethod();
        MyAnnotation annotation = IntroducedAnnotationInterceptor.lastMyAnnotation;
        AnnotatedTestCase.assertNotNull((String)"IntroducedAnnotationPOJO.annotationIntroductionMethod() should have had a method annotation", (Object)annotation);
        AnnotatedTestCase.assertEquals((String)"Wrong value for MyAnnotation.string()", (String)"hello", (String)annotation.string());
        AnnotatedTestCase.assertEquals((String)"Wrong value for MyAnnotation.integer()", (int)5, (int)annotation.integer());
        AnnotatedTestCase.assertEquals((String)"Wrong value for MyAnnotation.bool()", (boolean)true, (boolean)annotation.bool());
        pojo.noAnnotationIntroductionMethod();
        AnnotatedTestCase.assertNull((String)"IntroducedAnnotationPOJO.noAnnotationIntroductionMethod() should not have had a method annotation", (Object)IntroducedAnnotationInterceptor.lastMyAnnotation);
    }

    public void testPrecedence() throws Exception {
        System.out.println("***** testPrecedence() ****");
        VariaPOJO pojo = new VariaPOJO();
        pojo.precedenceMethod();
        ArrayList intercepted = Interceptions.intercepted;
        AnnotatedTestCase.assertEquals((String)"Wrong number of interceptions", (int)4, (int)intercepted.size());
        int precedenceIntercptor1 = intercepted.indexOf("PrecedenceInterceptor1");
        int precedenceAspect_advice1 = intercepted.indexOf("PrecedenceAspect1.advice1");
        int precedenceAspect_advice2 = intercepted.indexOf("PrecedenceAspect1.advice2");
        int precedenceIntercptor2 = intercepted.indexOf("PrecedenceInterceptor2");
        AnnotatedTestCase.assertTrue((String)"PrecedenceInterceptor1 must come before PrecedenceInterceptor2 as defined in Precedence1", (precedenceIntercptor1 < precedenceIntercptor2 ? 1 : 0) != 0);
        AnnotatedTestCase.assertEquals((String)"PrecedenceInterceptor2 must be the last element", (int)3, (int)precedenceIntercptor2);
        AnnotatedTestCase.assertTrue((String)"PrecedenceInterceptor.advice2 must come before PrecedenceInterceptor.advice1 as defined in Precedence2", (precedenceAspect_advice2 < precedenceAspect_advice1 ? 1 : 0) != 0);
        AnnotatedTestCase.assertTrue((String)"PrecedenceInterceptor.advice1 must come before PrecedenceInterceptor.advice1 as defined in Precedence2", (precedenceAspect_advice1 < precedenceIntercptor2 ? 1 : 0) != 0);
    }

    public void testAspectFactory() throws Exception {
        AdviceBinding binding = new AdviceBinding("execution(void *PreparedPOJO->someMethod(..))", null);
        AspectDefinition aspectDefinition = AspectManager.instance().getAspectDefinition(AnnotatedAspectFactory.class.getName());
        AnnotatedTestCase.assertNotNull((Object)aspectDefinition);
        binding.addInterceptorFactory((InterceptorFactory)new AdviceFactory(aspectDefinition, "advice"));
        AspectManager.instance().addBinding(binding);
        PreparedPOJO pojo = new PreparedPOJO();
        pojo.someMethod();
        AnnotatedTestCase.assertTrue((boolean)AnnotatedAspectFactory.isAspectCreated());
        AnnotatedTestCase.assertTrue((boolean)AnnotatedAspectFactory.getAspectCreated().isAdvised());
        AspectManager.instance().removeBinding(binding.getName());
    }
}

