/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.regression.jbaop248annotationoverride;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.regression.jbaop248annotationoverride.Introduced;
import org.jboss.test.aop.regression.jbaop248annotationoverride.Override;
import org.jboss.test.aop.regression.jbaop248annotationoverride.POJO;
import org.jboss.test.aop.regression.jbaop248annotationoverride.TestInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationOverrideTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)AnnotationOverrideTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AnnotationOverrideTestCase");
        suite.addTestSuite(AnnotationOverrideTestCase.class);
        return suite;
    }

    public AnnotationOverrideTestCase(String name) {
        super(name);
    }

    public void testAnnotationOverrides() throws Exception {
        this.checkAnnotations(Override.class);
    }

    public void testAnnotationIntroductions() throws Exception {
        this.checkAnnotations(Introduced.class);
    }

    private void checkAnnotations(Class<?> annotation) throws Exception {
        TestInterceptor.annotation = annotation;
        TestInterceptor.reset();
        POJO pojo = new POJO();
        this.checkValue(TestInterceptor.classAnnotation, TestInterceptor.annotation, 1);
        this.checkValue(TestInterceptor.joinpointAnnotation, TestInterceptor.annotation, 10);
        TestInterceptor.reset();
        pojo.field = 6;
        this.checkValue(TestInterceptor.classAnnotation, TestInterceptor.annotation, 1);
        this.checkValue(TestInterceptor.joinpointAnnotation, TestInterceptor.annotation, 20);
        TestInterceptor.reset();
        AnnotationOverrideTestCase.assertEquals((int)6, (int)pojo.field);
        this.checkValue(TestInterceptor.classAnnotation, TestInterceptor.annotation, 1);
        this.checkValue(TestInterceptor.joinpointAnnotation, TestInterceptor.annotation, 20);
        TestInterceptor.reset();
        pojo.method();
        this.checkValue(TestInterceptor.classAnnotation, TestInterceptor.annotation, 1);
        this.checkValue(TestInterceptor.joinpointAnnotation, TestInterceptor.annotation, 30);
        TestInterceptor.reset();
        pojo.notAnnotatedMethod();
        this.checkValue(TestInterceptor.classAnnotation, TestInterceptor.annotation, 1);
        AnnotationOverrideTestCase.assertNull((Object)TestInterceptor.joinpointAnnotation);
    }

    private void checkValue(Object annotation, Class<?> expectedClass, int expectedValue) throws Exception {
        AnnotationOverrideTestCase.assertNotNull((Object)annotation);
        AnnotationOverrideTestCase.assertTrue((boolean)expectedClass.isAssignableFrom(annotation.getClass()));
        if (expectedClass.equals(Override.class)) {
            AnnotationOverrideTestCase.assertEquals((int)expectedValue, (int)((Override)annotation).value());
        } else if (expectedClass.equals(Introduced.class)) {
            AnnotationOverrideTestCase.assertEquals((int)expectedValue, (int)((Introduced)annotation).value());
        } else {
            AnnotationOverrideTestCase.fail((String)"Should not happen");
        }
    }
}

