/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.annotation.factory.javassist;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.annotation.factory.javassist.AnnotationProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyMapCreator
implements MemberValueVisitor {
    public Object value;
    private Class<?> type;

    public ProxyMapCreator(Class<?> type) {
        this.type = type;
    }

    @Override
    public void visitAnnotationMemberValue(AnnotationMemberValue annotationMemberValue) {
        try {
            this.value = AnnotationProxy.createProxy(annotationMemberValue.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visitArrayMemberValue(ArrayMemberValue arrayMemberValue) {
        Class<?> baseType = this.type.getComponentType();
        int size = 0;
        if (arrayMemberValue.getValue() != null) {
            size = arrayMemberValue.getValue().length;
        }
        this.value = Array.newInstance(baseType, size);
        MemberValue[] elements = arrayMemberValue.getValue();
        for (int i = 0; i < size; ++i) {
            ProxyMapCreator creator = new ProxyMapCreator(baseType);
            elements[i].accept(creator);
            Array.set(this.value, i, creator.value);
        }
    }

    @Override
    public void visitBooleanMemberValue(BooleanMemberValue booleanMemberValue) {
        this.value = new Boolean(booleanMemberValue.getValue());
    }

    @Override
    public void visitByteMemberValue(ByteMemberValue byteMemberValue) {
        this.value = new Byte(byteMemberValue.getValue());
    }

    @Override
    public void visitCharMemberValue(CharMemberValue charMemberValue) {
        this.value = new Character(charMemberValue.getValue());
    }

    @Override
    public void visitDoubleMemberValue(DoubleMemberValue doubleMemberValue) {
        this.value = new Double(doubleMemberValue.getValue());
    }

    @Override
    public void visitEnumMemberValue(EnumMemberValue enumMemberValue) {
        try {
            Field enumVal = this.type.getField(enumMemberValue.getValue());
            this.value = enumVal.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visitFloatMemberValue(FloatMemberValue floatMemberValue) {
        this.value = new Float(floatMemberValue.getValue());
    }

    @Override
    public void visitIntegerMemberValue(IntegerMemberValue integerMemberValue) {
        this.value = new Integer(integerMemberValue.getValue());
    }

    @Override
    public void visitLongMemberValue(LongMemberValue longMemberValue) {
        this.value = new Long(longMemberValue.getValue());
    }

    @Override
    public void visitShortMemberValue(ShortMemberValue shortMemberValue) {
        this.value = new Short(shortMemberValue.getValue());
    }

    @Override
    public void visitStringMemberValue(StringMemberValue stringMemberValue) {
        this.value = stringMemberValue.getValue();
    }

    @Override
    public void visitClassMemberValue(ClassMemberValue classMemberValue) {
        try {
            String classname = classMemberValue.getValue();
            if (classname.equals("void")) {
                this.value = Void.TYPE;
            } else if (classname.equals("int")) {
                this.value = Integer.TYPE;
            } else if (classname.equals("byte")) {
                this.value = Byte.TYPE;
            } else if (classname.equals("long")) {
                this.value = Long.TYPE;
            } else if (classname.equals("double")) {
                this.value = Double.TYPE;
            } else if (classname.equals("float")) {
                this.value = Float.TYPE;
            } else if (classname.equals("char")) {
                this.value = Character.TYPE;
            } else if (classname.equals("short")) {
                this.value = Short.TYPE;
            } else if (classname.equals("boolean")) {
                this.value = Boolean.TYPE;
            } else {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                this.value = Class.forName(classMemberValue.getValue(), false, loader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getMemberType(Class<?> annotation, String member) {
        Method[] methods = annotation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(member)) continue;
            return methods[i].getReturnType();
        }
        throw new RuntimeException("unable to determine member type for annotation: " + annotation.getName() + "." + member);
    }

    public static Map<String, Object> createProxyMap(Class<?> annotation, Annotation info) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (info.getMemberNames() == null) {
            return map;
        }
        Set members = info.getMemberNames();
        for (String name : members) {
            MemberValue mv = info.getMemberValue(name);
            ProxyMapCreator creator = new ProxyMapCreator(ProxyMapCreator.getMemberType(annotation, name));
            mv.accept(creator);
            map.put(name, creator.value);
        }
        return map;
    }
}

