/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AdvisorFactory;
import org.jboss.aop.AspectNotificationHandler;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassLoaderValidation;
import org.jboss.aop.ClassicWeavingStrategy;
import org.jboss.aop.Deployment;
import org.jboss.aop.Domain;
import org.jboss.aop.DomainDefinition;
import org.jboss.aop.DynamicAOPStrategy;
import org.jboss.aop.InterceptionMarkers;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.LoadInterceptedClassesStrategy;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.SuperClassesFirstWeavingStrategy;
import org.jboss.aop.WeavingStrategy;
import org.jboss.aop.WeavingStrategySupport;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactoryWithClassLoader;
import org.jboss.aop.advice.ClassifiedBindingAndPointcutCollection;
import org.jboss.aop.advice.DynamicCFlowDefinition;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PrecedenceDef;
import org.jboss.aop.advice.PrecedenceDefEntry;
import org.jboss.aop.advice.PrecedenceSorter;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.array.ArrayAdvisor;
import org.jboss.aop.array.ArrayBinding;
import org.jboss.aop.array.ArrayReplacement;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.classpool.ClassLoaderRepository;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.metadata.SimpleClassMetaDataLoader;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
import org.jboss.aop.microcontainer.lifecycle.LifecycleManager;
import org.jboss.aop.pointcut.CFlowStack;
import org.jboss.aop.pointcut.DeclareDef;
import org.jboss.aop.pointcut.DynamicCFlow;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutInfo;
import org.jboss.aop.pointcut.PointcutStats;
import org.jboss.aop.pointcut.Typedef;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.util.AOPLock;
import org.jboss.aop.util.UnmodifiableEmptyCollections;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolFactory;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.classpool.spi.ClassPoolRepositoryCallback;
import org.jboss.logging.Logger;
import org.jboss.util.collection.WeakValueHashMap;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectManager
implements Translator {
    private static final Logger logger = Logger.getLogger(AspectManager.class);
    private static final Object NULL_ASPECT = new Object();
    Object lazyCollectionLock = new Object();
    protected final WeakHashMap<Class<?>, WeakReference<Advisor>> advisors = new WeakHashMap();
    protected volatile WeakHashMap<Class<?>, WeakReference<Domain>> subDomainsPerClass = UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP;
    protected volatile WeakValueHashMap<String, Domain> subDomainsByName = UnmodifiableEmptyCollections.EMPTY_WEAK_VALUE_HASHMAP;
    protected volatile WeakHashMap<Domain, Object> subscribedSubDomains = UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP;
    protected volatile WeakHashMap<Domain, Object> subscribedSubDomainsQueue = UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP;
    protected int subscribedDomainQueueRef;
    protected volatile LinkedHashMap<String, InterfaceIntroduction> interfaceIntroductions = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    protected volatile LinkedHashMap<String, ArrayReplacement> arrayReplacements = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    protected volatile LinkedHashMap<String, ArrayBinding> arrayBindings = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    protected volatile LinkedHashMap<String, AnnotationIntroduction> annotationIntroductions = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    protected volatile LinkedHashMap<String, AnnotationIntroduction> annotationOverrides = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    @Deprecated
    protected volatile LinkedHashMap<String, AdviceBinding> bindings = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    protected final ClassifiedBindingAndPointcutCollection bindingCollection;
    protected volatile LinkedHashMap<String, Typedef> typedefs = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    protected volatile HashMap<String, InterceptorFactory> interceptorFactories = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
    protected volatile HashMap<String, ClassMetaDataLoader> classMetaDataLoaders = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
    protected volatile HashMap<String, AdviceStack> interceptorStacks = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
    protected volatile HashMap<String, DeclareDef> declares = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
    protected volatile ConcurrentHashMap<String, CFlowStack> cflowStacks = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    protected volatile ConcurrentHashMap<String, DynamicCFlowDefinition> dynamicCFlows = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    protected volatile ConcurrentHashMap<String, AspectDefinition> aspectDefinitions = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    protected volatile ConcurrentHashMap<String, Object> perVMAspects = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    protected volatile ArrayList<String> exclude = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    protected volatile ArrayList<String> include = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    protected volatile ArrayList<String> ignore = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    protected List<String> includeInvisibleAnnotations = Collections.emptyList();
    protected ClassExpression[] ignoreExpressions = new ClassExpression[0];
    protected static AOPLock lock = new AOPLock();
    protected volatile LinkedHashMap<String, ClassMetaDataBinding> classMetaData = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    protected volatile HashMap<String, DomainDefinition> containers = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
    protected volatile LinkedHashMap<String, PrecedenceDef> precedenceDefs = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    protected PrecedenceDefEntry[] sortedPrecedenceDefEntries;
    protected WeavingStrategy weavingStrategy;
    protected DynamicAOPStrategy dynamicStrategy = new LoadInterceptedClassesStrategy();
    private static AOPClassLoaderScopingPolicy classLoaderScopingPolicy;
    protected static Map<ClassLoader, InterceptionMarkers> interceptionMarkers;
    private static final ClassLoader NULL_CLASSLOADER;
    protected static AspectManager manager;
    public static boolean optimize;
    public static boolean debugClasses;
    public static ClassLoaderValidation classLoaderValidator;
    public LifecycleManager lifecycleManager = new LifecycleManager(this);
    public static boolean verbose;
    public static boolean maintainAdvisorMethodInterceptors;
    public static AspectNotificationHandler notificationHandler;
    public static boolean suppressTransformationErrors;
    public static boolean suppressReferenceErrors;

    public static synchronized AspectManager getTopLevelAspectManager() {
        if (classLoaderScopingPolicy == null) {
            return AspectManager.instance();
        }
        AspectManager result = AspectManager.initManager();
        Domain scopedDomain = classLoaderScopingPolicy.getTopLevelDomain(result);
        if (scopedDomain != null) {
            result = scopedDomain;
        }
        return result;
    }

    public static synchronized AspectManager instance() {
        return AspectManager.instance(SecurityActions.getContextClassLoader());
    }

    public static synchronized AspectManager instance(Class<?> wovenClass) {
        ClassLoader classLoader = SecurityActions.getClassLoader(wovenClass);
        return AspectManager.instance(classLoader);
    }

    public static synchronized AspectManager instance(ClassLoader loadingClassLoader) {
        Domain scopedDomain;
        AspectManager result = AspectManager.initManager();
        if (classLoaderScopingPolicy != null && (scopedDomain = classLoaderScopingPolicy.getDomain(loadingClassLoader, result)) != null) {
            result = scopedDomain;
        }
        return result;
    }

    private static AspectManager initManager() {
        if (manager == null) {
            AccessController.doPrivileged(new PrivilegedAction<AspectManager>(){

                @Override
                public AspectManager run() {
                    String methodInterceptors;
                    String invisibleAnnotations;
                    String ignore;
                    String include;
                    String exclude;
                    String pruneit;
                    String optimized = System.getProperty("jboss.aop.optimized", null);
                    if (optimized != null) {
                        optimize = new Boolean(optimized);
                    }
                    if ((pruneit = System.getProperty("jboss.aop.prune", null)) != null) {
                        ClassPoolRepository.getInstance().setPrune(Boolean.valueOf(pruneit).booleanValue());
                    }
                    manager = new AspectManager();
                    AspectManager.manager.subDomainsPerClass = new WeakHashMap();
                    AspectManager.manager.exclude = new ArrayList();
                    AspectManager.manager.include = new ArrayList();
                    AspectManager.manager.ignore = new ArrayList();
                    AspectManager.manager.includeInvisibleAnnotations = new ArrayList<String>();
                    ClassLoaderRepository classLoaderRepository = ClassLoaderRepository.getInstance();
                    ClassPoolRepository classPoolRepository = ClassPoolRepository.getInstance();
                    classLoaderRepository.setAspectManager(manager);
                    classPoolRepository.addClassPoolRepositoryCallback((ClassPoolRepositoryCallback)classLoaderRepository);
                    if (!verbose) {
                        verbose = new Boolean(System.getProperty("jboss.aop.verbose", "false"));
                    }
                    if ((exclude = System.getProperty("jboss.aop.exclude", null)) != null) {
                        ArrayList list = AspectManager.splitString(exclude, ",");
                        manager.setExclude(list);
                    }
                    if ((include = System.getProperty("jboss.aop.include", null)) != null) {
                        ArrayList list = AspectManager.splitString(include, ",");
                        manager.setInclude(list);
                    }
                    if ((ignore = System.getProperty("jboss.aop.ignore", null)) != null) {
                        ArrayList list = AspectManager.splitString(ignore, ",");
                        manager.setIgnore(list);
                    }
                    if ((invisibleAnnotations = System.getProperty("jboss.aop.invisible.annotations", null)) != null) {
                        ArrayList list = AspectManager.splitString(invisibleAnnotations, ",");
                        manager.setIncludedInvisibleAnnotations(list);
                    }
                    String instrument = System.getProperty("jboss.aop.instrumentor", null);
                    InstrumentorFactory.initialise(instrument);
                    String advisorName = System.getProperty("jboss.aop.advisor", null);
                    AdvisorFactory.initialise(advisorName);
                    String debugClass = System.getProperty("jboss.aop.debug.classes", null);
                    if (debugClass != null) {
                        debugClasses = new Boolean(debugClass);
                    }
                    if ((methodInterceptors = System.getProperty("jboss.aop.advisor.methodInterceptors", null)) != null) {
                        maintainAdvisorMethodInterceptors = new Boolean(methodInterceptors);
                    }
                    Deployment.deploy();
                    return null;
                }
            });
        }
        return manager;
    }

    private static ArrayList<String> splitString(String string, String delim) {
        if (string != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String token : string.split(delim)) {
                list.add(token.trim());
            }
            return list;
        }
        return null;
    }

    public static AOPClassLoaderScopingPolicy getClassLoaderScopingPolicy() {
        return classLoaderScopingPolicy;
    }

    public static void setClassLoaderScopingPolicy(AOPClassLoaderScopingPolicy classLoaderScopingPolicy) {
        AspectManager.classLoaderScopingPolicy = classLoaderScopingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptionMarkers getInterceptionMarkers(ClassLoader loader) {
        if (loader == null) {
            loader = NULL_CLASSLOADER;
        }
        Map<ClassLoader, InterceptionMarkers> map = interceptionMarkers;
        synchronized (map) {
            InterceptionMarkers markers = interceptionMarkers.get(loader);
            if (markers == null) {
                markers = new InterceptionMarkers();
                interceptionMarkers.put(loader, markers);
            }
            return markers;
        }
    }

    public LinkedHashMap<String, Pointcut> getPointcuts() {
        return this.bindingCollection.getPointcuts();
    }

    public LinkedHashMap<String, PointcutInfo> getPointcutInfos() {
        return this.bindingCollection.getPointcutInfos();
    }

    public CFlowStack getCFlowStack(String name) {
        return this.cflowStacks.get(name);
    }

    public void addCFlowStack(CFlowStack stack) {
        this.initCflowStacksMap();
        this.cflowStacks.put(stack.getName(), stack);
    }

    public void removeCFlowStack(String name) {
        this.cflowStacks.remove(name);
    }

    @Deprecated
    public DynamicCFlow getDynamicCFlow(String name) {
        return this.getDynamicCFlow(name, SecurityActions.getContextClassLoader());
    }

    public DynamicCFlow getDynamicCFlow(String name, ClassLoader cl) {
        DynamicCFlowDefinition def = this.dynamicCFlows.get(name);
        if (def != null) {
            return def.create(cl);
        }
        return null;
    }

    public void addDynamicCFlow(String name, DynamicCFlowDefinition cflow) {
        this.initDynamicCflowsMap();
        this.dynamicCFlows.put(name, cflow);
    }

    public void removeDynamicCFlow(String name) {
        this.dynamicCFlows.remove(name);
    }

    public AspectManager() {
        this.bindingCollection = this.createBindingCollection();
    }

    protected ClassifiedBindingAndPointcutCollection createBindingCollection() {
        return new ClassifiedBindingAndPointcutCollection();
    }

    public ClassMetaDataLoader findClassMetaDataLoader(String group) {
        ClassMetaDataLoader loader = this.classMetaDataLoaders.get(group);
        if (loader == null) {
            loader = SimpleClassMetaDataLoader.singleton;
        }
        return loader;
    }

    public void addClassMetaDataLoader(String group, ClassMetaDataLoader loader) {
        this.initClassMetaDataLoadersMap();
        this.classMetaDataLoaders.put(group, loader);
    }

    public void removeClassMetaDataLoader(String group) {
        this.classMetaDataLoaders.remove(group);
    }

    public Map<Class<?>, WeakReference<Advisor>> getAdvisors() {
        WeakHashMap tmpAdvisors = new WeakHashMap(this.advisors);
        Map<Class<?>, WeakReference<Domain>> domainsMap = this.getSubDomainsPerClass();
        if (domainsMap.size() > 0) {
            Set<Class<?>> keys = domainsMap.keySet();
            for (Class<?> clazz : keys) {
                Domain subDomain;
                WeakReference<Domain> ref = domainsMap.get(clazz);
                if (ref == null || (subDomain = (Domain)ref.get()) == null) continue;
                WeakReference advisorRef = (WeakReference)subDomain.advisors.get(clazz);
                tmpAdvisors.put(clazz, advisorRef);
            }
        }
        return tmpAdvisors;
    }

    public Advisor getAdvisor(String name) {
        throw new RuntimeException("OPERATION NOT SUPPORTED ANYMORE");
    }

    public LinkedHashMap<String, AdviceBinding> getBindings() {
        return this.bindingCollection.getBindings();
    }

    public ClassifiedBindingAndPointcutCollection getBindingCollection() {
        return this.bindingCollection;
    }

    protected Map<Class<?>, WeakReference<Domain>> getSubDomainsPerClass() {
        return this.subDomainsPerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Advisor findAdvisor(Class<?> clazz) {
        if (this.getSubDomainsPerClass().size() > 0) {
            Advisor advisor;
            Domain subDomain = null;
            Map<Class<?>, WeakReference<Domain>> map = this.getSubDomainsPerClass();
            synchronized (map) {
                WeakReference<Domain> ref = this.getSubDomainsPerClass().get(clazz);
                if (ref != null) {
                    subDomain = (Domain)ref.get();
                }
            }
            if (subDomain != null && subDomain != this && (advisor = subDomain.findAdvisor(clazz)) != null) {
                return advisor;
            }
        }
        WeakHashMap<Class<?>, WeakReference<Advisor>> weakHashMap = this.advisors;
        synchronized (weakHashMap) {
            WeakReference<Advisor> ref = this.advisors.get(clazz);
            if (ref == null) {
                return null;
            }
            return (Advisor)ref.get();
        }
    }

    public AspectManager findManagerByName(String fqn) {
        String[] nameparts = fqn.split("/");
        return this.findManagerByName(nameparts);
    }

    private AspectManager findManagerByName(String[] nameparts) {
        AspectManager found = this;
        for (int i = 0; i < nameparts.length && (nameparts[i].trim().length() == 0 || (found = found.findManagerByNameInternal(nameparts[i])) != null); ++i) {
        }
        return found;
    }

    private AspectManager findManagerByNameInternal(String name) {
        return (AspectManager)this.subDomainsByName.get(name);
    }

    protected void addSubDomainByName(Domain domain) {
        this.initSubDomainsByNameMap();
        this.subDomainsByName.put(domain.getDomainName(), domain);
    }

    public String getManagerFQN() {
        return "/";
    }

    public ClassAdvisor getAdvisorIfAdvised(Class<?> clazz) {
        return (ClassAdvisor)this.getAnyAdvisorIfAdvised(clazz);
    }

    public Advisor getAnyAdvisorIfAdvised(Class<?> clazz) {
        try {
            Advisor advisor = this.findAdvisor(clazz);
            if (advisor == null) {
                return null;
            }
            if (advisor.getClazz() == null && advisor instanceof ClassAdvisor) {
                ((ClassAdvisor)advisor).attachClass(clazz);
                if (notificationHandler != null) {
                    notificationHandler.attachClass(clazz.getName());
                }
            }
            return advisor;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public synchronized ClassAdvisor getAdvisor(Class<?> clazz) {
        ClassAdvisor advisor = null;
        advisor = (ClassAdvisor)this.findAdvisor(clazz);
        if (advisor == null) {
            advisor = AdvisorFactory.getClassAdvisor(clazz, this);
            this.initialiseClassAdvisor(clazz, advisor);
        }
        return advisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseClassAdvisor(Class<?> clazz, ClassAdvisor advisor) {
        lock.lockRead();
        try {
            WeakHashMap<Class<?>, WeakReference<Advisor>> weakHashMap = this.advisors;
            synchronized (weakHashMap) {
                this.advisors.put(clazz, new WeakReference<ClassAdvisor>(advisor));
                this.registerClass(clazz);
                advisor.attachClass(clazz);
                InterceptorChainObserver observer = this.dynamicStrategy.getInterceptorChainObserver(clazz);
                advisor.setInterceptorChainObserver(observer);
                if (notificationHandler != null) {
                    notificationHandler.attachClass(clazz.getName());
                }
            }
        }
        finally {
            lock.unlockRead();
        }
    }

    public static Map<ClassLoader, ScopedClassPool> getRegisteredCLs() {
        return ClassPoolRepository.getInstance().getRegisteredCLs();
    }

    public static void clearUnregisteredClassLoaders() {
        ClassPoolRepository.getInstance().clearUnregisteredClassLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdvisorRegistered(Advisor advisor) {
        Map<ClassLoader, ScopedClassPool> map = AspectManager.getRegisteredCLs();
        synchronized (map) {
            if (!this.advisors.containsKey(advisor.getClazz())) {
                return false;
            }
            if (classLoaderValidator != null) {
                if (classLoaderValidator.isValidClassLoader(advisor.getClassLoader())) {
                    return true;
                }
                this.unregisterClassLoader(advisor.getClassLoader());
                return false;
            }
            ScopedClassPool pool = (ScopedClassPool)this.getRegisteredClassPool(advisor.getClassLoader());
            if (pool == null) {
                return false;
            }
            if (pool.isUnloadedClassLoader()) {
                this.unregisterClassLoader(advisor.getClassLoader());
                return false;
            }
            return true;
        }
    }

    public ClassPool findClassPool(ClassLoader cl) {
        if (cl == null) {
            return this.registerClassLoader(SecurityActions.getContextClassLoader());
        }
        return this.registerClassLoader(cl);
    }

    public ClassPool findClassPool(Class<?> clazz) {
        return this.findClassPool(SecurityActions.getClassLoader(clazz));
    }

    protected ClassPool getRegisteredClassPool(ClassLoader cl) {
        return (ClassPool)AspectManager.getRegisteredCLs().get(cl);
    }

    public ClassPool registerClassLoader(ClassLoader ucl) {
        return ClassPoolRepository.getInstance().registerClassLoader(ucl);
    }

    protected void registerClass(Class<?> clazz) {
        ClassLoaderRepository.getInstance().registerClass(clazz);
    }

    @Override
    public void unregisterClassLoader(ClassLoader cl) {
        ClassPoolRepository.getInstance().unregisterClassLoader(cl);
    }

    public ArrayList<String> getExclude() {
        return this.exclude;
    }

    public void setExclude(ArrayList<String> exclude) {
        this.exclude.clear();
        this.exclude.addAll(exclude);
    }

    public ArrayList<String> getInclude() {
        return this.include;
    }

    public void setInclude(ArrayList<String> include) {
        this.include.clear();
        this.include.addAll(include);
    }

    public ArrayList<String> getIgnore() {
        return this.ignore;
    }

    public List<String> getIncludedInvisibleAnnotations() {
        return this.includeInvisibleAnnotations;
    }

    public void setIncludedInvisibleAnnotations(List<String> ia) {
        this.includeInvisibleAnnotations.clear();
        this.includeInvisibleAnnotations.addAll(ia);
    }

    public ClassExpression[] getIgnoreExpressions() {
        return this.ignoreExpressions;
    }

    public void setIgnore(ArrayList<String> ignore) {
        this.ignore.clear();
        this.ignore.addAll(ignore);
        this.ignoreExpressions = new ClassExpression[ignore.size()];
        for (int i = 0; i < ignore.size(); ++i) {
            String ex = ignore.get(i);
            this.ignoreExpressions[i] = new ClassExpression(ex);
        }
    }

    public boolean ignoreClass(String classname) {
        ArrayList<String> ignore = this.getIgnore();
        if (ignore == null) {
            return false;
        }
        ClassExpression[] ignoreExprs = this.getIgnoreExpressions();
        for (int i = 0; i < ignoreExprs.length; ++i) {
            if (!ignoreExprs[i].matches(classname)) continue;
            return true;
        }
        return false;
    }

    public boolean includeClass(String classname) {
        ArrayList<String> include = this.getInclude();
        if (include == null) {
            return false;
        }
        for (int i = 0; i < include.size(); ++i) {
            String str = include.get(i);
            if (!classname.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    public boolean excludeClass(String classname) {
        ArrayList<String> exclude = this.getExclude();
        if (exclude == null) {
            return false;
        }
        for (int i = 0; i < exclude.size(); ++i) {
            String str = exclude.get(i);
            if (str.equals("*")) {
                return true;
            }
            if (!classname.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean getPrune() {
        return ClassPoolRepository.getInstance().isPrune();
    }

    public static void setPrune(boolean prune) {
        ClassPoolRepository.getInstance().setPrune(prune);
    }

    public static void setClassPoolFactory(ScopedClassPoolFactory factory) {
        ClassPoolRepository.getInstance().setClassPoolFactory(factory);
    }

    public static ScopedClassPoolFactory getClassPoolFactory() {
        return ClassPoolRepository.getInstance().getClassPoolFactory();
    }

    public boolean isNonAdvisableClassName(String classname) {
        if (this.ignoreClass(classname)) {
            return true;
        }
        if (this.includeClass(classname)) {
            return false;
        }
        if (this.excludeClass(classname)) {
            return true;
        }
        return classname.startsWith("org.jboss.aop.") || classname.endsWith("$aop") || classname.startsWith("javassist") || classname.startsWith("org.jboss.util.") || classname.startsWith("gnu.trove.") || classname.startsWith("EDU.oswego.cs.dl.util.concurrent.") || classname.contains(".JoinPoint_") || classname.startsWith("org.apache.tools.ant") || classname.startsWith("org.apache.crimson") || classname.startsWith("org.apache.xalan") || classname.startsWith("org.apache.xml") || classname.startsWith("org.apache.xpath") || classname.startsWith("org.ietf.") || classname.startsWith("org.omg.") || classname.startsWith("org.w3c.") || classname.startsWith("org.xml.sax.") || classname.startsWith("sunw.") || classname.startsWith("sun.") || classname.startsWith("java.") || classname.startsWith("javax.") || classname.startsWith("com.sun.") || classname.startsWith("junit") || classname.startsWith("jrockit.") || classname.startsWith("com.bea.vm.") || classname.startsWith("$Proxy");
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws Exception {
        byte[] b = this.translate(className, loader, classfileBuffer);
        return b;
    }

    public byte[] translate(String className, ClassLoader loader) throws Exception {
        return this.translate(className, loader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] translate(String className, ClassLoader loader, byte[] classfileBuffer) throws Exception {
        if (this.isNonAdvisableClassName(className)) {
            return null;
        }
        lock.lockRead();
        try {
            if (this.weavingStrategy == null) {
                this.weavingStrategy = TransformerCommon.isCompileTime() ? new ClassicWeavingStrategy() : (InstrumentorFactory.getInstrumentor(this, this.dynamicStrategy.getJoinpointClassifier()) instanceof GeneratedAdvisorInstrumentor ? new SuperClassesFirstWeavingStrategy() : new ClassicWeavingStrategy());
            }
            byte[] byArray = this.weavingStrategy.translate(this, className, loader, classfileBuffer);
            lock.unlockRead();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                lock.unlockRead();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterceptorFactory(String name, InterceptorFactory factory) {
        this.initInterceptorFactoriesMap();
        HashMap<String, InterceptorFactory> hashMap = this.interceptorFactories;
        synchronized (hashMap) {
            this.interceptorFactories.put(name, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterceptorFactory(String name) {
        HashMap<String, InterceptorFactory> hashMap = this.interceptorFactories;
        synchronized (hashMap) {
            this.interceptorFactories.remove(name);
        }
    }

    public Map<String, InterceptorFactory> getInterceptorFactories() {
        return this.interceptorFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptorFactory getInterceptorFactory(String name) {
        HashMap<String, InterceptorFactory> hashMap = this.interceptorFactories;
        synchronized (hashMap) {
            return this.interceptorFactories.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrecedence(PrecedenceDef precedenceDef) {
        this.initPrecedenceDefsMap();
        LinkedHashMap<String, PrecedenceDef> linkedHashMap = this.precedenceDefs;
        synchronized (linkedHashMap) {
            this.precedenceDefs.put(precedenceDef.getName(), precedenceDef);
        }
        this.forceResortPrecedenceDefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrecedence(String name) {
        LinkedHashMap<String, PrecedenceDef> linkedHashMap = this.precedenceDefs;
        synchronized (linkedHashMap) {
            this.precedenceDefs.remove(name);
        }
        this.forceResortPrecedenceDefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceResortPrecedenceDefs() {
        AbstractMap abstractMap = this.precedenceDefs;
        synchronized (abstractMap) {
            this.sortedPrecedenceDefEntries = null;
        }
        abstractMap = this.subscribedSubDomains;
        synchronized (abstractMap) {
            this.copySubDomainsFromQueue(true);
            boolean newSubscribers = true;
            while (newSubscribers) {
                for (Domain domain : this.subscribedSubDomains.keySet()) {
                    domain.forceResortPrecedenceDefs();
                }
                newSubscribers = this.copySubDomainsFromQueue(false);
            }
        }
    }

    public LinkedHashMap<String, PrecedenceDef> getPrecedenceDefs() {
        return this.precedenceDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrecedenceDefEntry[] getSortedPrecedenceDefEntries() {
        if (this.sortedPrecedenceDefEntries == null) {
            LinkedHashMap<String, PrecedenceDef> linkedHashMap = this.precedenceDefs;
            synchronized (linkedHashMap) {
                if (this.sortedPrecedenceDefEntries == null) {
                    this.sortedPrecedenceDefEntries = PrecedenceSorter.createOverallPrecedence(this);
                }
            }
        }
        return this.sortedPrecedenceDefEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdviceStack(AdviceStack stack) {
        this.initInerceptorStacksMap();
        HashMap<String, AdviceStack> hashMap = this.interceptorStacks;
        synchronized (hashMap) {
            this.interceptorStacks.put(stack.getName(), stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterceptorStack(String name) {
        HashMap<String, AdviceStack> hashMap = this.interceptorStacks;
        synchronized (hashMap) {
            this.interceptorStacks.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdviceStack getAdviceStack(String name) {
        HashMap<String, AdviceStack> hashMap = this.interceptorStacks;
        synchronized (hashMap) {
            return this.interceptorStacks.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attachMetaData(ClassAdvisor advisor, CtClass clazz, boolean addAdvisor) throws Exception {
        boolean attached = false;
        LinkedHashMap<String, ClassMetaDataBinding> linkedHashMap = this.classMetaData;
        synchronized (linkedHashMap) {
            for (ClassMetaDataBinding data : this.classMetaData.values()) {
                if (!data.matches((Advisor)advisor, clazz)) continue;
                attached = true;
                if (addAdvisor) {
                    data.addAdvisor(advisor);
                }
                ClassMetaDataLoader loader = data.getLoader();
                loader.bind((Advisor)advisor, data, clazz.getDeclaredMethods(), clazz.getDeclaredFields(), clazz.getDeclaredConstructors());
            }
        }
        return attached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachMetaData(Advisor advisor, Class<?> clazz) {
        LinkedHashMap<String, ClassMetaDataBinding> linkedHashMap = this.classMetaData;
        synchronized (linkedHashMap) {
            for (ClassMetaDataBinding data : this.classMetaData.values()) {
                this.addAdvisorToClassMetaDataBinding(data, clazz, advisor, clazz);
            }
        }
    }

    public ClassAdvisor getTempClassAdvisor(CtClass clazz) throws Exception {
        ClassAdvisor advisor = AdvisorFactory.getClassAdvisor(clazz, this);
        this.attachMetaData(advisor, clazz, false);
        this.applyInterfaceIntroductions(advisor, clazz);
        return advisor;
    }

    public Advisor getTempClassAdvisorIfNotExist(Class<?> clazz) {
        Advisor advisor = this.findAdvisor(clazz);
        if (advisor != null) {
            return advisor;
        }
        if (Advised.class.isAssignableFrom(clazz)) {
            try {
                for (Class<?> superClass = clazz; superClass != null; superClass = superClass.getSuperclass()) {
                    try {
                        Field field = superClass.getDeclaredField("aop$classAdvisor$aop");
                        SecurityActions.setAccessible(field);
                        advisor = (ClassAdvisor)field.get(null);
                        if (advisor != null) {
                            return advisor;
                        }
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        advisor = AdvisorFactory.getClassAdvisor(clazz, this);
        advisor.setClazz(clazz);
        return advisor;
    }

    public DomainDefinition getContainer(String name) {
        return this.containers.get(name);
    }

    public void addContainer(DomainDefinition def) {
        this.initContainersMap();
        this.containers.put(def.getName(), def);
    }

    public void removeContainer(String name) {
        this.containers.remove(name);
    }

    public Pointcut getPointcut(String name) {
        return this.bindingCollection.getPointcut(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePointcut(String name) {
        lock.lockWrite();
        try {
            this.bindingCollection.removePointcut(name);
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPointcut(Pointcut pointcut) {
        lock.lockWrite();
        try {
            this.bindingCollection.add(pointcut, this);
        }
        finally {
            lock.unlockWrite();
        }
    }

    public boolean isExecution() {
        return this.bindingCollection.isExecution();
    }

    public boolean isConstruction() {
        return this.bindingCollection.isConstruction();
    }

    public boolean isCall() {
        return this.bindingCollection.isCall();
    }

    public boolean isWithin() {
        return this.bindingCollection.isWithin();
    }

    public boolean isWithincode() {
        return this.bindingCollection.isWithincode();
    }

    public boolean isGet() {
        return this.bindingCollection.isGet();
    }

    public boolean isSet() {
        return this.bindingCollection.isSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinding(String name) {
        lock.lockWrite();
        try {
            AdviceBinding binding = this.internalRemoveBinding(name);
            if (binding != null) {
                binding.clearAdvisors();
                this.dynamicStrategy.interceptorChainsUpdated();
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindings(ArrayList<String> binds) {
        AspectManager.clearUnregisteredClassLoaders();
        HashSet<Advisor> bindingAdvisors = new HashSet<Advisor>();
        ArrayList<AdviceBinding> removedBindings = null;
        lock.lockWrite();
        try {
            removedBindings = this.bindingCollection.removeBindings(binds);
            for (AdviceBinding removedBinding : removedBindings) {
                ArrayList<Advisor> ads = removedBinding.getAdvisors();
                bindingAdvisors.addAll(ads);
                Pointcut pointcut = removedBinding.getPointcut();
                this.removePointcut(pointcut.getName());
            }
        }
        finally {
            lock.unlockWrite();
        }
        for (Advisor advisor : bindingAdvisors) {
            if (!this.isAdvisorRegistered(advisor)) {
                WeakReference<Domain> ref = this.getSubDomainsPerClass().get(advisor.getClazz());
                Domain domain = null;
                if (ref != null) {
                    domain = (Domain)ref.get();
                }
                if (domain != null && (!this.subscribedSubDomains.containsKey(domain) && !this.subscribedSubDomainsQueue.containsKey(domain) || !domain.isAdvisorRegistered(advisor))) continue;
            }
            advisor.removeAdviceBindings(removedBindings);
        }
        this.dynamicStrategy.interceptorChainsUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinding(AdviceBinding binding) {
        HashSet<Advisor> affectedAdvisors = null;
        AdviceBinding removedBinding = null;
        lock.lockWrite();
        try {
            removedBinding = this.internalRemoveBinding(binding.getName());
            affectedAdvisors = removedBinding == null ? null : new HashSet<Advisor>(removedBinding.getAdvisors());
            this.bindingCollection.add(binding, this);
            WeakHashMap<Class<?>, WeakReference<Advisor>> weakHashMap = this.advisors;
            synchronized (weakHashMap) {
                HashSet<Advisor> handledAdvisors = new HashSet<Advisor>();
                this.updateAdvisorsForAddedBinding(binding, handledAdvisors);
                if (affectedAdvisors != null && affectedAdvisors.size() > 0) {
                    for (Advisor advisor : affectedAdvisors) {
                        if (!this.isAdvisorRegistered(advisor)) continue;
                        advisor.removeAdviceBinding(removedBinding);
                    }
                }
            }
            this.dynamicStrategy.interceptorChainsUpdated();
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAdvisorsForAddedBinding(AdviceBinding binding, Set<Advisor> handledAdvisors) {
        WeakHashMap<Object, Object> weakHashMap = this.advisors;
        synchronized (weakHashMap) {
            Set<Class<?>> keys = this.advisors.keySet();
            if (keys.size() > 0) {
                Iterator<Class<?>> it = keys.iterator();
                while (it.hasNext()) {
                    Advisor advisor = this.getAdvisorFromAdvisorsKeySetIterator(it);
                    if (advisor == null || handledAdvisors.contains(advisor)) continue;
                    handledAdvisors.add(advisor);
                    if (binding.getPointcut().softMatch(advisor)) {
                        if (verbose && logger.isDebugEnabled()) {
                            logger.debug("softmatch succeeded for : " + advisor.getName() + " " + binding + " " + binding.getPointcut().getExpr());
                        }
                        advisor.newBindingAdded(binding);
                        continue;
                    }
                    if (!verbose || !logger.isDebugEnabled()) continue;
                    logger.debug("softmatch failed for : " + advisor.getName() + " " + binding + " " + binding.getPointcut().getExpr());
                }
            }
        }
        weakHashMap = this.subscribedSubDomains;
        synchronized (weakHashMap) {
            this.copySubDomainsFromQueue(true);
            boolean newSubscribers = true;
            while (newSubscribers) {
                Set<Domain> domains = this.subscribedSubDomains.keySet();
                if (domains.size() > 0) {
                    for (Domain domain : domains) {
                        domain.updateAdvisorsForAddedBinding(binding, handledAdvisors);
                    }
                }
                newSubscribers = this.copySubDomainsFromQueue(false);
            }
        }
    }

    public void removeClassMetaData(String name) {
        this.internalRemoveClassMetaData(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalRemoveClassMetaData(String name) {
        LinkedHashMap<String, ClassMetaDataBinding> linkedHashMap = this.classMetaData;
        synchronized (linkedHashMap) {
            ClassMetaDataBinding meta = (ClassMetaDataBinding)this.classMetaData.remove(name);
            if (meta == null) {
                return;
            }
            meta.clearAdvisors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassMetaData(ClassMetaDataBinding meta) {
        this.internalRemoveClassMetaData(meta.getName());
        this.initClassMetaDataMap();
        LinkedHashMap<String, ClassMetaDataBinding> linkedHashMap = this.classMetaData;
        synchronized (linkedHashMap) {
            this.classMetaData.put(meta.getName(), meta);
        }
        this.updateAdvisorsForAddedClassMetaData(meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAdvisorsForAddedClassMetaData(ClassMetaDataBinding meta) {
        WeakHashMap<Object, Object> weakHashMap = this.advisors;
        synchronized (weakHashMap) {
            Iterator<Class<?>> it = this.advisors.keySet().iterator();
            while (it.hasNext()) {
                Advisor advisor = this.getAdvisorFromAdvisorsKeySetIterator(it);
                if (advisor == null) continue;
                Class clazz = advisor.getClazz();
                this.addAdvisorToClassMetaDataBinding(meta, clazz, advisor, clazz);
            }
        }
        weakHashMap = this.subscribedSubDomains;
        synchronized (weakHashMap) {
            this.copySubDomainsFromQueue(true);
            boolean newSubscribers = true;
            while (newSubscribers) {
                if (this.subscribedSubDomains.size() > 0) {
                    for (Domain domain : this.subscribedSubDomains.keySet()) {
                        domain.updateAdvisorsForAddedClassMetaData(meta);
                    }
                }
                newSubscribers = this.copySubDomainsFromQueue(false);
            }
        }
    }

    protected void addAdvisorToClassMetaDataBinding(ClassMetaDataBinding meta, Class<?> clazz, Advisor advisor, Class<?> advisedClass) {
        Class<?> superClass;
        if (meta.matches(advisor, clazz)) {
            meta.addAdvisor(advisor);
        } else if (advisor.chainOverridingForInheritedMethods() && (superClass = clazz.getSuperclass()) != null && superClass != Object.class) {
            this.addAdvisorToClassMetaDataBinding(meta, superClass, advisor, advisedClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceIntroduction getInterfaceIntroduction(String name) {
        LinkedHashMap<String, InterfaceIntroduction> linkedHashMap = this.interfaceIntroductions;
        synchronized (linkedHashMap) {
            return this.interfaceIntroductions.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterfaceIntroduction(InterfaceIntroduction pointcut) {
        lock.lockWrite();
        try {
            this.removeInterfaceIntroduction(pointcut.getName());
            this.initInterfaceIntroductionsMap();
            LinkedHashMap<String, InterfaceIntroduction> linkedHashMap = this.interfaceIntroductions;
            synchronized (linkedHashMap) {
                this.interfaceIntroductions.put(pointcut.getName(), pointcut);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterfaceIntroduction(String name) {
        lock.lockWrite();
        try {
            LinkedHashMap<String, InterfaceIntroduction> linkedHashMap = this.interfaceIntroductions;
            synchronized (linkedHashMap) {
                InterfaceIntroduction pointcut;
                block8: {
                    pointcut = (InterfaceIntroduction)this.interfaceIntroductions.remove(name);
                    if (pointcut != null) break block8;
                    return;
                }
                pointcut.clearAdvisors();
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayReplacement getArrayReplacement(String name) {
        LinkedHashMap<String, ArrayReplacement> linkedHashMap = this.arrayReplacements;
        synchronized (linkedHashMap) {
            return this.arrayReplacements.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArrayReplacement(ArrayReplacement pointcut) {
        lock.lockWrite();
        try {
            this.removeArrayReplacement(pointcut.getName());
            this.initArrayReplacementMap();
            LinkedHashMap<String, ArrayReplacement> linkedHashMap = this.arrayReplacements;
            synchronized (linkedHashMap) {
                this.arrayReplacements.put(pointcut.getName(), pointcut);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArrayReplacement(String name) {
        lock.lockWrite();
        try {
            LinkedHashMap<String, ArrayReplacement> linkedHashMap = this.arrayReplacements;
            synchronized (linkedHashMap) {
                this.arrayReplacements.remove(name);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayBinding getArrayBinding(String name) {
        LinkedHashMap<String, ArrayBinding> linkedHashMap = this.arrayBindings;
        synchronized (linkedHashMap) {
            return this.arrayBindings.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArrayBinding(ArrayBinding binding) {
        lock.lockWrite();
        try {
            this.removeArrayBinding(binding.getName());
            this.initArrayBindingMap();
            LinkedHashMap<String, ArrayBinding> linkedHashMap = this.arrayBindings;
            synchronized (linkedHashMap) {
                this.arrayBindings.put(binding.getName(), binding);
                ArrayAdvisor.addBinding(binding);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArrayBinding(String name) {
        lock.lockWrite();
        try {
            LinkedHashMap<String, ArrayBinding> linkedHashMap = this.arrayBindings;
            synchronized (linkedHashMap) {
                ArrayBinding pointcut;
                block8: {
                    pointcut = (ArrayBinding)this.arrayBindings.remove(name);
                    if (pointcut != null) break block8;
                    return;
                }
                ArrayAdvisor.removeBinding(pointcut);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationIntroduction(AnnotationIntroduction pointcut) {
        lock.lockWrite();
        try {
            String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
            this.removeAnnotationIntroduction(pointcut);
            this.initAnnotationIntroductionsMap();
            LinkedHashMap<String, AnnotationIntroduction> linkedHashMap = this.annotationIntroductions;
            synchronized (linkedHashMap) {
                this.annotationIntroductions.put(name, pointcut);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationIntroduction(AnnotationIntroduction pointcut) {
        lock.lockWrite();
        try {
            String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
            LinkedHashMap<String, AnnotationIntroduction> linkedHashMap = this.annotationIntroductions;
            synchronized (linkedHashMap) {
                this.annotationIntroductions.remove(name);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnnotationIntroduction> getAnnotationIntroductions() {
        LinkedHashMap<String, AnnotationIntroduction> linkedHashMap = this.annotationIntroductions;
        synchronized (linkedHashMap) {
            return new ArrayList<AnnotationIntroduction>(this.annotationIntroductions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeclare(DeclareDef declare) {
        lock.lockWrite();
        try {
            this.removeDeclare(declare.getName());
            this.initDeclaresMap();
            HashMap<String, DeclareDef> hashMap = this.declares;
            synchronized (hashMap) {
                this.declares.put(declare.getName(), declare);
            }
            if (declare.isPointcut()) {
                PointcutStats stats = new PointcutStats(declare.getAst(), manager);
                stats.matches();
                this.bindingCollection.updateStats(stats);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclare(String name) {
        lock.lockWrite();
        try {
            HashMap<String, DeclareDef> hashMap = this.declares;
            synchronized (hashMap) {
                this.declares.remove(name);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    public Iterator<DeclareDef> getDeclares() {
        return this.declares.values().iterator();
    }

    protected void applyInterfaceIntroductions(Advisor advisor, Class<?> clazz) {
        Map<String, InterfaceIntroduction> interfaceIntroductions = this.getInterfaceIntroductions();
        if (interfaceIntroductions != null && interfaceIntroductions.size() > 0) {
            for (InterfaceIntroduction pointcut : interfaceIntroductions.values()) {
                if (!pointcut.matches(advisor, clazz)) continue;
                pointcut.addAdvisor(advisor);
            }
        }
    }

    protected void applyInterfaceIntroductions(ClassAdvisor advisor, CtClass clazz) throws Exception {
        Map<String, InterfaceIntroduction> interfaceIntroductions = this.getInterfaceIntroductions();
        if (interfaceIntroductions != null && interfaceIntroductions.size() > 0) {
            for (InterfaceIntroduction pointcut : interfaceIntroductions.values()) {
                if (!pointcut.matches((Advisor)advisor, clazz)) continue;
                pointcut.addAdvisor(advisor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationOverride(AnnotationIntroduction pointcut) {
        lock.lockWrite();
        try {
            String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
            this.initAnnotationOverridesMap();
            LinkedHashMap<String, AnnotationIntroduction> linkedHashMap = this.annotationOverrides;
            synchronized (linkedHashMap) {
                this.annotationOverrides.put(name, pointcut);
            }
            this.updateAdvisorsForAddedAnnotationOverride(pointcut);
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdvisorsForAddedAnnotationOverride(AnnotationIntroduction introduction) {
        WeakHashMap<Object, Object> weakHashMap = this.advisors;
        synchronized (weakHashMap) {
            Iterator<Class<?>> it = this.advisors.keySet().iterator();
            while (it.hasNext()) {
                Advisor advisor = this.getAdvisorFromAdvisorsKeySetIterator(it);
                if (advisor == null) continue;
                advisor.deployAnnotationOverride(introduction);
            }
        }
        weakHashMap = this.subscribedSubDomains;
        synchronized (weakHashMap) {
            this.copySubDomainsFromQueue(true);
            boolean newSubscribers = true;
            while (newSubscribers) {
                for (Domain domain : this.subscribedSubDomains.keySet()) {
                    domain.updateAdvisorsForAddedAnnotationOverride(introduction);
                }
                newSubscribers = this.copySubDomainsFromQueue(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationOverride(AnnotationIntroduction pointcut) {
        lock.lockWrite();
        try {
            String name = pointcut.getOriginalAnnotationExpr() + pointcut.getOriginalExpression();
            LinkedHashMap<String, AnnotationIntroduction> linkedHashMap = this.annotationOverrides;
            synchronized (linkedHashMap) {
                this.annotationOverrides.remove(name);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnnotationIntroduction> getAnnotationOverrides() {
        LinkedHashMap<String, AnnotationIntroduction> linkedHashMap = this.annotationOverrides;
        synchronized (linkedHashMap) {
            return new ArrayList<AnnotationIntroduction>(this.annotationOverrides.values());
        }
    }

    public Object getPerVMAspect(AspectDefinition def) {
        return this.getPerVMAspect(def.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerVMAspect(String def) {
        AspectDefinition adef;
        Object aspect = this.perVMAspects.get(def);
        if (aspect == null && (adef = this.aspectDefinitions.get(def)) != null && adef.getScope() == Scope.PER_VM) {
            AspectDefinition aspectDefinition = adef;
            synchronized (aspectDefinition) {
                aspect = this.perVMAspects.get(def);
                if (aspect == null) {
                    aspect = this.createPerVmAspect(def, adef, null);
                }
            }
        }
        if (aspect == NULL_ASPECT) {
            return null;
        }
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createPerVmAspect(String def, AspectDefinition adef, ClassLoader scopedClassLoader) {
        Object instance = null;
        AspectDefinition aspectDefinition = adef;
        synchronized (aspectDefinition) {
            try {
                if (scopedClassLoader != null && adef.getFactory() instanceof AspectFactoryWithClassLoader) {
                    ((AspectFactoryWithClassLoader)((Object)adef.getFactory())).pushScopedClassLoader(scopedClassLoader);
                }
                instance = adef.getFactory().createPerVM();
                this.initPerVMAspectsMap();
                if (instance == null) {
                    this.perVMAspects.put(def, NULL_ASPECT);
                } else {
                    this.perVMAspects.put(def, instance);
                }
            }
            finally {
                if (scopedClassLoader != null && adef.getFactory() instanceof AspectFactoryWithClassLoader) {
                    ((AspectFactoryWithClassLoader)((Object)adef.getFactory())).popScopedClassLoader();
                }
            }
        }
        return instance;
    }

    public void addAspectDefinition(AspectDefinition def) {
        this.removeAspectDefinition(def.getName());
        this.initAspectDefintitionsMap();
        this.aspectDefinitions.put(def.getName(), def);
    }

    public void removeAspectDefinition(String name) {
        this.internalRemoveAspectDefintion(name);
    }

    protected AspectDefinition internalRemoveAspectDefintion(String name) {
        AspectDefinition def = this.aspectDefinitions.remove(name);
        if (def != null) {
            def.undeploy();
            if (def.getScope() == Scope.PER_VM) {
                this.perVMAspects.remove(def.getName());
            }
        }
        return def;
    }

    public Map<String, AspectDefinition> getAspectDefinitions() {
        return this.aspectDefinitions;
    }

    public AspectDefinition getAspectDefinition(String name) {
        return this.aspectDefinitions.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedef(Typedef def) throws Exception {
        lock.lockWrite();
        try {
            this.removeTypedef(def.getName());
            this.initTypedefsMap();
            LinkedHashMap<String, Typedef> linkedHashMap = this.typedefs;
            synchronized (linkedHashMap) {
                this.typedefs.put(def.getName(), def);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypedef(String name) {
        lock.lockWrite();
        try {
            LinkedHashMap<String, Typedef> linkedHashMap = this.typedefs;
            synchronized (linkedHashMap) {
                this.typedefs.remove(name);
            }
        }
        finally {
            lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Typedef getTypedef(String name) {
        LinkedHashMap<String, Typedef> linkedHashMap = this.typedefs;
        synchronized (linkedHashMap) {
            return this.typedefs.get(name);
        }
    }

    public Map<String, InterfaceIntroduction> getInterfaceIntroductions() {
        return this.interfaceIntroductions;
    }

    public Map<String, ArrayReplacement> getArrayReplacements() {
        return this.arrayReplacements;
    }

    public Map<String, Typedef> getTypedefs() {
        return this.typedefs;
    }

    public Map<String, AdviceStack> getInterceptorStacks() {
        return this.interceptorStacks;
    }

    public Map<String, ClassMetaDataLoader> getClassMetaDataLoaders() {
        return this.classMetaDataLoaders;
    }

    public Map<String, CFlowStack> getCflowStacks() {
        return this.cflowStacks;
    }

    public Map<String, DynamicCFlowDefinition> getDynamicCFlows() {
        return this.dynamicCFlows;
    }

    public Map<String, Object> getPerVMAspects() {
        return this.perVMAspects;
    }

    public Map<String, ClassMetaDataBinding> getClassMetaData() {
        return this.classMetaData;
    }

    public DynamicAOPStrategy getDynamicAOPStrategy() {
        return this.dynamicStrategy;
    }

    public void setDynamicAOPStrategy(DynamicAOPStrategy strategy) {
        if (AspectManager.hasTransformationStarted()) {
            throw new RuntimeException("Dynamic AOP Strategy Update not allowed in run time");
        }
        this.dynamicStrategy = strategy;
    }

    private AdviceBinding internalRemoveBinding(String name) {
        AdviceBinding binding = this.bindingCollection.removeBinding(name);
        if (binding == null) {
            return null;
        }
        Pointcut pointcut = binding.getPointcut();
        this.removePointcut(pointcut.getName());
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubDomainPerClass(Class<?> clazz, Domain domain) {
        Map<Class<?>, WeakReference<Domain>> map = this.getSubDomainsPerClass();
        synchronized (map) {
            this.getSubDomainsPerClass().put(clazz, new WeakReference<Domain>(domain));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeSubDomain(Domain domain) {
        this.initSubscribedSubDomainsMap();
        this.initSubscribedSubDomainsQueueMap();
        WeakHashMap<Domain, Object> weakHashMap = this.subscribedSubDomains;
        synchronized (weakHashMap) {
            this.subscribedSubDomainsQueue.put(domain, "Contents do not matter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeSubDomain(Domain domain) {
        WeakHashMap<Domain, Object> weakHashMap = this.subscribedSubDomains;
        synchronized (weakHashMap) {
            this.subscribedSubDomains.remove(domain);
        }
    }

    public Map<Domain, Object> getSubscribedSubDomains() {
        return this.subscribedSubDomains;
    }

    private Advisor getAdvisorFromAdvisorsKeySetIterator(Iterator<Class<?>> it) {
        Class<?> clazz = it.next();
        if (classLoaderValidator != null && !classLoaderValidator.isValidClassLoader(SecurityActions.getClassLoader(clazz))) {
            it.remove();
            return null;
        }
        WeakReference<Advisor> ref = this.advisors.get(clazz);
        if (ref == null) {
            return null;
        }
        Advisor advisor = (Advisor)ref.get();
        if (advisor == null) {
            it.remove();
            return null;
        }
        return advisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copySubDomainsFromQueue(boolean increment) {
        boolean copied = false;
        this.initSubscribedSubDomainsMap();
        WeakHashMap<Domain, Object> weakHashMap = this.subscribedSubDomains;
        synchronized (weakHashMap) {
            if (!increment && this.subscribedDomainQueueRef > 0) {
                --this.subscribedDomainQueueRef;
            }
            if (this.subscribedDomainQueueRef == 0 && this.subscribedSubDomainsQueue.size() > 0) {
                this.subscribedSubDomains.putAll(this.subscribedSubDomainsQueue);
                this.subscribedSubDomainsQueue.clear();
                copied = true;
            }
            if (increment) {
                ++this.subscribedDomainQueueRef;
            }
        }
        return copied;
    }

    public void addLifecycleDefinition(AspectDefinition def) {
        this.lifecycleManager.addLifecycleDefinition(def);
    }

    public void removeLifecycleDefinition(String name) {
        this.lifecycleManager.removeLifecycleDefinition(name);
    }

    public void addLifecycleBinding(LifecycleCallbackBinding lifecycleBinding) {
        this.lifecycleManager.addLifecycleBinding(lifecycleBinding);
    }

    public Map<String, LifecycleCallbackBinding> getLifecycleBindings() {
        return this.lifecycleManager.getLifecycleBindings();
    }

    public void removeLifecycleBinding(String name) {
        this.lifecycleManager.removeLifecycleBinding(name);
    }

    public static boolean hasTransformationStarted() {
        return WeavingStrategySupport.transformationStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSubDomainsByNameMap() {
        if (this.subDomainsByName == UnmodifiableEmptyCollections.EMPTY_WEAK_VALUE_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.subDomainsByName == UnmodifiableEmptyCollections.EMPTY_WEAK_VALUE_HASHMAP) {
                    this.subDomainsByName = new WeakValueHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSubscribedSubDomainsMap() {
        if (this.subscribedSubDomains == UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.subscribedSubDomains == UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP) {
                    this.subscribedSubDomains = new WeakHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSubscribedSubDomainsQueueMap() {
        if (this.subscribedSubDomainsQueue == UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.subscribedSubDomainsQueue == UnmodifiableEmptyCollections.EMPTY_WEAK_HASHMAP) {
                    this.subscribedSubDomainsQueue = new WeakHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInterfaceIntroductionsMap() {
        if (this.interfaceIntroductions == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.interfaceIntroductions == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
                    this.interfaceIntroductions = new LinkedHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initArrayReplacementMap() {
        if (this.arrayReplacements == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.arrayReplacements == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
                    this.arrayReplacements = new LinkedHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initArrayBindingMap() {
        if (this.arrayBindings == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.arrayBindings == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
                    this.arrayBindings = new LinkedHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAnnotationIntroductionsMap() {
        if (this.annotationIntroductions == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.annotationIntroductions == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
                    this.annotationIntroductions = new LinkedHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAnnotationOverridesMap() {
        if (this.annotationOverrides == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.annotationOverrides == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
                    this.annotationOverrides = new LinkedHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTypedefsMap() {
        if (this.typedefs == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.typedefs == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
                    this.typedefs = new LinkedHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInterceptorFactoriesMap() {
        if (this.interceptorFactories == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.interceptorFactories == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
                    this.interceptorFactories = new HashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClassMetaDataLoadersMap() {
        if (this.classMetaDataLoaders == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.classMetaDataLoaders == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
                    this.classMetaDataLoaders = new HashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInerceptorStacksMap() {
        if (this.interceptorStacks == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.interceptorStacks == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
                    this.interceptorStacks = new HashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDeclaresMap() {
        if (this.declares == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.declares == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
                    this.declares = new HashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCflowStacksMap() {
        if (this.cflowStacks == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.cflowStacks == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.cflowStacks = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDynamicCflowsMap() {
        if (this.dynamicCFlows == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.dynamicCFlows == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.dynamicCFlows = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAspectDefintitionsMap() {
        if (this.aspectDefinitions == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.aspectDefinitions == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.aspectDefinitions = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPerVMAspectsMap() {
        if (this.perVMAspects == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.perVMAspects == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.perVMAspects = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClassMetaDataMap() {
        if (this.classMetaData == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.classMetaData == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
                    this.classMetaData = new LinkedHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initContainersMap() {
        if (this.containers == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.containers == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
                    this.containers = new HashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPrecedenceDefsMap() {
        if (this.precedenceDefs == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.precedenceDefs == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
                    this.precedenceDefs = new LinkedHashMap();
                }
            }
        }
    }

    static {
        interceptionMarkers = new WeakHashMap<ClassLoader, InterceptionMarkers>();
        NULL_CLASSLOADER = new URLClassLoader(new URL[0]);
        optimize = true;
        verbose = false;
        notificationHandler = null;
        suppressTransformationErrors = false;
        suppressReferenceErrors = true;
    }
}

