/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.ref.WeakReference;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.SecurityActions;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericInterceptorFactory
implements InterceptorFactory {
    private WeakReference<Class<?>> classRef = null;
    private String classname;
    private Element element;
    private boolean deployed = true;
    private String name;
    private static volatile int counter = 0;

    public GenericInterceptorFactory(String classname, Element element) {
        this.name = classname + counter++;
        this.classname = classname;
        this.element = element;
    }

    public GenericInterceptorFactory(Class<?> clazz) {
        this.classRef = new WeakReference(clazz);
        this.classname = clazz.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AspectDefinition getAspect() {
        return null;
    }

    @Override
    public String getAdvice() {
        return "invoke";
    }

    public void undeploy() {
        this.deployed = false;
    }

    @Override
    public boolean isDeployed() {
        return this.deployed;
    }

    public String getClassName() {
        return this.classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        try {
            Class<?> clazz = null;
            GenericInterceptorFactory genericInterceptorFactory = this;
            synchronized (genericInterceptorFactory) {
                if (this.classRef != null) {
                    clazz = (Class<?>)this.classRef.get();
                }
                if (clazz != null) {
                    ClassLoader cl = advisor.getClassLoader();
                    if (cl == null) {
                        cl = SecurityActions.getContextClassLoader();
                    }
                    clazz = cl.loadClass(this.classname);
                    this.classRef = new WeakReference(clazz);
                }
            }
            Interceptor interceptor = (Interceptor)clazz.newInstance();
            if (interceptor instanceof XmlLoadable && this.element != null) {
                ((XmlLoadable)((Object)interceptor)).importXml(this.element);
            }
            return interceptor;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericInterceptorFactory)) {
            return false;
        }
        return this.classname.equals(((GenericInterceptorFactory)obj).classname);
    }

    @Override
    public AdviceType getType() {
        return AdviceType.AROUND;
    }
}

