/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.ConByMethodInfo;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.instrument.CallerInfoAdder;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.instrument.DeclareChecker;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.util.Advisable;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.logging.Logger;

public abstract class CallerTransformer {
    private static final Logger logger = Logger.getLogger(CallerTransformer.class);
    public static final String CON_BY_CON_INFO_CLASS_NAME = ConByConInfo.class.getName();
    public static final String CON_BY_METHOD_INFO_CLASS_NAME = ConByMethodInfo.class.getName();
    public static final String METHOD_BY_CON_INFO_CLASS_NAME = MethodByConInfo.class.getName();
    public static final String METHOD_BY_METHOD_INFO_CLASS_NAME = MethodByMethodInfo.class.getName();
    Instrumentor instrumentor;
    boolean optimize;
    AspectManager manager;
    CallerInfoAdder callerInfoAdder;

    protected CallerTransformer(Instrumentor instrumentor, AspectManager manager, boolean optimize, CallerInfoAdder callerInfoAdder) {
        this.instrumentor = instrumentor;
        this.optimize = optimize;
        this.manager = manager;
        this.callerInfoAdder = callerInfoAdder;
    }

    protected abstract CallerExprEditor callerExprEditorFactory(ClassAdvisor var1, CtClass var2);

    public boolean applyCallerPointcuts(CtClass clazz, ClassAdvisor advisor) throws CannotCompileException {
        if (!(advisor.getManager().isWithin() || advisor.getManager().isCall() || advisor.getManager().isWithincode())) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("There are no caller pointcuts!");
            }
            return false;
        }
        CallerExprEditor expr = this.callerExprEditorFactory(advisor, clazz);
        CtMethod[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Advisable.isAdvisable(methods[i])) continue;
            methods[i].instrument(expr);
        }
        CtConstructor[] cons = clazz.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            cons[i].instrument(expr);
        }
        return expr.appliedCallerBinding;
    }

    private boolean isTargetConstructorAdvised(CtConstructor calledConstructor) {
        try {
            ClassAdvisor adv = this.manager.getTempClassAdvisor(calledConstructor.getDeclaringClass());
            return ConstructorExecutionTransformer.isAdvisableConstructor(calledConstructor, adv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getHashString(long hash) {
        if (hash < 0L) {
            return "_N_" + -1L * hash;
        }
        return "_" + hash;
    }

    protected static String getUniqueInvocationFieldname(long callingHash, String classname, long calledHash) {
        classname = classname.replace('.', '_');
        classname = classname.replace('/', '_');
        return CallerTransformer.getHashString(callingHash) + classname + CallerTransformer.getHashString(calledHash);
    }

    protected static String getConByConInfoName(long callingIndex, String classname, long calledHash) {
        return "aop$constructorCall_con_" + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    protected static String getConByMethodInfoName(long callingHash, String classname, long calledHash) {
        return "aop$constructorCall_" + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    protected static String getMethodByConInfoName(int index, String classname, long calledHash) {
        return "aop$methodCall_con_" + CallerTransformer.getUniqueInvocationFieldname(index, classname, calledHash);
    }

    protected static String getMethodByMethodInfoName(long callingHash, String classname, long calledHash) {
        return "aop$methodCall_" + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    protected static String conByConInfoFromWeakReference(String localName, String infoName) {
        return TransformerCommon.infoFromWeakReference(CON_BY_CON_INFO_CLASS_NAME, localName, infoName);
    }

    protected static String conByMethodInfoFromWeakReference(String localName, String infoName) {
        return TransformerCommon.infoFromWeakReference(CON_BY_METHOD_INFO_CLASS_NAME, localName, infoName);
    }

    protected static String methodByMethodInfoFromWeakReference(String localName, String infoName) {
        return TransformerCommon.infoFromWeakReference(METHOD_BY_METHOD_INFO_CLASS_NAME, localName, infoName);
    }

    protected static String methodByConInfoFromWeakReference(String localName, String infoName) {
        return TransformerCommon.infoFromWeakReference(METHOD_BY_CON_INFO_CLASS_NAME, localName, infoName);
    }

    abstract class CallerExprEditor
    extends ExprEditor {
        CtClass callingClass;
        ClassAdvisor advisor;
        List<CtConstructor> constructors;
        public boolean appliedCallerBinding = false;
        HashMap<String, String> callerInfos = new HashMap();
        int invocationCounter = 0;

        public CallerExprEditor(ClassAdvisor advisor, CtClass callingClass) {
            this.advisor = advisor;
            this.callingClass = callingClass;
            this.constructors = CallerTransformer.this.instrumentor.getConstructors(callingClass);
        }

        private synchronized String getUniqueInvocationClassname(String classname) {
            return classname + "_" + ++this.invocationCounter + "_";
        }

        protected String getOptimizedConCalledByMethodInvocationClassName(long callingHash, String classname, long calledHash) {
            return this.getUniqueInvocationClassname(classname) + "ConByMInvocation";
        }

        protected String getOptimizedConCalledByConInvocationClassName(long callingIndex, String classname, long calledHash) {
            return this.getUniqueInvocationClassname(classname) + "ConByConInvocation";
        }

        protected String getOptimizedMethodCalledByMethodClassName(long callingHash, String classname, long calledHash) {
            return this.getUniqueInvocationClassname(classname) + "MByMInvocation";
        }

        protected String getOptimizedMethodCalledByConstructorClassName(int callingIndex, String classname, long calledHash) {
            return this.getUniqueInvocationClassname(classname) + "MByConInvocation";
        }

        public void edit(MethodCall call) throws CannotCompileException {
            String classname = call.getClassName();
            String methodName = call.getMethodName();
            try {
                if (ClassAdvisor.isWithoutAdvisement(methodName) || methodName.startsWith("_") || classname.startsWith("org.jboss.aop.") || call.getMethodName().equals("class$") || !Instrumentor.isTransformable(this.callingClass)) {
                    return;
                }
                CtBehavior behavior = call.where();
                boolean hasPointcut = false;
                DeclareChecker.checkDeclares(CallerTransformer.this.manager, call, this.advisor);
                Collection<Pointcut> pointcuts = CallerTransformer.this.manager.getBindingCollection().getMethodCallPointcuts();
                for (Pointcut p : pointcuts) {
                    if (p.matchesCall((Advisor)this.advisor, call)) {
                        hasPointcut = true;
                        break;
                    }
                    if (!AspectManager.verbose || !logger.isDebugEnabled()) continue;
                    logger.debug("MethodCall does not match: " + p.getExpr());
                }
                if (hasPointcut) {
                    if (behavior instanceof CtMethod) {
                        this.modifyMethod(call, classname);
                    } else if (behavior instanceof CtConstructor) {
                        this.modifyConstructor(call, classname);
                    }
                }
            }
            catch (Exception ex) {
                logger.error("error getting:" + classname + ". '" + methodName + "'");
                ex.printStackTrace();
                throw new CannotCompileException(ex);
            }
        }

        private void modifyConstructor(MethodCall call, String classname) throws NotFoundException, CannotCompileException {
            CallerTransformer.this.instrumentor.setupBasics(this.callingClass);
            ConstructorDetail cd = new ConstructorDetail(this, call, classname);
            this.setupConstructor(cd);
            this.replaceMethodCallInCon(cd);
            this.appliedCallerBinding = true;
        }

        protected void replaceMethodCallInCon(ConstructorDetail cd) throws CannotCompileException, NotFoundException {
            String replaced = CallerTransformer.methodByConInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + "$_ = ($r)aop$classAdvisor$aop.invokeConstructorCaller(info, this, $0, $args);" + "} else { " + "$_ = $proceed($$); " + "}";
            cd.call.replace(replaced);
        }

        private void modifyMethod(MethodCall call, String classname) throws NotFoundException, CannotCompileException {
            CallerTransformer.this.instrumentor.setupBasics(this.callingClass);
            MethodDetail md = new MethodDetail(this, call, classname);
            this.setupMethod(md);
            this.replaceMethodCallInMethod(md);
            this.appliedCallerBinding = true;
        }

        protected void replaceMethodCallInMethod(MethodDetail md) throws NotFoundException, CannotCompileException {
            String callingObject = ", null";
            if (!Modifier.isStatic(md.where.getModifiers())) {
                callingObject = ", this";
            }
            String replaced = CallerTransformer.methodByMethodInfoFromWeakReference("info", md.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + "$_ = ($r)aop$classAdvisor$aop.invokeCaller(info" + callingObject + ", $0, $args);" + "} else { " + "$_ = $proceed($$); " + "}";
            md.call.replace(replaced);
        }

        public void edit(NewExpr call) throws CannotCompileException {
            try {
                String classname = call.getClassName();
                if (classname.startsWith("org.jboss.aop.") || !Instrumentor.isTransformable(this.callingClass)) {
                    return;
                }
                DeclareChecker.checkDeclares(CallerTransformer.this.manager, call, this.advisor);
                boolean hasPointcut = false;
                Collection<Pointcut> pointcuts = CallerTransformer.this.manager.getBindingCollection().getConstructorCallPointcuts();
                for (Pointcut p : pointcuts) {
                    if (!p.matchesCall((Advisor)this.advisor, call)) continue;
                    hasPointcut = true;
                    break;
                }
                if (hasPointcut) {
                    CtBehavior behavior = call.where();
                    if (behavior instanceof CtMethod) {
                        this.modifyMethod(call, classname);
                    } else if (behavior instanceof CtConstructor) {
                        this.modifyConstructor(call, classname);
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                throw new CannotCompileException(ex);
            }
        }

        private void modifyMethod(NewExpr call, String classname) throws Exception, NotFoundException, CannotCompileException {
            CallerTransformer.this.instrumentor.setupBasics(this.callingClass);
            ConByMethodDetail cd = new ConByMethodDetail(this, call, classname);
            this.setupMethod(cd);
            this.replaceConCallInMethod(cd);
            this.appliedCallerBinding = true;
        }

        protected void replaceConCallInMethod(ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            String callingObject = "null";
            if (!Modifier.isStatic(cd.where.getModifiers())) {
                callingObject = "this";
            }
            String replaced = CallerTransformer.conByMethodInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + "java.lang.Object callingObject = " + callingObject + "; " + "$_ = ($r)aop$classAdvisor$aop.invokeConCalledByMethod(info, " + callingObject + ", $args);" + "} else { " + "$_ = $proceed($$); " + "}";
            cd.call.replace(replaced);
        }

        private void modifyConstructor(NewExpr call, String classname) throws Exception, NotFoundException, CannotCompileException {
            CallerTransformer.this.instrumentor.setupBasics(this.callingClass);
            ConByConDetail cd = new ConByConDetail(this, call, classname);
            this.setupConstructor(cd);
            this.replaceConCallInCon(cd);
            this.appliedCallerBinding = true;
        }

        protected void replaceConCallInCon(ConByConDetail cd) throws CannotCompileException, NotFoundException {
            String replaced = CallerTransformer.conByConInfoFromWeakReference("info", cd.callerInfoField) + "if (info.getInterceptors() != (org.jboss.aop.advice.Interceptor[])null) { " + "$_ = ($r)aop$classAdvisor$aop.invokeConCalledByCon(info, this, $args);" + "} else { " + "$_ = $proceed($$); " + "}";
            cd.call.replace(replaced);
        }

        protected abstract void setupConstructor(ConstructorDetail var1) throws NotFoundException, CannotCompileException;

        protected abstract void setupMethod(MethodDetail var1) throws NotFoundException, CannotCompileException;

        protected abstract void setupMethod(ConByMethodDetail var1) throws NotFoundException, CannotCompileException;

        protected abstract void setupConstructor(ConByConDetail var1) throws NotFoundException, CannotCompileException;
    }

    protected class ConByConDetail {
        NewExpr call;
        boolean isTgtConAdvised;
        CtConstructor con;
        int callingIndex;
        long calledHash;
        String callerInfoField;
        CtConstructor calledConstructor;
        String classname;

        ConByConDetail(CallerExprEditor editor, NewExpr call, String classname) throws NotFoundException {
            this.call = call;
            this.con = (CtConstructor)call.where();
            this.callingIndex = editor.constructors.indexOf(this.con);
            this.calledHash = JavassistMethodHashing.constructorHash(call.getConstructor());
            this.callerInfoField = CallerTransformer.getConByConInfoName(this.callingIndex, classname, this.calledHash);
            this.calledConstructor = call.getConstructor();
            this.classname = classname;
            this.isTgtConAdvised = CallerTransformer.this.isTargetConstructorAdvised(this.calledConstructor);
        }
    }

    protected class ConByMethodDetail {
        NewExpr call;
        boolean isTgtConAdvised;
        CtMethod where;
        long callingHash;
        long calledHash;
        String callerInfoField;
        CtConstructor calledConstructor;
        String classname;

        ConByMethodDetail(CallerExprEditor editor, NewExpr call, String classname) throws NotFoundException {
            this.call = call;
            this.where = (CtMethod)call.where();
            this.callingHash = JavassistMethodHashing.methodHash(this.where);
            this.calledHash = JavassistMethodHashing.constructorHash(call.getConstructor());
            this.callerInfoField = CallerTransformer.getConByMethodInfoName(this.callingHash, classname, this.calledHash);
            this.calledConstructor = call.getConstructor();
            this.classname = classname;
            this.isTgtConAdvised = CallerTransformer.this.isTargetConstructorAdvised(this.calledConstructor);
        }
    }

    protected class MethodDetail {
        MethodCall call;
        CtMethod where;
        long callingHash;
        long calledHash;
        String callerInfoField;
        CtMethod calledMethod;
        String classname;

        MethodDetail(CallerExprEditor editor, MethodCall call, String classname) throws NotFoundException {
            this.call = call;
            this.where = (CtMethod)call.where();
            this.callingHash = JavassistMethodHashing.methodHash(this.where);
            this.calledHash = JavassistMethodHashing.methodHash(call.getMethod());
            this.callerInfoField = CallerTransformer.getMethodByMethodInfoName(this.callingHash, classname, this.calledHash);
            this.calledMethod = call.getMethod();
            this.classname = classname;
        }
    }

    protected class ConstructorDetail {
        MethodCall call;
        CtConstructor con;
        int callingIndex;
        long calledHash;
        String callerInfoField;
        CtMethod calledMethod;
        String classname;

        ConstructorDetail(CallerExprEditor editor, MethodCall call, String classname) throws NotFoundException {
            this.call = call;
            this.con = (CtConstructor)call.where();
            this.callingIndex = editor.constructors.indexOf(this.con);
            this.calledHash = JavassistMethodHashing.methodHash(call.getMethod());
            this.callerInfoField = CallerTransformer.getMethodByConInfoName(this.callingIndex, classname, this.calledHash);
            this.calledMethod = call.getMethod();
            this.classname = classname;
        }
    }
}

