/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.ConByConJoinPointGenerator;
import org.jboss.aop.instrument.ConByMethodJoinPointGenerator;
import org.jboss.aop.instrument.GeneratedAdvisorCallerInfoAdder;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodByConJoinPointGenerator;
import org.jboss.aop.instrument.MethodByMethodJoinPointGenerator;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.logging.Logger;

public class GeneratedAdvisorCallerTransformer
extends CallerTransformer {
    private static final Logger logger = Logger.getLogger(GeneratedAdvisorCallerTransformer.class);

    public GeneratedAdvisorCallerTransformer(Instrumentor instrumentor, AspectManager manager) {
        super(instrumentor, manager, true, new GeneratedAdvisorCallerInfoAdder(instrumentor));
    }

    private GeneratedAdvisorInstrumentor getInstrumentor() {
        return (GeneratedAdvisorInstrumentor)this.instrumentor;
    }

    private CtClass getGenadvisor() {
        return this.getInstrumentor().getGenadvisor();
    }

    protected CallerTransformer.CallerExprEditor callerExprEditorFactory(ClassAdvisor advisor, CtClass clazz) {
        return new GeneratedAdvisorCallerExprEditor(advisor, clazz);
    }

    private String getArguments(int length, int offset) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < length - offset; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("$" + (i + 1 + offset));
        }
        return sb.toString();
    }

    class GeneratedAdvisorCallerExprEditor
    extends CallerTransformer.CallerExprEditor {
        public GeneratedAdvisorCallerExprEditor(ClassAdvisor advisor, CtClass callingClass) {
            super(GeneratedAdvisorCallerTransformer.this, advisor, callingClass);
        }

        protected void setupConstructor(CallerTransformer.ConstructorDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                this.callerInfos.put(cd.callerInfoField, "whatever");
                GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addMethodByConInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
                this.addJoinpoint(cd);
                this.createGenAdvisorMethodByConMethod(cd);
            }
        }

        private void addJoinpoint(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException {
            CtClass joinpoint = this.createJoinpointClass(cd);
            CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
            CtField field = new CtField(joinpoint, MethodByConJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingIndex, cd.classname, cd.calledHash), genadvisor);
            field.setModifiers(1);
            genadvisor.addField(field);
        }

        private CtClass createJoinpointClass(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException {
            return MethodByConJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingIndex, this.callingClass, cd.calledMethod, cd.classname, cd.calledHash, cd.callerInfoField);
        }

        private void createGenAdvisorMethodByConMethod(CallerTransformer.ConstructorDetail cd) throws NotFoundException, CannotCompileException {
            boolean hasTargetObject = !Modifier.isStatic(cd.calledMethod.getModifiers());
            int originalLength = cd.calledMethod.getParameterTypes().length;
            CtClass[] params = null;
            if (hasTargetObject) {
                params = new CtClass[originalLength + 2];
                params[0] = GeneratedAdvisorCallerTransformer.this.instrumentor.forName(cd.classname);
                params[1] = this.callingClass;
                System.arraycopy(cd.calledMethod.getParameterTypes(), 0, params, 2, originalLength);
            } else {
                params = new CtClass[originalLength + 1];
                params[0] = this.callingClass;
                System.arraycopy(cd.calledMethod.getParameterTypes(), 0, params, 1, originalLength);
            }
            String proceed = null;
            proceed = hasTargetObject ? MethodExecutionTransformer.getAopReturnStr(cd.calledMethod) + "$1." + cd.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, 2) + ");" : MethodExecutionTransformer.getAopReturnStr(cd.calledMethod) + cd.classname + "." + cd.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, 1) + ");";
            String joinpointName = MethodByConJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingIndex, cd.classname, cd.calledHash);
            String infoName = cd.callerInfoField;
            String code = "{" + GeneratedAdvisorInstrumentor.generateInterceptorChainLockCode(infoName) + "   try" + "   {" + "      if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "      {" + "         if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "         {" + "            super." + "generateJoinPointClass" + "(" + infoName + ");" + "         }" + "      }" + "      if (" + joinpointName + " == null)" + "      { " + "        " + proceed + "      }" + "      else" + "      {" + "         return " + joinpointName + "." + "invokeJoinpoint" + "($$);" + "      }" + "   } finally {" + GeneratedAdvisorInstrumentor.generateInterceptorChainUnlockCode(infoName) + "   }" + "}";
            try {
                CtMethod method = CtNewMethod.make(cd.calledMethod.getReturnType(), cd.callerInfoField, params, cd.calledMethod.getExceptionTypes(), code, GeneratedAdvisorCallerTransformer.this.getGenadvisor());
                GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
            }
            catch (CannotCompileException e) {
                logger.error("Error for " + cd.callingIndex + " code:" + code);
                throw e;
            }
        }

        protected void setupMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(md.callerInfoField) == null) {
                this.callerInfos.put(md.callerInfoField, "whatever");
                GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addMethodByMethodInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), md.callerInfoField, md.callingHash, md.classname, md.calledHash);
                this.addJoinpoint(md);
                this.createGenAdvisorMethodByMethodMethod(md);
            }
        }

        private void addJoinpoint(CallerTransformer.MethodDetail md) throws CannotCompileException, NotFoundException {
            CtClass joinpoint = this.createJoinpointClass(md);
            CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
            CtField field = new CtField(joinpoint, MethodByMethodJoinPointGenerator.getGeneratedJoinPointFieldName(md.callingHash, md.classname, md.calledHash), genadvisor);
            field.setModifiers(1);
            genadvisor.addField(field);
        }

        private CtClass createJoinpointClass(CallerTransformer.MethodDetail md) throws CannotCompileException, NotFoundException {
            return MethodByMethodJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), md.callingHash, !Modifier.isStatic(md.where.getModifiers()), this.callingClass, md.calledMethod, md.classname, md.calledHash, md.callerInfoField);
        }

        private void createGenAdvisorMethodByMethodMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException {
            boolean hasCallingObject = !Modifier.isStatic(md.where.getModifiers());
            boolean hasTargetObject = !Modifier.isStatic(md.calledMethod.getModifiers());
            int originalLength = md.calledMethod.getParameterTypes().length;
            int offset = 0;
            if (hasTargetObject) {
                ++offset;
            }
            if (hasCallingObject) {
                ++offset;
            }
            CtClass[] params = new CtClass[originalLength + offset];
            int index = 0;
            if (hasTargetObject) {
                params[index++] = GeneratedAdvisorCallerTransformer.this.instrumentor.forName(md.classname);
            }
            if (hasCallingObject) {
                params[index++] = this.callingClass;
            }
            System.arraycopy(md.calledMethod.getParameterTypes(), 0, params, offset, originalLength);
            String proceed = null;
            proceed = hasTargetObject ? MethodExecutionTransformer.getAopReturnStr(md.calledMethod) + "$1." + md.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 2 : 1) + ");" : MethodExecutionTransformer.getAopReturnStr(md.calledMethod) + md.classname + "." + md.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 1 : 0) + ");";
            String joinpointName = MethodByMethodJoinPointGenerator.getGeneratedJoinPointFieldName(md.callingHash, md.classname, md.calledHash);
            String infoName = md.callerInfoField;
            String code = "{" + GeneratedAdvisorInstrumentor.generateInterceptorChainLockCode(infoName) + "   try" + "   {" + "      if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "      {" + "         if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "         {" + "            super." + "generateJoinPointClass" + "(" + infoName + ");" + "         }" + "      }" + "      if (" + joinpointName + " == null)" + "      { " + "        " + proceed + "      }" + "      else" + "      {" + "       " + MethodExecutionTransformer.getReturnStr(md.calledMethod) + joinpointName + "." + "invokeJoinpoint" + "($$);" + "      }" + "   } finally {" + GeneratedAdvisorInstrumentor.generateInterceptorChainUnlockCode(infoName) + "   }" + "}";
            try {
                CtMethod method = CtNewMethod.make(md.calledMethod.getReturnType(), md.callerInfoField, params, md.calledMethod.getExceptionTypes(), code, GeneratedAdvisorCallerTransformer.this.getGenadvisor());
                GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
            }
            catch (CannotCompileException e) {
                logger.error("Error for " + md.where + " code:" + code);
                throw e;
            }
        }

        protected void setupMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                this.callerInfos.put(cd.callerInfoField, "whatever");
                GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addConByMethodInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, cd.callingHash, cd.classname, cd.calledHash);
                this.addJoinpoint(cd);
                this.createGenAdvisorConByMethodMethod(cd);
            }
        }

        private void addJoinpoint(CallerTransformer.ConByMethodDetail cd) throws CannotCompileException, NotFoundException {
            CtClass joinpoint = this.createJoinpointClass(cd);
            CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
            CtField field = new CtField(joinpoint, ConByMethodJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingHash, cd.classname, cd.calledHash), genadvisor);
            field.setModifiers(1);
            genadvisor.addField(field);
        }

        private CtClass createJoinpointClass(CallerTransformer.ConByMethodDetail cd) throws CannotCompileException, NotFoundException {
            return ConByMethodJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingHash, !Modifier.isStatic(cd.where.getModifiers()), this.callingClass, cd.calledConstructor, cd.classname, cd.calledHash, cd.callerInfoField);
        }

        private void createGenAdvisorConByMethodMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            boolean hasCallingObject = !Modifier.isStatic(cd.where.getModifiers());
            String info = cd.callerInfoField;
            int originalLength = cd.calledConstructor.getParameterTypes().length;
            CtClass[] params = null;
            if (hasCallingObject) {
                params = new CtClass[originalLength + 1];
                params[0] = this.callingClass;
                System.arraycopy(cd.calledConstructor.getParameterTypes(), 0, params, 1, originalLength);
            } else {
                params = cd.calledConstructor.getParameterTypes();
            }
            String joinpointName = ConByMethodJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingHash, cd.classname, cd.calledHash);
            String infoName = cd.callerInfoField;
            StringBuffer code = new StringBuffer();
            code.append("{");
            code.append(GeneratedAdvisorInstrumentor.generateInterceptorChainLockCode(infoName));
            code.append("   try");
            code.append("   {");
            code.append("      if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())");
            code.append("      {");
            code.append("         if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())");
            code.append("         {");
            code.append("            super.generateJoinPointClass(" + infoName + ");");
            code.append("         }");
            code.append("      }");
            code.append("      if (" + joinpointName + " == null)");
            code.append("      { ");
            code.append("         return new " + cd.calledConstructor.getDeclaringClass().getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 1 : 0) + "); ");
            code.append("      }");
            code.append("      else");
            code.append("      {");
            code.append("         return " + joinpointName + "." + "invokeJoinpoint" + "($$);");
            code.append("      }");
            code.append("   } finally {");
            code.append(GeneratedAdvisorInstrumentor.generateInterceptorChainUnlockCode(infoName));
            code.append("   }");
            code.append("}");
            try {
                CtMethod method = CtNewMethod.make(cd.calledConstructor.getDeclaringClass(), info, params, cd.calledConstructor.getExceptionTypes(), code.toString(), GeneratedAdvisorCallerTransformer.this.getGenadvisor());
                GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
            }
            catch (CannotCompileException e) {
                logger.error("Error for " + cd.where + ": code:" + code);
                throw e;
            }
        }

        protected void setupConstructor(CallerTransformer.ConByConDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                this.callerInfos.put(cd.callerInfoField, "whatever");
                GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addConByConInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
                this.addJoinpoint(cd);
                this.createGenAdvisorConByConMethod(cd);
            }
        }

        private void addJoinpoint(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            CtClass joinpoint = this.createJoinpointClass(cd);
            CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
            CtField field = new CtField(joinpoint, ConByConJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingIndex, cd.classname, cd.calledHash), genadvisor);
            field.setModifiers(1);
            genadvisor.addField(field);
        }

        private CtClass createJoinpointClass(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            return ConByConJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingIndex, this.callingClass, cd.calledConstructor, cd.classname, cd.calledHash, cd.callerInfoField);
        }

        private void createGenAdvisorConByConMethod(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            int originalLength = cd.calledConstructor.getParameterTypes().length;
            CtClass[] params = new CtClass[originalLength + 1];
            params[0] = this.callingClass;
            System.arraycopy(cd.calledConstructor.getParameterTypes(), 0, params, 1, originalLength);
            String joinpointName = ConByConJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingIndex, cd.classname, cd.calledHash);
            String infoName = cd.callerInfoField;
            String code = "{" + GeneratedAdvisorInstrumentor.generateInterceptorChainLockCode(infoName) + "   try" + "   {" + "      if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "      {" + "         if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "         {" + "            super." + "generateJoinPointClass" + "(" + infoName + ");" + "         }" + "      }" + "      if (" + joinpointName + " == null)" + "      { " + "         return new " + cd.calledConstructor.getDeclaringClass().getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, 1) + "); " + "      }" + "      else" + "      {" + "         return " + joinpointName + "." + "invokeJoinpoint" + "($$);" + "      }" + "   } finally {" + GeneratedAdvisorInstrumentor.generateInterceptorChainUnlockCode(infoName) + "   }" + "}";
            try {
                CtMethod method = CtNewMethod.make(cd.calledConstructor.getDeclaringClass(), cd.callerInfoField, params, cd.calledConstructor.getExceptionTypes(), code, GeneratedAdvisorCallerTransformer.this.getGenadvisor());
                GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
            }
            catch (CannotCompileException e) {
                logger.error("Error for " + cd.callingIndex + " code:" + code);
                throw e;
            }
        }

        protected void replaceMethodCallInCon(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException {
            String advisor = " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")";
            int paramsLength = cd.calledMethod.getParameterTypes().length;
            String args = null;
            args = Modifier.isStatic(cd.calledMethod.getModifiers()) ? "this" + (paramsLength > 0 ? ", $$" : "") : "$0, this" + (paramsLength > 0 ? ", $$" : "");
            String ret = !cd.calledMethod.getReturnType().equals(CtClass.voidType) ? "$_ = " : "";
            String replaced = ret + advisor + "." + cd.callerInfoField + "(" + args + ");";
            try {
                cd.call.replace(replaced);
            }
            catch (CannotCompileException e) {
                logger.error("Error for " + cd.con + " code:" + replaced);
                throw e;
            }
        }

        protected void replaceMethodCallInMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException {
            boolean hasCallingObject = !Modifier.isStatic(md.where.getModifiers());
            boolean hasTargetObject = !Modifier.isStatic(md.calledMethod.getModifiers());
            int paramsLength = md.calledMethod.getParameterTypes().length;
            String args = null;
            args = hasCallingObject && hasTargetObject ? "$0, this" + (paramsLength > 0 ? ", $$" : "") : (!hasCallingObject && hasTargetObject ? "$0" + (paramsLength > 0 ? ", $$" : "") : (hasCallingObject && !hasTargetObject ? "this" + (paramsLength > 0 ? ", $$" : "") : "$$"));
            String advisor = hasCallingObject ? "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")" : " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "aop$classAdvisor$aop" + ")";
            String ret = md.calledMethod.getReturnType().equals(CtClass.voidType) ? "" : "$_ = ";
            String replaced = ret + advisor + "." + md.callerInfoField + "(" + args + ");";
            try {
                md.call.replace(replaced);
            }
            catch (CannotCompileException e) {
                logger.error("Error for " + md.where + " code:" + replaced);
                throw e;
            }
        }

        protected void replaceConCallInMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            int paramsLength = cd.calledConstructor.getParameterTypes().length;
            String args = null;
            String advisor = null;
            if (!Modifier.isStatic(cd.where.getModifiers())) {
                args = "this" + (paramsLength > 0 ? ", $$" : "");
                advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")";
            } else {
                args = paramsLength > 0 ? "$$" : "";
                advisor = " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "aop$classAdvisor$aop" + ")";
            }
            String replaced = "$_ = " + advisor + "." + cd.callerInfoField + "(" + args + ");";
            try {
                cd.call.replace(replaced);
            }
            catch (CannotCompileException e) {
                logger.error("Error for " + cd.where + " code:" + replaced);
                throw e;
            }
        }

        protected void replaceConCallInCon(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            String advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")";
            int paramsLength = cd.calledConstructor.getParameterTypes().length;
            String args = "this" + (paramsLength > 0 ? ", $$" : "");
            String replaced = "$_ = " + advisor + "." + cd.callerInfoField + "(" + args + ");";
            try {
                cd.call.replace(replaced);
            }
            catch (CannotCompileException e) {
                logger.error("Error for " + cd.callingIndex + " code:" + replaced);
                throw e;
            }
        }
    }
}

