/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.introduction;

import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import org.jboss.annotation.factory.ast.ASTAnnotation;
import org.jboss.annotation.factory.ast.ASTStart;
import org.jboss.annotation.factory.ast.AnnotationParser;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.pointcut.AnnotationMatcher;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationIntroduction {
    static final Logger logger = Logger.getLogger(AnnotationIntroduction.class);
    private String originalExpression;
    private String originalAnnotationExpr;
    private org.jboss.aop.pointcut.ast.ASTStart target;
    private ASTAnnotation annotation;
    private boolean invisible;

    public static AnnotationIntroduction createMethodAnnotationIntroduction(String methodExpr, String annotationExpr, boolean invisible) {
        String expr = "method(" + methodExpr + ")";
        return new AnnotationIntroduction(expr, annotationExpr, invisible);
    }

    public static AnnotationIntroduction createConstructorAnnotationIntroduction(String conExpr, String annotationExpr, boolean invisible) {
        String expr = "constructor(" + conExpr + ")";
        return new AnnotationIntroduction(expr, annotationExpr, invisible);
    }

    public static AnnotationIntroduction createFieldAnnotationIntroduction(String fieldExpr, String annotationExpr, boolean invisible) {
        String expr = "field(" + fieldExpr + ")";
        return new AnnotationIntroduction(expr, annotationExpr, invisible);
    }

    public static AnnotationIntroduction createClassAnnotationIntroduction(String classExpr, String annotationExpr, boolean invisible) {
        String expr = "class(" + classExpr + ")";
        return new AnnotationIntroduction(expr, annotationExpr, invisible);
    }

    public static AnnotationIntroduction createComplexAnnotationIntroduction(String expr, String annotationExpr, boolean invisible) {
        return new AnnotationIntroduction(expr, annotationExpr, invisible);
    }

    private AnnotationIntroduction(String expr, String annotationExpr, boolean invisible) {
        Object parser;
        this.invisible = invisible;
        this.originalAnnotationExpr = StringPropertyReplacer.replaceProperties(annotationExpr);
        this.originalExpression = expr;
        try {
            if (AspectManager.verbose && logger.isTraceEnabled()) {
                logger.trace("Creating annotation from " + this.originalAnnotationExpr);
            }
            parser = new AnnotationParser(new StringReader(this.originalAnnotationExpr));
            ASTStart start = ((AnnotationParser)parser).Start();
            this.annotation = (ASTAnnotation)start.jjtGetChild(0);
        }
        catch (org.jboss.annotation.factory.ast.ParseException e) {
            throw new RuntimeException(annotationExpr, e);
        }
        try {
            parser = new TypeExpressionParser(new StringReader(expr));
            this.target = ((TypeExpressionParser)parser).Start();
        }
        catch (ParseException e) {
            throw new RuntimeException(expr, e);
        }
    }

    public boolean matches(Advisor advisor, CtClass clazz) {
        AnnotationMatcher matcher = new AnnotationMatcher(advisor, clazz);
        return (Boolean)this.target.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, CtMethod method) {
        AnnotationMatcher matcher = new AnnotationMatcher(advisor, method);
        return (Boolean)this.target.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, CtConstructor con) {
        AnnotationMatcher matcher = new AnnotationMatcher(advisor, con);
        return (Boolean)this.target.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, CtField field) {
        AnnotationMatcher matcher = new AnnotationMatcher(advisor, field);
        return (Boolean)this.target.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, Class<?> clazz) {
        AnnotationMatcher matcher = new AnnotationMatcher(advisor, clazz);
        return (Boolean)this.target.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, Method method) {
        AnnotationMatcher matcher = new AnnotationMatcher(advisor, method);
        return (Boolean)this.target.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, Constructor<?> con) {
        AnnotationMatcher matcher = new AnnotationMatcher(advisor, con);
        return (Boolean)this.target.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, Field field) {
        AnnotationMatcher matcher = new AnnotationMatcher(advisor, field);
        return (Boolean)this.target.jjtAccept(matcher, null);
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    public String getOriginalAnnotationExpr() {
        return this.originalAnnotationExpr;
    }

    public ASTAnnotation getAnnotation() {
        return this.annotation;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public org.jboss.aop.pointcut.ast.ASTStart getTarget() {
        return this.target;
    }
}

