/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.io.Serializable;
import javassist.CtClass;
import javassist.Modifier;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistArrayInfoImpl
extends JavassistTypeInfo
implements ArrayInfo {
    private static final long serialVersionUID = 9195834689976459024L;
    static final AnnotationValue[] UNKNOWN_ANNOTATIONS = new AnnotationValue[0];
    private volatile int modifiers;
    protected final TypeInfo componentType;
    protected final int hash;

    private static String getName(TypeInfo componentType) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        TypeInfo temp = componentType;
        while (temp.isArray()) {
            builder.append("[");
            temp = ((JavassistArrayInfoImpl)temp).componentType;
        }
        if (temp.isPrimitive()) {
            String encodedName = PrimitiveInfo.getPrimativeArrayType(temp.getName());
            builder.append(encodedName);
        } else {
            builder.append("L").append(temp.getName()).append(";");
        }
        return builder.toString();
    }

    JavassistArrayInfoImpl(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class<? extends Object> clazz, TypeInfo componentType) {
        super(factory, JavassistArrayInfoImpl.getName(componentType), ctClass, clazz);
        this.componentType = componentType;
        this.hash = this.calculateHash();
    }

    @Override
    public TypeInfo getComponentType() {
        return this.componentType;
    }

    @Override
    public AnnotationValue getAnnotation(String name) {
        return null;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return UNKNOWN_ANNOTATIONS;
    }

    @Override
    public boolean isAnnotationPresent(String name) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayInfo)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayInfo arrayInfo = (ArrayInfo)o;
        return this.componentType.equals(arrayInfo.getComponentType());
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    protected int calculateHash() {
        int result = super.hashCode();
        result = 29 * result + this.componentType.hashCode();
        return result;
    }

    @Override
    public InterfaceInfo[] getGenericInterfaces() {
        return this.getInterfaces();
    }

    @Override
    public InterfaceInfo[] getInterfaces() {
        InterfaceInfo cloneable = (InterfaceInfo)this.getFactory().get((Class)Cloneable.class);
        InterfaceInfo serializable = (InterfaceInfo)this.getFactory().get((Class)Serializable.class);
        return new InterfaceInfo[]{cloneable, serializable};
    }

    @Override
    public int getModifiers() {
        if (this.modifiers == 0) {
            TypeInfo info = this.componentType;
            if (info.isArray()) {
                this.modifiers = ((ClassInfo)info).getModifiers();
            } else {
                int mod = 0;
                if (this.componentType instanceof ClassInfo) {
                    int typeModifiers = ((ClassInfo)this.componentType).getModifiers();
                    if (Modifier.isPublic(typeModifiers)) {
                        mod = 1;
                    } else if (Modifier.isProtected(typeModifiers)) {
                        mod = 4;
                    } else if (Modifier.isPrivate(typeModifiers)) {
                        mod = 2;
                    }
                } else if (this.componentType instanceof PrimitiveInfo) {
                    mod = 1;
                }
                mod |= 0x10;
                this.modifiers = mod |= 0x400;
            }
        }
        return this.modifiers;
    }
}

