/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotationoverride;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassContainer;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.annotationoverride.Other;
import org.jboss.test.aop.annotationoverride.OtherAnnotation;
import org.jboss.test.aop.annotationoverride.OtherMD;
import org.jboss.test.aop.annotationoverride.OtherMDImpl;
import org.jboss.test.aop.annotationoverride.Proxied;
import org.jboss.test.aop.annotationoverride.Some;
import org.jboss.test.aop.annotationoverride.SomeAnnotation;
import org.jboss.test.aop.annotationoverride.SomeMD;
import org.jboss.test.aop.annotationoverride.SomeMDImpl;
import org.jboss.test.aop.annotationoverride.Woven;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationOverrideTestCase
extends AOPTestWithSetup {
    public AnnotationOverrideTestCase(String arg0) {
        super(arg0);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AnnotationOverrideTestCase");
        suite.addTestSuite(AnnotationOverrideTestCase.class);
        return suite;
    }

    public void testWovenClassNoMetaData() throws Exception {
        this.runTests(false);
    }

    public void testWovenClassWithMetaData() throws Exception {
        this.runTests(true);
    }

    public void testClassContainerProxiedClass() throws Exception {
        ClassContainer container = new ClassContainer("test", AspectManager.instance());
        container.setClass(Proxied.class);
        container.initializeClassContainer();
        Some some = (Some)container.resolveTypedAnnotation(Some.class);
        AnnotationOverrideTestCase.assertNotNull((Object)some);
        some = (Some)container.resolveAnnotation(Some.class);
        AnnotationOverrideTestCase.assertNotNull((Object)some);
        Other other = (Other)container.resolveTypedAnnotation(Other.class);
        AnnotationOverrideTestCase.assertNull((Object)other);
        other = (Other)container.resolveAnnotation(Other.class);
        AnnotationOverrideTestCase.assertNull((Object)other);
        Method m = Proxied.class.getDeclaredMethod("method", new Class[0]);
        some = (Some)container.resolveTypedAnnotation(m, Some.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        some = (Some)container.resolveAnnotation(m, Some.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        other = (Other)container.resolveTypedAnnotation(m, Other.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        other = (Other)container.resolveAnnotation(m, Other.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        AnnotationOverrideTestCase.assertEquals((String)"method", (String)other.value());
    }

    private void runTests(boolean useMetaData) throws Exception {
        OtherMD otherMD;
        SomeMD someMD;
        Woven woven = new Woven();
        Advisor advisor = ((Advised)woven)._getAdvisor();
        Method m = Woven.class.getDeclaredMethod("method", new Class[0]);
        Field f = Woven.class.getDeclaredField("field");
        Constructor c = Woven.class.getDeclaredConstructor(new Class[0]);
        if (useMetaData) {
            Annotation[] classAnnotations = new Annotation[]{new SomeMDImpl()};
            Annotation[] ctorAnnotations = new Annotation[]{new OtherMDImpl("ctor")};
            Annotation[] methodAnnotations = new Annotation[]{new OtherMDImpl("method")};
            Annotation[] fieldAnnotations = new Annotation[]{new OtherMDImpl("field")};
            this.setupMetaData(advisor, c, m, f, classAnnotations, ctorAnnotations, methodAnnotations, fieldAnnotations);
        }
        Some some = (Some)advisor.resolveTypedAnnotation(Some.class);
        AnnotationOverrideTestCase.assertNotNull((Object)some);
        some = (Some)advisor.resolveAnnotation(Some.class);
        AnnotationOverrideTestCase.assertNotNull((Object)some);
        Other other = (Other)advisor.resolveTypedAnnotation(Other.class);
        AnnotationOverrideTestCase.assertNull((Object)other);
        other = (Other)advisor.resolveAnnotation(Other.class);
        AnnotationOverrideTestCase.assertNull((Object)other);
        SomeAnnotation someAnn = (SomeAnnotation)advisor.resolveTypedAnnotation(SomeAnnotation.class);
        AnnotationOverrideTestCase.assertNotNull((Object)someAnn);
        someAnn = (SomeAnnotation)advisor.resolveAnnotation(SomeAnnotation.class);
        AnnotationOverrideTestCase.assertNotNull((Object)someAnn);
        OtherAnnotation otherAnn = (OtherAnnotation)advisor.resolveTypedAnnotation(OtherAnnotation.class);
        AnnotationOverrideTestCase.assertNull((Object)otherAnn);
        otherAnn = (OtherAnnotation)advisor.resolveAnnotation(OtherAnnotation.class);
        AnnotationOverrideTestCase.assertNull((Object)otherAnn);
        if (useMetaData) {
            someMD = (SomeMD)advisor.resolveTypedAnnotation(SomeMD.class);
            AnnotationOverrideTestCase.assertNotNull((Object)someMD);
            someMD = (SomeMD)advisor.resolveAnnotation(SomeMD.class);
            AnnotationOverrideTestCase.assertNotNull((Object)someMD);
            otherMD = (OtherMD)advisor.resolveTypedAnnotation(OtherMD.class);
            AnnotationOverrideTestCase.assertNull((Object)otherMD);
            otherMD = (OtherMD)advisor.resolveAnnotation(OtherMD.class);
            AnnotationOverrideTestCase.assertNull((Object)otherMD);
        }
        some = (Some)advisor.resolveTypedAnnotation(m, Some.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        some = (Some)advisor.resolveAnnotation(m, Some.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        other = (Other)advisor.resolveTypedAnnotation(m, Other.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        other = (Other)advisor.resolveAnnotation(m, Other.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        AnnotationOverrideTestCase.assertEquals((String)"method", (String)other.value());
        someAnn = (SomeAnnotation)advisor.resolveTypedAnnotation(m, SomeAnnotation.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        someAnn = (SomeAnnotation)advisor.resolveAnnotation(m, SomeAnnotation.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        otherAnn = (OtherAnnotation)advisor.resolveTypedAnnotation(m, OtherAnnotation.class);
        AnnotationOverrideTestCase.assertNotNull((Object)otherAnn);
        otherAnn = (OtherAnnotation)advisor.resolveAnnotation(m, OtherAnnotation.class);
        AnnotationOverrideTestCase.assertNotNull((Object)otherAnn);
        AnnotationOverrideTestCase.assertEquals((String)"method", (String)otherAnn.value());
        if (useMetaData) {
            someMD = (SomeMD)advisor.resolveTypedAnnotation(m, SomeMD.class);
            AnnotationOverrideTestCase.assertNull((Object)someMD);
            someMD = (SomeMD)advisor.resolveAnnotation(m, SomeMD.class);
            AnnotationOverrideTestCase.assertNull((Object)someMD);
            otherMD = (OtherMD)advisor.resolveTypedAnnotation(m, OtherMD.class);
            AnnotationOverrideTestCase.assertNotNull((Object)otherMD);
            otherMD = (OtherMD)advisor.resolveAnnotation(m, OtherMD.class);
            AnnotationOverrideTestCase.assertNotNull((Object)otherMD);
            AnnotationOverrideTestCase.assertEquals((String)"method", (String)otherMD.value());
        }
        some = (Some)advisor.resolveTypedAnnotation(f, Some.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        some = (Some)advisor.resolveAnnotation(f, Some.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        other = (Other)advisor.resolveTypedAnnotation(f, Other.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        other = (Other)advisor.resolveAnnotation(f, Other.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        AnnotationOverrideTestCase.assertEquals((String)"field", (String)other.value());
        someAnn = (SomeAnnotation)advisor.resolveTypedAnnotation(f, SomeAnnotation.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        someAnn = (SomeAnnotation)advisor.resolveAnnotation(f, SomeAnnotation.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        otherAnn = (OtherAnnotation)advisor.resolveTypedAnnotation(f, OtherAnnotation.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        otherAnn = (OtherAnnotation)advisor.resolveAnnotation(f, OtherAnnotation.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        AnnotationOverrideTestCase.assertEquals((String)"field", (String)other.value());
        if (useMetaData) {
            someMD = (SomeMD)advisor.resolveTypedAnnotation(f, SomeMD.class);
            AnnotationOverrideTestCase.assertNull((Object)someMD);
            someMD = (SomeMD)advisor.resolveAnnotation(f, SomeMD.class);
            AnnotationOverrideTestCase.assertNull((Object)someMD);
            otherMD = (OtherMD)advisor.resolveTypedAnnotation(f, OtherMD.class);
            AnnotationOverrideTestCase.assertNotNull((Object)otherMD);
            otherMD = (OtherMD)advisor.resolveAnnotation(f, OtherMD.class);
            AnnotationOverrideTestCase.assertNotNull((Object)otherMD);
            AnnotationOverrideTestCase.assertEquals((String)"field", (String)otherMD.value());
        }
        some = (Some)advisor.resolveTypedAnnotation(c, Some.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        some = (Some)advisor.resolveAnnotation(c, Some.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        other = (Other)advisor.resolveTypedAnnotation(c, Other.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        other = (Other)advisor.resolveAnnotation(c, Other.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        AnnotationOverrideTestCase.assertEquals((String)"ctor", (String)other.value());
        someAnn = (SomeAnnotation)advisor.resolveTypedAnnotation(c, SomeAnnotation.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        someAnn = (SomeAnnotation)advisor.resolveAnnotation(c, SomeAnnotation.class);
        AnnotationOverrideTestCase.assertNull((Object)some);
        otherAnn = (OtherAnnotation)advisor.resolveTypedAnnotation(c, OtherAnnotation.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        otherAnn = (OtherAnnotation)advisor.resolveAnnotation(c, OtherAnnotation.class);
        AnnotationOverrideTestCase.assertNotNull((Object)other);
        AnnotationOverrideTestCase.assertEquals((String)"ctor", (String)other.value());
        if (useMetaData) {
            someMD = (SomeMD)advisor.resolveTypedAnnotation(c, SomeMD.class);
            AnnotationOverrideTestCase.assertNull((Object)someMD);
            someMD = (SomeMD)advisor.resolveAnnotation(c, SomeMD.class);
            AnnotationOverrideTestCase.assertNull((Object)someMD);
            otherMD = (OtherMD)advisor.resolveTypedAnnotation(c, OtherMD.class);
            AnnotationOverrideTestCase.assertNotNull((Object)otherMD);
            otherMD = (OtherMD)advisor.resolveAnnotation(c, OtherMD.class);
            AnnotationOverrideTestCase.assertNotNull((Object)otherMD);
            AnnotationOverrideTestCase.assertEquals((String)"ctor", (String)otherMD.value());
        }
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(SomeAnnotation.class.getName()));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(Woven.class, SomeAnnotation.class.getName()));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(Woven.class, SomeAnnotation.class));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(Some.class.getName()));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(Woven.class, Some.class.getName()));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(Woven.class, Some.class));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(Other.class.getName()));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(Woven.class, Other.class.getName()));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(Woven.class, Other.class));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(c, Other.class.getName()));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(c, Some.class.getName()));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(c, SomeAnnotation.class.getName()));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(f, Other.class.getName()));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(f, Some.class.getName()));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(f, SomeAnnotation.class.getName()));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(m, Other.class.getName()));
        AnnotationOverrideTestCase.assertTrue((boolean)advisor.hasAnnotation(m, Other.class));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(m, Some.class.getName()));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(m, Some.class));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(m, SomeAnnotation.class.getName()));
        AnnotationOverrideTestCase.assertFalse((boolean)advisor.hasAnnotation(m, SomeAnnotation.class));
    }

    private void setupMetaData(Advisor advisor, Constructor<?> c, Method m, Field f, Annotation[] classAnnotations, Annotation[] ctorAnnotations, Annotation[] methodAnnotations, Annotation[] fieldAnnotations) {
        BasicMetaDataRepository repository = new BasicMetaDataRepository();
        ScopeKey scopeKey = ScopeKey.DEFAULT_SCOPE.clone();
        scopeKey.addScope(CommonLevels.INSTANCE, (Object)"Test");
        scopeKey.addScope(CommonLevels.CLASS, (Object)advisor.getClazz().getName());
        scopeKey.addScope(CommonLevels.WORK, (Object)String.valueOf(((Object)((Object)this)).hashCode()));
        ScopeKey key = scopeKey;
        ScopeKey mutableScope = new ScopeKey(CommonLevels.INSTANCE, (Object)"Test".toString());
        MemoryMetaDataLoader mutable = new MemoryMetaDataLoader(mutableScope);
        repository.addMetaDataRetrieval((MetaDataRetrieval)mutable);
        this.addClassAnnotations(advisor.getClazz(), mutable, classAnnotations);
        this.addMethodAnnotations(m, mutable, methodAnnotations);
        this.addFieldAnnotations(f, mutable, fieldAnnotations);
        this.addConstructorAnnotations(c, mutable, ctorAnnotations);
        MetaDataRetrievalToMetaDataBridge metadata = new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)mutable);
        advisor.setMetadata((MetaData)metadata);
    }

    private void addClassAnnotations(Class<?> clazz, MemoryMetaDataLoader mutable, Annotation[] extraAnnotations) {
        Annotation[] anns;
        for (Annotation ann : anns = clazz.getAnnotations()) {
            mutable.addAnnotation(ann);
        }
        for (Annotation ann : extraAnnotations) {
            mutable.addAnnotation(ann);
        }
    }

    private void addMethodAnnotations(Method m, MemoryMetaDataLoader mutable, Annotation[] extraAnnotations) {
        this.addJoinpointAnnotations(mutable, (Signature)new MethodSignature(m), m.getName(), m.getAnnotations(), extraAnnotations);
    }

    private void addFieldAnnotations(Field f, MemoryMetaDataLoader mutable, Annotation[] extraAnnotations) {
        this.addJoinpointAnnotations(mutable, (Signature)new FieldSignature(f), f.getName(), f.getAnnotations(), extraAnnotations);
    }

    private void addConstructorAnnotations(Constructor<?> c, MemoryMetaDataLoader mutable, Annotation[] extraAnnotations) {
        this.addJoinpointAnnotations(mutable, (Signature)new ConstructorSignature(c), c.getName(), c.getAnnotations(), extraAnnotations);
    }

    private void addJoinpointAnnotations(MemoryMetaDataLoader mutable, Signature sig, String name, Annotation[] annotations, Annotation[] extraAnnotations) {
        ScopeKey scope = new ScopeKey(CommonLevels.JOINPOINT_OVERRIDE, (Object)name);
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(scope);
        for (Annotation ann : annotations) {
            loader.addAnnotation(ann);
        }
        for (Annotation ann : extraAnnotations) {
            loader.addAnnotation(ann);
        }
        mutable.addComponentMetaDataRetrieval(sig, (MetaDataRetrieval)loader);
    }
}

