/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.container;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.container.Child;
import org.jboss.test.aop.container.TestContainer;
import org.jboss.test.aop.container.TestInterceptor;

public class ContainerTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)ContainerTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ContainerTestCase");
        suite.addTestSuite(ContainerTestCase.class);
        return suite;
    }

    public ContainerTestCase(String name) {
        super(name);
    }

    public void testContainerWithNoChainOverriding() throws Throwable {
        this.invokeContainer(false);
    }

    public void testContainerWithChainOverriding() throws Throwable {
        this.invokeContainer(true);
    }

    public void testMethodInterceptorsPopulated() throws Throwable {
        AspectManager.maintainAdvisorMethodInterceptors = true;
        this.checkMethodInterceptors(true);
    }

    public void testMethodInterceptorsNotPopulated() throws Throwable {
        AspectManager.maintainAdvisorMethodInterceptors = false;
        this.checkMethodInterceptors(false);
    }

    private void invokeContainer(boolean overriding) throws Throwable {
        AspectManager manager = AspectManager.instance();
        ContainerWithChainOverriding container = overriding ? new ContainerWithChainOverriding("X", manager) : new ClassContainer("X", manager);
        container.setClass(Child.class);
        container.initializeClassContainer();
        Child child = new Child();
        MethodInvocation invocation = this.getMethodInvocation(container, "childMethod", child);
        TestInterceptor.invoked = false;
        container.dynamicInvoke(child, (Invocation)invocation);
        ContainerTestCase.assertTrue((boolean)TestInterceptor.invoked);
        invocation = this.getMethodInvocation(container, "parentMethod", child);
        TestInterceptor.invoked = false;
        container.dynamicInvoke(child, (Invocation)invocation);
        ContainerTestCase.assertEquals((boolean)overriding, (boolean)TestInterceptor.invoked);
    }

    private void checkMethodInterceptors(boolean maintainAdvisorMethodInterceptors) throws Exception {
        AspectManager manager = AspectManager.instance();
        TestContainer advisor = new TestContainer("X", manager);
        advisor.setClass(Child.class);
        advisor.initializeClassContainer();
        Child child = new Child();
        Method method = child.getClass().getMethod("childMethod", new Class[0]);
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInfo info = advisor.getMethodInfo(hash);
        TLongObjectHashMap methodInterceptors = advisor.getMethodInterceptors();
        if (!maintainAdvisorMethodInterceptors) {
            ContainerTestCase.assertNull((Object)methodInterceptors);
        } else {
            ContainerTestCase.assertNotNull((Object)methodInterceptors);
            MethodInfo info2 = (MethodInfo)methodInterceptors.get(hash);
            ContainerTestCase.assertNotNull((Object)info2);
            ContainerTestCase.assertEquals((Object)info, (Object)info2);
        }
    }

    private MethodInvocation getMethodInvocation(ClassContainer advisor, String methodName, Object target) throws Exception {
        Method method = target.getClass().getMethod(methodName, new Class[0]);
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInfo info = advisor.getMethodInfo(hash);
        Interceptor[] interceptors = info.getInterceptors();
        MethodInvocation invocation = new MethodInvocation(interceptors, hash, method, method, (Advisor)advisor);
        invocation.setTargetObject(target);
        invocation.setArguments(new Object[0]);
        return invocation;
    }

    static class ContainerWithChainOverriding
    extends ClassContainer {
        public ContainerWithChainOverriding(String name, AspectManager manager) {
            super(name, manager);
            super.setChainOverridingForInheritedMethods(true);
        }
    }
}

