/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.field;

import java.lang.reflect.Field;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.field.FieldPerJoinpointInterceptor;
import org.jboss.test.aop.field.POJO;
import org.jboss.test.aop.field.ScopedPojo;
import org.jboss.test.aop.field.SetOrGetOnlyPOJO;
import org.jboss.test.aop.field.SubPOJO;
import org.jboss.test.aop.field.SubSubPOJO;
import org.jboss.test.aop.field.TraceInterceptor;

public class FieldTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)FieldTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("FieldTestCase");
        suite.addTestSuite(FieldTestCase.class);
        return suite;
    }

    public FieldTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testField() {
        System.out.println("*** testField");
        SubPOJO spojo = new SubPOJO(4);
        FieldTestCase.assertEquals((String)"Field is not set correctly", (int)spojo.getPOJOField(), (int)(spojo.getSubPOJOField() / 2));
    }

    public void testField2() {
        System.out.println("*** testField2");
        SubSubPOJO spojo = new SubSubPOJO(4);
        FieldTestCase.assertEquals((String)"Field is not set correctly", (int)(spojo.getSubSubPOJOField() / 2), (int)spojo.getSubPOJOField());
    }

    public void testFieldInheritance() {
        System.out.println("*** testFieldInheritance");
        SubSubPOJO pojo = new SubSubPOJO(4);
        TraceInterceptor.intercepted = false;
        pojo.mine = 5;
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)5, (int)pojo.mine);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        pojo.pojoInherited = 6;
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)6, (int)pojo.pojoInherited);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        pojo.subpojoInherited = 7;
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)7, (int)pojo.subpojoInherited);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
    }

    public void testFieldInheritanceInSubClass() {
        SubSubPOJO pojo = new SubSubPOJO(5);
        TraceInterceptor.intercepted = false;
        pojo.updateMine(5);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)5, (int)pojo.useMine());
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        pojo.updatePojoInherited(6);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)6, (int)pojo.usePojoInherited());
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        pojo.updateSubPojoInherited(7);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)7, (int)pojo.useSubPojoInherited());
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
    }

    public void testSuperPrivateField() {
        POJO pojo = new POJO();
        TraceInterceptor.intercepted = false;
        pojo.setPrivate(5);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)5, (int)pojo.getPrivate());
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        SubPOJO sub = new SubPOJO();
        TraceInterceptor.intercepted = false;
        sub.setPrivate(5);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)5, (int)sub.getPrivate());
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
    }

    public void testPerJoinpoint() throws Exception {
        ScopedPojo pojo1 = new ScopedPojo();
        ScopedPojo pojo2 = new ScopedPojo();
        FieldPerJoinpointInterceptor.last = null;
        pojo1.field1 = 10;
        FieldTestCase.assertNotNull((Object)FieldPerJoinpointInterceptor.last);
        FieldPerJoinpointInterceptor fieldWrite1 = FieldPerJoinpointInterceptor.last;
        FieldPerJoinpointInterceptor.last = null;
        int x = pojo1.field1;
        FieldTestCase.assertNotNull((Object)FieldPerJoinpointInterceptor.last);
        FieldPerJoinpointInterceptor fieldRead1 = FieldPerJoinpointInterceptor.last;
        FieldTestCase.assertSame((Object)fieldRead1, (Object)fieldWrite1);
        FieldPerJoinpointInterceptor.last = null;
        pojo2.field1 = 10;
        FieldTestCase.assertNotNull((Object)FieldPerJoinpointInterceptor.last);
        FieldPerJoinpointInterceptor fieldWrite2 = FieldPerJoinpointInterceptor.last;
        FieldTestCase.assertNotSame((Object)fieldRead1, (Object)fieldWrite2);
        FieldPerJoinpointInterceptor.last = null;
        pojo1.field2 = 10;
        FieldTestCase.assertNotNull((Object)FieldPerJoinpointInterceptor.last);
        FieldPerJoinpointInterceptor field2Write1 = FieldPerJoinpointInterceptor.last;
        FieldTestCase.assertNotSame((Object)field2Write1, (Object)fieldRead1);
        FieldPerJoinpointInterceptor.last = null;
        ScopedPojo.staticField = 10;
        FieldTestCase.assertNotNull((Object)FieldPerJoinpointInterceptor.last);
        FieldPerJoinpointInterceptor staticWrite = FieldPerJoinpointInterceptor.last;
        FieldPerJoinpointInterceptor.last = null;
        x = ScopedPojo.staticField;
        FieldTestCase.assertEquals((Object)staticWrite, (Object)FieldPerJoinpointInterceptor.last);
        Field field1 = pojo1.getClass().getField("field1");
        Field field2 = pojo1.getClass().getField("field2");
        Field staticField = pojo1.getClass().getField("staticField");
        AspectDefinition def = AspectManager.instance().getAspectDefinition("field");
        FieldTestCase.assertNotNull((Object)def);
        InstanceAdvisor ia1 = ((Advised)pojo1)._getInstanceAdvisor();
        InstanceAdvisor ia2 = ((Advised)pojo2)._getInstanceAdvisor();
        FieldPerJoinpointInterceptor ia1Field1 = (FieldPerJoinpointInterceptor)ia1.getPerInstanceJoinpointAspect((Joinpoint)new FieldJoinpoint(field1), def);
        FieldTestCase.assertNotNull((Object)ia1Field1);
        FieldPerJoinpointInterceptor ia2Field1 = (FieldPerJoinpointInterceptor)ia2.getPerInstanceJoinpointAspect((Joinpoint)new FieldJoinpoint(field1), def);
        FieldTestCase.assertNotNull((Object)ia2Field1);
        FieldPerJoinpointInterceptor ia1Field2 = (FieldPerJoinpointInterceptor)ia1.getPerInstanceJoinpointAspect((Joinpoint)new FieldJoinpoint(field2), def);
        FieldTestCase.assertNotNull((Object)ia1Field2);
        FieldTestCase.assertSame((Object)fieldRead1, (Object)ia1Field1);
        FieldTestCase.assertSame((Object)fieldWrite2, (Object)ia2Field1);
        FieldTestCase.assertSame((Object)field2Write1, (Object)ia1Field2);
        AspectDefinition statDef = AspectManager.instance().getAspectDefinition("staticField");
        FieldTestCase.assertNotNull((Object)statDef);
        FieldPerJoinpointInterceptor advStatic = (FieldPerJoinpointInterceptor)((ClassAdvisor)((Advised)pojo1)._getAdvisor()).getFieldAspect(new FieldJoinpoint(staticField), statDef);
        FieldTestCase.assertSame((Object)advStatic, (Object)staticWrite);
    }

    public void testSetOnly() throws Exception {
        SetOrGetOnlyPOJO pojo = new SetOrGetOnlyPOJO();
        TraceInterceptor.intercepted = false;
        pojo.setOnly = 10;
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)10, (int)pojo.setOnly);
        FieldTestCase.assertFalse((boolean)TraceInterceptor.intercepted);
    }

    public void testGetOnly() throws Exception {
        SetOrGetOnlyPOJO pojo = new SetOrGetOnlyPOJO();
        TraceInterceptor.intercepted = false;
        pojo.getOnly = 10;
        FieldTestCase.assertFalse((boolean)TraceInterceptor.intercepted);
        TraceInterceptor.intercepted = false;
        FieldTestCase.assertEquals((int)10, (int)pojo.getOnly);
        FieldTestCase.assertTrue((boolean)TraceInterceptor.intercepted);
    }
}

