/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.genericintroduction;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aop.AspectManager;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.genericintroduction.Interface1;
import org.jboss.test.aop.genericintroduction.NoSuperclassNoInterfacesPOJO;
import org.jboss.test.aop.genericintroduction.UncheckedNoSuperclassNoInterfacesPOJO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericIntroductionSignatureTestCase
extends AOPTestWithSetup {
    public GenericIntroductionSignatureTestCase(String arg0) {
        super(arg0);
    }

    public void testNoSuperclassNoInterfacesPOJO() {
        AspectManager.debugClasses = true;
        NoSuperclassNoInterfacesPOJO pojo = new NoSuperclassNoInterfacesPOJO();
        UncheckedNoSuperclassNoInterfacesPOJO control = new UncheckedNoSuperclassNoInterfacesPOJO();
        Set<Class<?>> interfaces = this.createSet(pojo.getClass().getInterfaces());
        GenericIntroductionSignatureTestCase.assertTrue((boolean)interfaces.contains(Interface1.class));
        boolean found = false;
        for (Method m : pojo.getClass().getDeclaredMethods()) {
            if (!m.getName().equals("introduced1")) continue;
            found = true;
            break;
        }
        GenericIntroductionSignatureTestCase.assertTrue((boolean)found);
        this.testIntroducedMethods(pojo, control, Interface1.class);
    }

    private void testIntroducedMethods(Object woven, Object control, Class<?> iface) {
        GenericIntroductionSignatureTestCase.assertTrue((boolean)this.getInterfaces(woven).contains(iface));
        GenericIntroductionSignatureTestCase.assertTrue((boolean)this.getInterfaces(control).contains(iface));
        Method wovenMethod = this.getInterfaceMethod(woven, iface);
        Method controlMethod = this.getInterfaceMethod(control, iface);
        GenericIntroductionSignatureTestCase.assertEquals((int)controlMethod.getModifiers(), (int)wovenMethod.getModifiers());
        this.assertEquals(controlMethod.getParameterTypes(), wovenMethod.getParameterTypes());
        GenericIntroductionSignatureTestCase.assertEquals(controlMethod.getReturnType(), wovenMethod.getReturnType());
        this.assertEquals(controlMethod.getExceptionTypes(), wovenMethod.getExceptionTypes());
        GenericIntroductionSignatureTestCase.assertEquals((Object)controlMethod.getGenericReturnType(), (Object)wovenMethod.getGenericReturnType());
        this.assertEquals(controlMethod.getGenericParameterTypes(), wovenMethod.getGenericParameterTypes());
        this.assertEquals(controlMethod.getGenericExceptionTypes(), wovenMethod.getGenericExceptionTypes());
    }

    private Method getInterfaceMethod(Object o, Class<?> iface) {
        Method[] methods = iface.getDeclaredMethods();
        GenericIntroductionSignatureTestCase.assertTrue((methods.length == 1 ? 1 : 0) != 0);
        for (Method m : o.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(methods[0].getName())) continue;
            return m;
        }
        GenericIntroductionSignatureTestCase.fail((String)"Could not find method");
        return null;
    }

    private Set<Class<?>> getInterfaces(Object o) {
        return this.createSet(o.getClass().getInterfaces());
    }

    private Set<Class<?>> createSet(Class<?>[] classes) {
        if (classes == null || classes.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet(Arrays.asList(classes));
    }
}

