/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.memoryleaks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.jboss.profiler.jvmti.JVMTIInterface;

public class MemoryLeakTester
extends TestCase {
    public MemoryLeakTester(String name) {
        super(name);
    }

    public MemoryLeakTester() {
    }

    private static void printVariables() {
        Properties props = System.getProperties();
        Enumeration<Object> iter = props.keys();
        System.out.println("properties:");
        while (iter.hasMoreElements()) {
            Object key = iter.nextElement();
            System.out.println(key + "=" + props.get(key));
            System.out.println();
        }
    }

    private static ClassLoader newClassLoader() throws Exception {
        URL classLocation = MemoryLeakTester.class.getProtectionDomain().getCodeSource().getLocation();
        StringTokenizer tokenString = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        String pathIgnore = System.getProperty("path.ignore");
        if (pathIgnore == null) {
            pathIgnore = classLocation.toString();
        } else {
            System.out.println("pathIgnore=" + pathIgnore);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenString.hasMoreElements()) {
            String value = tokenString.nextToken();
            URL itemLocation = new File(value).toURI().toURL();
            if (itemLocation.equals(classLocation) || itemLocation.toString().equals(pathIgnore)) continue;
            urls.add(itemLocation);
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        URLClassLoader masterClassLoader = URLClassLoader.newInstance(urlArray, null);
        URLClassLoader appClassLoader = URLClassLoader.newInstance(new URL[]{classLocation}, masterClassLoader);
        return appClassLoader;
    }

    private void undeploy(Class xmlLoader) throws Exception {
        String strurl = System.getProperty("jboss.aop.path");
        MemoryLeakTester.assertNotNull((String)"Property jboss.aop.path should be defined", (Object)strurl);
        strurl = strurl.replace('\\', '/');
        URL url = new URL("file:/" + strurl);
        Method method = xmlLoader.getDeclaredMethod("undeployXML", URL.class);
        method.invoke(null, url);
    }

    public void testWithClassLoader() throws Exception {
        WeakReference<ClassLoader> weakReferenceOnLoader = null;
        Class<?> xmlLoader = null;
        try {
            ClassLoader oldloader = Thread.currentThread().getContextClassLoader();
            ClassLoader loader = MemoryLeakTester.newClassLoader();
            weakReferenceOnLoader = new WeakReference<ClassLoader>(loader);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> testClass = loader.loadClass("org.jboss.test.aop.memoryleaks.Test");
            MemoryLeakTester.assertSame((String)"Fix your classpath, this test is not valid", (Object)loader, (Object)testClass.getClassLoader());
            MemoryLeakTester.assertNotSame((Object)testClass.getClassLoader(), (Object)((Object)((Object)this)).getClass().getClassLoader());
            Class<?> aspectManagerClass = loader.loadClass("org.jboss.aop.AspectManager");
            MemoryLeakTester.assertNotSame((Object)aspectManagerClass.getClassLoader(), (Object)((Object)((Object)this)).getClass().getClassLoader());
            Class<?> pojoClass = loader.loadClass("org.jboss.test.aop.memoryleaks.POJO");
            MemoryLeakTester.assertNotSame((Object)pojoClass.getClassLoader(), (Object)((Object)((Object)this)).getClass().getClassLoader());
            Class<?> interceptorClass = loader.loadClass("org.jboss.test.aop.memoryleaks.TestInterceptor");
            MemoryLeakTester.assertNotSame((Object)interceptorClass.getClassLoader(), (Object)((Object)((Object)this)).getClass().getClassLoader());
            Class<?> aspectClass = loader.loadClass("org.jboss.test.aop.memoryleaks.TestAspect");
            MemoryLeakTester.assertNotSame((Object)interceptorClass.getClassLoader(), (Object)((Object)((Object)this)).getClass().getClassLoader());
            xmlLoader = loader.loadClass("org.jboss.aop.AspectXmlLoader");
            MemoryLeakTester.assertNotSame((Object)xmlLoader.getClassLoader(), (Object)loader);
            Class<?> aopinterceptorClass = loader.loadClass("org.jboss.aop.advice.Interceptor");
            MemoryLeakTester.assertSame((Object)aopinterceptorClass.getClassLoader(), (Object)xmlLoader.getClassLoader());
            Object pojo = null;
            pojo = pojoClass.newInstance();
            Method testMethod = null;
            testMethod = pojoClass.getMethod("method", new Class[0]);
            testMethod.invoke(pojo, new Object[0]);
            Field icptrIntercepted = interceptorClass.getDeclaredField("intercepted");
            Field aspectIntercepted = aspectClass.getDeclaredField("intercepted");
            MemoryLeakTester.assertTrue((boolean)icptrIntercepted.getBoolean(null));
            MemoryLeakTester.assertTrue((boolean)aspectIntercepted.getBoolean(null));
            icptrIntercepted.setBoolean(null, false);
            aspectIntercepted.setBoolean(null, false);
            this.undeploy(xmlLoader);
            testMethod.invoke(pojo, new Object[0]);
            MemoryLeakTester.assertFalse((boolean)icptrIntercepted.getBoolean(null));
            MemoryLeakTester.assertFalse((boolean)aspectIntercepted.getBoolean(null));
            this.unregisterClassLoader(aspectManagerClass, loader);
            icptrIntercepted = null;
            aspectIntercepted = null;
            loader = null;
            testClass = null;
            pojoClass = null;
            pojo = null;
            interceptorClass = null;
            aspectClass = null;
            testMethod = null;
            Thread.currentThread().setContextClassLoader(oldloader);
            MemoryLeakTester.assertEquals((int)1, (int)this.countInstances("org.jboss.aop.AspectManager"));
            this.checkUnload(weakReferenceOnLoader, "org.jboss.test.aop.memoryleaks.TestAspect");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        MemoryLeakTester.assertNotNull((String)"The masterClassLoader needs to keep a reference, only the customer's classLoader needs to go away", xmlLoader);
    }

    private void checkUnload(WeakReference weakReferenceOnLoader, String className) throws Exception {
        JVMTIInterface jvmti = new JVMTIInterface();
        if (jvmti.isActive()) {
            jvmti.forceReleaseOnSoftReferences();
            jvmti.forceGC();
            Class clazz = jvmti.getClassByName(className);
            if (clazz != null) {
                jvmti.heapSnapshot("snapshot", "mem");
                clazz = null;
                String report = jvmti.exploreClassReferences(className, 10, true, false, false, false, false);
                File outputfile = new File("./leaks-report.html");
                FileOutputStream outfile = new FileOutputStream(outputfile);
                PrintStream realoutput = new PrintStream(outfile);
                realoutput.println(report);
                realoutput.close();
                jvmti.forceGC();
                clazz = jvmti.getClassByName(className);
                if (clazz == null) {
                    System.out.println("Attention: After clearing every field on AspectManager, GC could release the classLoader");
                }
                MemoryLeakTester.fail((String)("Class " + className + " still referenced. Look at report for more details"));
            }
        }
        MemoryLeakTester.assertNull((String)"The classLoader is supposed to be released. Something is holding a reference. If you activate -agentlib:jbossAgent this testcase will generate a report with referenceHolders.", weakReferenceOnLoader.get());
    }

    public Field[] getDeclaredFields(Class clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class classIteration = clazz; classIteration != null; classIteration = classIteration.getSuperclass()) {
            Field[] fields = classIteration.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                list.add(fields[i]);
            }
        }
        return list.toArray(new Field[list.size()]);
    }

    private void clearEverySingleFieldOnInstances(String className) {
        System.out.println("Clearing " + className);
        JVMTIInterface jvmti = new JVMTIInterface();
        Class[] classes = jvmti.getLoadedClasses();
        Object[] objects = null;
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(className)) continue;
            Field[] fields = this.getDeclaredFields(classes[i]);
            objects = jvmti.getAllObjects(classes[i]);
            for (int j = 0; j < objects.length; ++j) {
                MemoryLeakTester.resetObject(objects[j], fields);
            }
            if (objects.length != 0) continue;
            MemoryLeakTester.resetObject(null, fields);
        }
        classes = null;
        objects = null;
    }

    private static void resetObject(Object object, Field[] fields) {
        for (int fieldN = 0; fieldN < fields.length; ++fieldN) {
            try {
                fields[fieldN].set(object, null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int countInstances(String name) {
        JVMTIInterface jvmti = new JVMTIInterface();
        int i = jvmti.getAllObjects(name).length;
        return i;
    }

    private void unregisterClassLoader(Class aspectManagerClass, ClassLoader loader) throws Exception {
        Method instance = aspectManagerClass.getDeclaredMethod("instance", new Class[0]);
        Object aspectManager = instance.invoke(null, new Object[0]);
        Method unregisterClassLoader = aspectManagerClass.getDeclaredMethod("unregisterClassLoader", ClassLoader.class);
        unregisterClassLoader.invoke(aspectManager, loader);
    }
}

