/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.precedence;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.precedence.Interceptions;
import org.jboss.test.aop.precedence.POJO;

public class PrecedenceTester
extends AOPTestWithSetup {
    static final Precedence[] precedences = new Precedence[]{new Precedence("SimpleInterceptor2", "TestAspect.advice"), new Precedence("SimpleInterceptor2", "SimpleInterceptor3"), new Precedence("SimpleInterceptor3", "TestAspect.advice"), new Precedence("TestAspect.advice", "TestAspect2.advice"), new Precedence("TestAspect.advice2", "TestAspect.advice3"), new Precedence("TestAspect.advice3", "TestAspect2.advice"), new Precedence("SimpleInterceptor", "SimpleInterceptor2"), new Precedence("TestAspect2.advice", "TestAspect3.advice")};
    private POJO pojo;

    public static Test suite() {
        TestSuite suite = new TestSuite("PrecedenceTester");
        suite.addTestSuite(PrecedenceTester.class);
        return suite;
    }

    public PrecedenceTester(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.pojo = new POJO();
        Interceptions.reset();
    }

    public void testConstructor() throws Exception {
        System.out.println("*** Invoke constructor");
        Interceptions.reset();
        new POJO();
        this.checkInterceptions(8);
    }

    public void testVarRead() {
        System.out.println("*** Invoke field read");
        Interceptions.reset();
        int i = this.pojo.var;
        this.checkInterceptions(10);
    }

    public void testVarWrite() {
        System.out.println("*** Invoke field write");
        Interceptions.reset();
        this.pojo.var = 1;
        this.checkInterceptions(10);
    }

    public void testOneMethod() {
        System.out.println("*** Invoke oneMethod");
        Interceptions.reset();
        this.pojo.oneMethod();
        this.checkInterceptions(10);
    }

    public void testTwoMethod() {
        Interceptions.reset();
        this.pojo.twoMethod();
        this.checkInterceptions(9);
    }

    public void testThreeMethod() {
        Interceptions.reset();
        this.pojo.threeMethod();
        this.checkInterceptions(7);
    }

    public void testFourMethod() {
        Interceptions.reset();
        this.pojo.fourMethod();
        this.checkInterceptions(9);
    }

    public void testFiveMethod() {
        Interceptions.reset();
        POJO.factoryMethod();
        this.checkInterceptions(7);
    }

    public void testSixMethod() {
        Interceptions.reset();
        this.pojo.sixMethod();
        this.checkInterceptions(7);
    }

    public void testSevenMethod() {
        Interceptions.reset();
        this.pojo.sevenMethod();
        this.checkInterceptions(6);
    }

    private void checkInterceptions(int expected) {
        ArrayList<String> intercepted = Interceptions.intercepted;
        PrecedenceTester.assertEquals((String)"Wrong number of interceptions", (int)expected, (int)intercepted.size());
        StringBuffer interceptedAdviceString = new StringBuffer(34);
        if (expected > 0) {
            Iterator<String> iterator = Interceptions.intercepted.iterator();
            interceptedAdviceString.append('\"').append(iterator.next());
            while (iterator.hasNext()) {
                interceptedAdviceString.append(", ").append(iterator.next());
            }
        }
        interceptedAdviceString.append('\"');
        for (Precedence precedence : precedences) {
            boolean foundSecondAdvice = false;
            for (String advice : Interceptions.intercepted) {
                if (advice.equals(precedence.firstAdvice)) {
                    PrecedenceTester.assertFalse((String)("Precedence rule not asserted: " + precedence.firstAdvice + " is after " + precedence.secondAdvice + " at chain " + interceptedAdviceString), (boolean)foundSecondAdvice);
                    continue;
                }
                if (!advice.equals(precedence.secondAdvice)) continue;
                foundSecondAdvice = true;
            }
        }
    }

    private static class Precedence {
        public String firstAdvice;
        public String secondAdvice;

        public Precedence(String firstAdvice, String secondAdvice) {
            this.firstAdvice = firstAdvice;
            this.secondAdvice = secondAdvice;
        }
    }
}

